/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.AbstractFlowExpression;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ValueException;
import openwfe.org.engine.functions.FunctionMap;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.workitem.BooleanAttribute;
import openwfe.org.engine.workitem.DoubleAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.IntegerAttribute;
import openwfe.org.engine.workitem.LongAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.misc.ArgParser;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public abstract class ValueUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$ValueUtils == null ? (class$openwfe$org$engine$expressions$ValueUtils = ValueUtils.class$("openwfe.org.engine.expressions.ValueUtils")) : class$openwfe$org$engine$expressions$ValueUtils).getName());
    private static final String VALUE = "value";
    private static final String FIELD_VALUE = "field-value";
    private static final String VARIABLE_VALUE = "variable-value";
    private static final String FUNCTION_VALUE = "function-value";
    private static final String FIELD_TARGET = "field";
    private static final String VARIABLE_TARGET = "variable";
    private static final String OVERRIDE = "override";
    private static final String TYPE = "type";
    public static final String F_RESULT = "__result__";
    private static final String T_LONG = "long";
    private static final String T_DOUBLE = "double";
    private static final String T_BOOLEAN = "boolean";
    private static final String T_INTEGER = "integer";
    private static final ArgParser argParser = new ArgParser();
    static /* synthetic */ Class class$openwfe$org$engine$expressions$ValueUtils;

    public static String executeFunction(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String string) {
        int n = string.indexOf("(");
        if (n < 0) {
            return ValueUtils.executeFunction(flowExpression, inFlowWorkItem, string + "()");
        }
        String string2 = string.substring(0, n);
        int n2 = string.lastIndexOf(")");
        String string3 = string.substring(n + 1, n2);
        String[] stringArray = argParser.parse(string3);
        FunctionMap functionMap = Definitions.getFunctionMap(flowExpression.context());
        return functionMap.eval(string2, flowExpression, inFlowWorkItem, stringArray);
    }

    public static String lookupConstant(String string) {
        int n = string.lastIndexOf(".");
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            try {
                Class<?> clazz = Class.forName(string2);
                Field field = clazz.getDeclaredField(string3);
                Object object = field.get(null);
                if (object != null) {
                    return object.toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "cannot lookup constant \"" + string + "\"";
    }

    public static Object determineValue(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem) throws ValueException {
        return ValueUtils.determineValue("", flowExpression, inFlowWorkItem);
    }

    public static Attribute determineWorkitemFragment(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem) throws ValueException {
        String string = flowExpression.lookupAttribute("__content__", inFlowWorkItem);
        if (string == null) {
            return null;
        }
        try {
            Element element = XmlUtils.extractXmlElement((String)string);
            element = XmlUtils.getFirstChild((Element)element);
            if (element == null) {
                return null;
            }
            return Definitions.getXmlCoder(flowExpression.context()).decodeAttribute(element);
        }
        catch (Exception exception) {
            throw new ValueException("Failed to extract workitem fragment", exception);
        }
    }

    public static Object determineValue(String string, FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem) throws ValueException {
        String string2 = flowExpression.lookupAttribute(string + VALUE, inFlowWorkItem);
        String string3 = flowExpression.lookupAttribute(string + FIELD_VALUE, inFlowWorkItem);
        String string4 = flowExpression.lookupAttribute(string + VARIABLE_VALUE, inFlowWorkItem);
        if (string2 == null && string.equals("") && (string2 = flowExpression.lookupAttribute("__value__", inFlowWorkItem)) == null && flowExpression.getAttributes().containsKey("__content__")) {
            return ValueUtils.determineWorkitemFragment(flowExpression, inFlowWorkItem);
        }
        String string5 = flowExpression.lookupAttribute(string + FUNCTION_VALUE, inFlowWorkItem);
        if (string5 != null) {
            string5 = ValueUtils.executeFunction(flowExpression, inFlowWorkItem, string5);
        }
        if (string2 == null && string3 == null && string4 == null && string5 == null) {
            throw new ValueException("There is no attribute '" + string + VALUE + "', '" + string + FIELD_VALUE + "' or '" + string + VARIABLE_VALUE + "' or '" + string + FUNCTION_VALUE + "'. Cannot determine value");
        }
        Object object = null;
        if (string2 != null) {
            object = string2;
            String string6 = flowExpression.lookupAttribute(TYPE, inFlowWorkItem);
            if (string6 != null) {
                if (string6.equals(T_BOOLEAN)) {
                    object = new BooleanAttribute(string2);
                } else if (string6.equals(T_INTEGER)) {
                    object = new IntegerAttribute(string2);
                } else if (string6.equals(T_LONG)) {
                    object = new LongAttribute(string2);
                } else if (string6.equals(T_DOUBLE)) {
                    object = new DoubleAttribute(string2);
                }
            }
        } else if (string4 != null) {
            object = flowExpression.lookupVariable(string4);
        } else if (string3 != null) {
            Attribute attribute = inFlowWorkItem.getAttribute(string3);
            String string7 = ((AbstractFlowExpression)flowExpression).substituteText("${f:" + string3 + "}", inFlowWorkItem);
            if (attribute != null) {
                object = attribute;
            } else if (string7 != null && string7.length() > 0) {
                object = string7;
            }
        } else if (string5 != null) {
            object = string5;
        }
        return object;
    }

    public static Map determineAndSetTarget(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, Object object) throws ValueException {
        return ValueUtils.doDetermineAndSetTarget("", flowExpression, inFlowWorkItem, object);
    }

    public static Map determineAndSetTarget(String string, FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, Object object) throws ValueException {
        return ValueUtils.doDetermineAndSetTarget(string, flowExpression, inFlowWorkItem, object);
    }

    private static Map doDetermineAndSetTarget(String string, FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, Object object) throws ValueException {
        Attribute attribute;
        if (string == null) {
            string = "";
        }
        String string2 = flowExpression.lookupAttribute(string + FIELD_TARGET, inFlowWorkItem);
        String string3 = flowExpression.lookupAttribute(string + VARIABLE_TARGET, inFlowWorkItem);
        if (string2 == null && string3 == null) {
            throw new ValueException("Expression should set a value but which one ? there is no paremeter '" + string + FIELD_TARGET + "' or '" + string + VARIABLE_TARGET + "' given.");
        }
        if (string3 != null) {
            ValueUtils.setVariable(flowExpression, string3, object);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put(string3, object);
            return hashMap;
        }
        boolean bl = true;
        String string4 = flowExpression.lookupAttribute(OVERRIDE, inFlowWorkItem);
        if (string4 != null && string4.trim().toLowerCase().equals("false")) {
            bl = false;
        }
        if ((attribute = inFlowWorkItem.getAttributes().getField(string2)) != null && !bl) {
            return null;
        }
        inFlowWorkItem.getAttributes().setField(string2, object);
        return null;
    }

    public static void determineAndIncrementTarget(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, Object object) throws ValueException {
        if (object == null) {
            return;
        }
        String string = flowExpression.lookupAttribute(FIELD_TARGET, inFlowWorkItem);
        String string2 = flowExpression.lookupAttribute(VARIABLE_TARGET, inFlowWorkItem);
        if (string == null && string2 == null) {
            throw new ValueException("Expression should set a value but which one ? there is no paremeter 'field' or 'variable' given.");
        }
        if (string2 != null) {
            Object object2 = flowExpression.lookupVariable(string2);
            object = ValueUtils.increment(object2, object);
            ValueUtils.setVariable(flowExpression, string2, object);
        } else if (string != null) {
            Attribute attribute = inFlowWorkItem.getAttributes().get(string);
            object = ValueUtils.increment(attribute, object);
            object = AttributeUtils.java2owfe(object);
            inFlowWorkItem.getAttributes().put(string, (Attribute)object);
        }
    }

    private static void setVariable(FlowExpression flowExpression, String string, Object object) {
        String string2 = string;
        FlowExpression flowExpression2 = null;
        if (string.startsWith("./")) {
            flowExpression2 = flowExpression;
            string2 = string.substring(2);
        } else {
            flowExpression2 = flowExpression.getExpressionPool().lookupContainingEnvironment(flowExpression, string2);
            if (flowExpression2 == null) {
                flowExpression2 = flowExpression;
            }
        }
        flowExpression.getExpressionPool().setVariable(flowExpression2, string2, object);
    }

    private static Object increment(Object object, Object object2) {
        Object object3 = object;
        object = ValueUtils.refineValue(object);
        object2 = ValueUtils.refineValue(object2);
        Object object4 = ValueUtils.refinedIncrement(object, object2);
        if (object3 instanceof Attribute) {
            if (object4 instanceof Long) {
                return new LongAttribute((Long)object4);
            }
            if (object4 instanceof Double) {
                return new DoubleAttribute((Double)object4);
            }
            return new StringAttribute(object4.toString());
        }
        return object4;
    }

    private static Object refineValue(Object object) {
        if (object == null) {
            return "";
        }
        try {
            long l = Long.parseLong(object.toString());
            return new Long(l);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(object.toString());
                return new Double(d);
            }
            catch (NumberFormatException numberFormatException2) {
                return object.toString();
            }
        }
    }

    private static double toDouble(Object object) {
        return Double.parseDouble(object.toString());
    }

    private static int toInt(Object object) {
        return Integer.parseInt(object.toString());
    }

    private static Object refinedIncrement(Object object, Object object2) {
        if (object instanceof String || object2 instanceof String) {
            return object.toString() + object2.toString();
        }
        if (object instanceof Double || object2 instanceof Double) {
            return new Double(ValueUtils.toDouble(object) + ValueUtils.toDouble(object2));
        }
        return new Integer(ValueUtils.toInt(object) + ValueUtils.toInt(object2));
    }

    public static boolean lookupBooleanResult(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        Attribute attribute = inFlowWorkItem.getAttributes().get(F_RESULT);
        if (attribute == null) {
            throw new ReplyException("lookupBooleanVariable() no boolean result found");
        }
        if (attribute instanceof BooleanAttribute) {
            return ((BooleanAttribute)attribute).booleanValue();
        }
        return attribute.toString().toLowerCase().equals("true");
    }

    public static void cleanResult(InFlowWorkItem inFlowWorkItem) {
        inFlowWorkItem.getAttributes().remove(F_RESULT);
    }

    public static void setBooleanResult(InFlowWorkItem inFlowWorkItem, boolean bl) {
        inFlowWorkItem.getAttributes().put(F_RESULT, (Attribute)new BooleanAttribute(bl));
    }

    public static void setBooleanResult(InFlowWorkItem inFlowWorkItem, Boolean bl) {
        ValueUtils.setBooleanResult(inFlowWorkItem, (boolean)bl);
    }

    public static void setResult(InFlowWorkItem inFlowWorkItem, Object object) {
        inFlowWorkItem.getAttributes().put(F_RESULT, AttributeUtils.java2owfe(object));
    }

    public static Attribute getResult(InFlowWorkItem inFlowWorkItem) {
        return inFlowWorkItem.getAttributes().get(F_RESULT);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

