/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.CollectionAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.misc.Text;

public class VariableMap
extends AbstractMap {
    public static final String FIELD_PREFIX = "field:";
    public static final String FIELD_PREFIX_2 = "f:";
    public static final String VAR_PREFIX = "v:";
    public static final String VAR_PREFIX_2 = "var:";
    public static final String VAR_PREFIX_3 = "variable:";
    public static final String FV_PREFIX = "fv:";
    public static final String VF_PREFIX = "vf:";
    public static final String CALL_PREFIX = "call:";
    public static final String CALL_PREFIX_2 = "c:";
    public static final String CONST_PREFIX = "const:";
    private Map map = null;
    private FlowExpression flowExpression = null;
    private InFlowWorkItem workitem = null;

    public VariableMap(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem) {
        this(null, flowExpression, inFlowWorkItem);
    }

    public VariableMap(Map map, FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem) {
        this.map = map;
        this.flowExpression = flowExpression;
        this.workitem = inFlowWorkItem;
    }

    public Set entrySet() {
        return null;
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public Object get(Object object) {
        String string = object.toString();
        String[] stringArray = this.determinePrefixAndKey(object);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (string2 == null) {
            return this.lookupVariableValue(string3);
        }
        if (string2.equals(CALL_PREFIX)) {
            return ValueUtils.executeFunction(this.flowExpression, this.workitem, string3);
        }
        if (string2.equals(CONST_PREFIX)) {
            return ValueUtils.lookupConstant(string3);
        }
        if (string2.equals(FIELD_PREFIX)) {
            return this.lookupFieldValue(string3);
        }
        if (string2.equals(FV_PREFIX)) {
            String string4 = this.lookupFieldValue(string3);
            if (string4 != null) {
                return string4;
            }
            return this.lookupVariableValue(string3);
        }
        if (string2.equals(VF_PREFIX)) {
            String string5 = this.lookupVariableValue(string3);
            if (string5 != null) {
                return string5;
            }
            return this.lookupFieldValue(string3);
        }
        return null;
    }

    public void setFlowExpression(FlowExpression flowExpression) {
        this.flowExpression = flowExpression;
    }

    private String matchesPrefix(String string, String string2) {
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return null;
    }

    private String[] determinePrefixAndKey(Object object) {
        String string = object.toString();
        String string2 = null;
        string2 = this.matchesPrefix(string, CALL_PREFIX);
        if (string2 != null) {
            return new String[]{CALL_PREFIX, string2};
        }
        string2 = this.matchesPrefix(string, CALL_PREFIX_2);
        if (string2 != null) {
            return new String[]{CALL_PREFIX, string2};
        }
        string2 = this.matchesPrefix(string, FIELD_PREFIX);
        if (string2 != null) {
            return new String[]{FIELD_PREFIX, string2};
        }
        string2 = this.matchesPrefix(string, FIELD_PREFIX_2);
        if (string2 != null) {
            return new String[]{FIELD_PREFIX, string2};
        }
        string2 = this.matchesPrefix(string, CONST_PREFIX);
        if (string2 != null) {
            return new String[]{CONST_PREFIX, string2};
        }
        string2 = this.matchesPrefix(string, FV_PREFIX);
        if (string2 != null) {
            return new String[]{FV_PREFIX, string2};
        }
        string2 = this.matchesPrefix(string, VF_PREFIX);
        if (string2 != null) {
            return new String[]{VF_PREFIX, string2};
        }
        string2 = this.matchesPrefix(string, VAR_PREFIX);
        if (string2 != null) {
            return new String[]{null, string2};
        }
        string2 = this.matchesPrefix(string, VAR_PREFIX_2);
        if (string2 != null) {
            return new String[]{null, string2};
        }
        string2 = this.matchesPrefix(string, VAR_PREFIX_3);
        if (string2 != null) {
            return new String[]{null, string2};
        }
        return new String[]{null, string};
    }

    private String lookupFieldValue(String string) {
        if (this.workitem == null) {
            return null;
        }
        Attribute attribute = CollectionAttribute.lookupAttribute(string, this.workitem.getAttributes());
        if (attribute == null) {
            return null;
        }
        return attribute.toString();
    }

    private String lookupVariableValue(String string) {
        Object object = null;
        if (this.map != null) {
            object = this.map.get(string);
        }
        if (object != null) {
            return object.toString();
        }
        if (this.flowExpression != null) {
            object = this.flowExpression.lookupVariable(string);
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public static String substitute(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String string) {
        if (string.indexOf("${") < 0) {
            return string;
        }
        return Text.substitute((String)string, (Map)new VariableMap(flowExpression, inFlowWorkItem));
    }
}

