/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.HashMap;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;
import openwfe.org.engine.expressions.ExpressionWithTimeOut;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.TimeoutUtils;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.time.Schedulable;
import openwfe.org.time.Scheduler;
import org.apache.log4j.Logger;

public class WhenExpression
extends CleanCompositeFlowExpression
implements ExpressionWithTimeOut,
Schedulable {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$WhenExpression == null ? (class$openwfe$org$engine$expressions$WhenExpression = WhenExpression.class$("openwfe.org.engine.expressions.WhenExpression")) : class$openwfe$org$engine$expressions$WhenExpression).getName());
    private InFlowWorkItem workitem = null;
    private boolean conditionTreated = false;
    private Long atId = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$WhenExpression;

    public InFlowWorkItem getWorkitem() {
        return this.workitem;
    }

    public boolean isConditionTreated() {
        return this.conditionTreated;
    }

    public void setWorkitem(InFlowWorkItem inFlowWorkItem) {
        if (inFlowWorkItem == null) {
            return;
        }
        this.workitem = (InFlowWorkItem)inFlowWorkItem.clone();
    }

    public void setConditionTreated(boolean bl) {
        this.conditionTreated = bl;
    }

    public Long getAtId() {
        return this.atId;
    }

    public void trigger(Object[] objectArray) {
        log.debug((Object)"trigger()");
        FlowExpressionId flowExpressionId = (FlowExpressionId)this.getChildren().get(0);
        if (this.workitem == null) {
            log.debug((Object)"trigger() workitem is null. 'when' Skipped.");
            return;
        }
        if (this.isConditionTreated()) {
            log.debug((Object)"trigger() condition already treated. Returning");
            return;
        }
        this.tag(this.workitem);
        log.debug((Object)"trigger() workitem got tagged");
        try {
            this.getLauncher().launchSub(this.workitem, this.getId(), flowExpressionId, new HashMap(0), true);
        }
        catch (LaunchException launchException) {
            log.warn((Object)"trigger() failed to launch condition checking logic !!!", (Throwable)((Object)launchException));
        }
    }

    public Long reschedule(Scheduler scheduler) {
        return this.getExpressionPool().schedule(this.getId());
    }

    protected String getNameInHistory() {
        return this.getClass().getName() + " $Revision: 2902 $";
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        log.debug((Object)"apply()");
        this.setWorkitem(inFlowWorkItem);
        this.storeItself();
        this.trigger(null);
    }

    public void replyToParent(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("replyToParent() removing template " + this.getChildren().get(0)));
            }
            this.getExpressionPool().removeExpression((FlowExpressionId)this.getChildren().get(0));
        }
        super.replyToParent(inFlowWorkItem);
    }

    public void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        log.debug((Object)"reply()");
        if (this.isConditionTreated()) {
            log.debug((Object)"reply() condition is treated - replying to parent");
            this.replyToParent(inFlowWorkItem);
            return;
        }
        if (ValueUtils.lookupBooleanResult(inFlowWorkItem)) {
            this.workitem.addHistoryItem(this.getNameInHistory(), "triggered");
            this.historyLog(inFlowWorkItem, "-inf", null, this.getNameInHistory());
            if (this.getChildren().size() < 2) {
                log.info((Object)"reply() condition realized but no child to apply");
                this.replyToParent(inFlowWorkItem);
                return;
            }
            log.debug((Object)"reply() setting conditionTreated to true");
            this.setConditionTreated(true);
            try {
                this.storeItself();
                this.getExpressionPool().apply((FlowExpressionId)this.getChildren().get(1), this.workitem);
            }
            catch (ApplyException applyException) {
                throw new ReplyException("reply() failure", (Throwable)((Object)applyException));
            }
        } else {
            log.info((Object)"reply() conditional clause returned with 'false'");
            this.atId = this.reschedule(null);
            this.storeItself();
        }
    }

    public InFlowWorkItem cancel() throws ApplyException {
        if (this.atId != null) {
            this.getExpressionPool().getScheduler().unscheduleAt(this.atId);
        }
        return super.cancel();
    }

    public boolean isTimeOutActivated() {
        return true;
    }

    public Long determineTimeOut() {
        Long l = TimeoutUtils.determineTimeout(this, this.workitem);
        if (l == null) {
            l = this.getExpressionPool().getExpressionTimeOut();
        }
        if (l == null) {
            l = new Long(-1L);
        }
        return l;
    }

    public void timeOutReply() throws ReplyException {
        this.getWorkitem().addHistoryItem(this.getNameInHistory(), "timed out");
        this.historyLog(null, "+TOU", null, this.getNameInHistory());
        log.debug((Object)"timeOutReply() resuming flow");
        this.reply(this.getWorkitem());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

