/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.raw;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openwfe.org.ApplicationContext;
import openwfe.org.ReflectionUtils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ProcessDefinition;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.expressions.map.ExpressionMap;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public abstract class RawExpression
extends ZeroChildExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$raw$RawExpression == null ? (class$openwfe$org$engine$expressions$raw$RawExpression = RawExpression.class$("openwfe.org.engine.expressions.raw.RawExpression")) : class$openwfe$org$engine$expressions$raw$RawExpression).getName());
    private static long lastGivenInstanceId = -1L;
    private transient ProcessDefinition processDefinition = null;
    private transient FlowExpression generatedExpression = null;
    private int subId = 0;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$raw$RawExpression;

    public int getSubId() {
        return this.subId;
    }

    public void setSubId(int n) {
        this.subId = n;
    }

    public abstract void init(ApplicationContext var1, FlowExpressionId var2, FlowExpressionId var3, int var4, Object var5) throws BuildException;

    public abstract void init(ApplicationContext var1, FlowExpressionId var2, FlowExpressionId var3, FlowExpressionId var4, Object var5) throws BuildException;

    public abstract boolean isDefinition();

    public abstract boolean isWorkflowDefinition();

    public abstract String getDefinitionName();

    public abstract FlowExpression resolveExpression(InFlowWorkItem var1) throws BuildException;

    public abstract FlowExpression resolveExpression(ProcessDefinition var1) throws BuildException;

    public abstract List prepareChildren(InFlowWorkItem var1) throws BuildException;

    public abstract Object getRaw();

    public List cleanChildren(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof FlowExpressionId)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    protected synchronized String nextSubId() {
        String string = "" + this.subId;
        ++this.subId;
        return string;
    }

    protected FlowExpressionId determineId(FlowExpressionId flowExpressionId, String string, int n) {
        FlowExpressionId flowExpressionId2 = flowExpressionId.copy();
        flowExpressionId2.setExpressionName(string);
        String string2 = flowExpressionId.getExpressionId();
        if (string2 == null) {
            flowExpressionId2.setExpressionId("" + n);
        } else {
            flowExpressionId2.setExpressionId(string2 + "." + n);
        }
        return flowExpressionId2;
    }

    public synchronized RawExpression newInstance(FlowExpressionId flowExpressionId) throws PoolException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"newInstance()");
            log.debug((Object)("newInstance() this.id   " + this.getId()));
            log.debug((Object)("newInstance() parentId  " + flowExpressionId));
        }
        RawExpression rawExpression = (RawExpression)this.clone();
        String string = rawExpression.getId().getWorkflowInstanceId();
        String string2 = null;
        if (flowExpressionId != null) {
            String string3;
            String string4 = FlowExpressionId.extractParentWorkflowInstanceId(string);
            if (!string4.equals(string3 = flowExpressionId.getParentWorkflowInstanceId())) {
                string2 = string;
            }
        } else if (string.indexOf(".") < 0 && rawExpression.getId().getExpressionId().equals("0")) {
            string2 = string;
        }
        if (string2 == null) {
            string2 = string + "." + this.nextSubId();
        }
        rawExpression.getId().setWorkflowInstanceId(string2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("newInstance() clone.wfid   = " + string2));
            log.debug((Object)("newInstance() clone.id     = " + rawExpression.getId()));
            log.debug((Object)("newInstance() clone.parent = " + rawExpression.getParent()));
        }
        this.getExpressionPool().add(rawExpression);
        this.storeItself();
        return rawExpression;
    }

    public FlowExpression preApply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        try {
            FlowExpression flowExpression = this.resolveExpression(inFlowWorkItem);
            Definitions.getExpressionPool(this.context()).add(flowExpression);
            return flowExpression;
        }
        catch (Throwable throwable) {
            throw new ApplyException("preApply failed", throwable);
        }
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        FlowExpression flowExpression = this.preApply(inFlowWorkItem);
        flowExpression.apply(inFlowWorkItem);
    }

    public void launch(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        FlowExpression flowExpression = this.preApply(inFlowWorkItem);
        flowExpression.launch(inFlowWorkItem);
    }

    public final void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    public FlowExpression getGeneratedExpression() {
        return this.generatedExpression;
    }

    public void setGeneratedExpression(FlowExpression flowExpression) {
        this.generatedExpression = flowExpression;
    }

    public static synchronized String determineNewWorkflowInstanceId() {
        long l;
        for (l = System.currentTimeMillis(); l <= lastGivenInstanceId; ++l) {
        }
        lastGivenInstanceId = l;
        return "" + l;
    }

    public static RawExpression getEmptyRawExpression(ApplicationContext applicationContext) {
        ExpressionMap expressionMap = Definitions.getExpressionMap(applicationContext);
        return (RawExpression)ReflectionUtils.buildNewInstance((String)expressionMap.getRawExpressionClass().getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

