/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.raw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.DefinitionExpression;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ProcessDefinition;
import openwfe.org.engine.expressions.SubProcessRefExpression;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.impl.launch.SimpleXmlLauncher;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class XmlRawExpression
extends RawExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$raw$XmlRawExpression == null ? (class$openwfe$org$engine$expressions$raw$XmlRawExpression = XmlRawExpression.class$("openwfe.org.engine.expressions.raw.XmlRawExpression")) : class$openwfe$org$engine$expressions$raw$XmlRawExpression).getName());
    private static final String A_NAME = "name";
    private static final String A_REVISION = "revision";
    private static final String E_DESCRIPTION = "description";
    private static final String E_INCLUDE = "include";
    private static final String A_URL = "url";
    private Element xmlBranch = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$raw$XmlRawExpression;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$DefinitionExpression;

    public void init(ApplicationContext applicationContext, FlowExpressionId flowExpressionId, FlowExpressionId flowExpressionId2, int n, Object object) throws BuildException {
        this.setApplicationContext(applicationContext);
        if (flowExpressionId2.getExpressionName() != null) {
            this.setParent(flowExpressionId2);
        }
        this.xmlBranch = (Element)object;
        this.xmlBranch.detach();
        this.setId(this.determineId(flowExpressionId2, this.xmlBranch.getName(), n));
        this.setEnvironmentId(flowExpressionId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() 0 set id to     " + this.getId()));
            log.debug((Object)("init() 0 set parent to " + this.getParent()));
            log.debug((Object)("init() 0 set env id to " + this.getEnvironmentId()));
        }
    }

    public void init(ApplicationContext applicationContext, FlowExpressionId flowExpressionId, FlowExpressionId flowExpressionId2, FlowExpressionId flowExpressionId3, Object object) throws BuildException {
        this.setApplicationContext(applicationContext);
        this.setEnvironmentId(flowExpressionId);
        this.setParent(flowExpressionId2);
        this.setId(flowExpressionId3);
        this.xmlBranch = (Element)object;
        this.xmlBranch.detach();
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() 1 set id to     " + this.getId()));
            log.debug((Object)("init() 1 set parent to " + this.getParent()));
            log.debug((Object)("init() 1 set env id to " + this.getEnvironmentId()));
        }
    }

    public boolean isDefinition() {
        Class clazz = this.getExpressionClass();
        if (clazz == null) {
            log.warn((Object)("isDefinition() did not found expression named '" + this.xmlBranch.getName()));
            return false;
        }
        return (class$openwfe$org$engine$expressions$DefinitionExpression == null ? (class$openwfe$org$engine$expressions$DefinitionExpression = XmlRawExpression.class$("openwfe.org.engine.expressions.DefinitionExpression")) : class$openwfe$org$engine$expressions$DefinitionExpression).isAssignableFrom(clazz);
    }

    public boolean isWorkflowDefinition() {
        return this.getDefinitionName() != null && this.xmlBranch.getAttributeValue(A_REVISION) != null;
    }

    public String getDefinitionName() {
        return this.xmlBranch.getAttributeValue(A_NAME);
    }

    public Class getExpressionClass() {
        String string = this.xmlBranch.getName();
        return this.getExpressionMap().getClass(string);
    }

    public Object getRaw() {
        return this.xmlBranch;
    }

    public Element getXmlBranch() {
        return this.xmlBranch;
    }

    public void setXmlBranch(Element element) {
        this.xmlBranch = element;
    }

    public Object clone() {
        XmlRawExpression xmlRawExpression = (XmlRawExpression)super.clone();
        xmlRawExpression.setXmlBranch((Element)this.getXmlBranch().clone());
        return xmlRawExpression;
    }

    public FlowExpression resolveExpression(InFlowWorkItem inFlowWorkItem) throws BuildException {
        return this.resolveExpression(inFlowWorkItem, null);
    }

    public FlowExpression resolveExpression(ProcessDefinition processDefinition) throws BuildException {
        return this.resolveExpression(null, processDefinition);
    }

    private FlowExpression resolveExpression(InFlowWorkItem inFlowWorkItem, ProcessDefinition processDefinition) throws BuildException {
        this.setProcessDefinition(processDefinition);
        String string = this.xmlBranch.getName();
        log.debug((Object)("resolveExpression() expressionName >" + string + "<"));
        Object object = null;
        if (processDefinition == null) {
            object = this.lookupVariable(string);
        }
        Class clazz = this.getExpressionMap().getClass(string);
        FlowExpression flowExpression = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("resolveExpression() this.parent is " + this.getParent()));
            log.debug((Object)("resolveExpression() expClass is    " + clazz));
            log.debug((Object)("resolveExpression() oValue is      " + object));
        }
        if (object != null && object instanceof FlowExpressionId || object != null && object instanceof RawExpression || processDefinition != null && clazz == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"resolveExpression() 'subprocess' expression");
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(1);
            hashMap.put("ref", string);
            hashMap.putAll(XmlUtils.fetchAttributes((Element)this.xmlBranch));
            flowExpression = new SubProcessRefExpression();
            Map map = this.getLauncher().fetchAttributes(flowExpression, this.xmlBranch);
            hashMap.putAll(map);
            this.setGeneratedExpression(flowExpression);
            flowExpression.init(this.context(), this.getEnvironmentId(), this.getParent(), this.getId(), this, hashMap, inFlowWorkItem);
        } else {
            if (object != null && object instanceof Class) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"resolveExpression() built-in expression");
                }
                clazz = (Class)object;
                try {
                    flowExpression = (FlowExpression)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new BuildException("Failed to prepare built-in expression '" + string + "'", exception);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"resolveExpression() built-in expression (not found through var lookup)");
                }
                flowExpression = this.getExpressionMap().instantiateExpression(string);
            }
            this.setGeneratedExpression(flowExpression);
            flowExpression.init(this.context(), this.getEnvironmentId(), this.getParent(), this.getId(), this, this.xmlBranch, inFlowWorkItem);
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolveExpression() set parent\n    for " + flowExpression.getId() + "\n    to " + this.getParent()));
            }
        }
        if (this.getAttributes().keySet().contains("map-children")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolveExpression() map-children >" + this.getAttributes().get("map-children") + "<"));
            }
            flowExpression.getAttributes().put("map-children", this.getAttributes().get("map-children"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("resolveExpression() init for fe " + flowExpression.getId()));
        }
        if (processDefinition == null) {
            try {
                this.getExpressionPool().add(flowExpression);
            }
            catch (PoolException poolException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("resolveExpression() Failed to add resolved expression to pool " + flowExpression.getId()), (Throwable)((Object)poolException));
                }
                throw new BuildException("Failed to add resolved expression to pool " + flowExpression.getId());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolveExpression() fe class is " + flowExpression.getClass().getName()));
            }
            processDefinition.add(flowExpression);
        }
        return flowExpression;
    }

    private void pcInclude(Element element, InFlowWorkItem inFlowWorkItem, List list) {
        String string = element.getAttributeValue(A_URL);
        if (string == null) {
            return;
        }
        this.getAttributes().put(A_URL, string);
        string = this.lookupAttribute(A_URL, inFlowWorkItem);
        try {
            Element element2 = XmlUtils.extractXml((String)string, (boolean)SimpleXmlLauncher.shouldValidate());
            this.pcFirstPass(element2, inFlowWorkItem, list);
        }
        catch (Exception exception) {
            log.warn((Object)("Failed to include '" + string + "'. Skipped."), (Throwable)exception);
        }
    }

    private void pcFirstPass(Element element, InFlowWorkItem inFlowWorkItem, List list) {
        Iterator iterator = element.getContent().iterator();
        while (iterator.hasNext()) {
            Element element2;
            Content content = (Content)iterator.next();
            if (content instanceof Text) {
                list.add(content);
                continue;
            }
            if (!(content instanceof Element) || (element2 = (Element)content).getName().equals(E_DESCRIPTION)) continue;
            if (element2.getName().equals(E_INCLUDE)) {
                this.pcInclude(element2, inFlowWorkItem, list);
                continue;
            }
            list.add(element2);
        }
    }

    public List prepareChildren(InFlowWorkItem inFlowWorkItem) throws BuildException {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.xmlBranch.getChildren().size());
        ArrayList arrayList2 = new ArrayList(this.xmlBranch.getChildren().size());
        this.pcFirstPass(this.xmlBranch, inFlowWorkItem, arrayList2);
        int n = 0;
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Content content = (Content)iterator.next();
            content.detach();
            if (content instanceof Text) {
                arrayList.add(((Text)content).getText());
                continue;
            }
            Element element = (Element)content;
            XmlRawExpression xmlRawExpression = new XmlRawExpression();
            xmlRawExpression.init(this.context(), this.getEnvironmentId(), this.getId(), n, (Object)element);
            ++n;
            if (this.getProcessDefinition() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("prepareChildren() adding to pool : " + xmlRawExpression.getId()));
                }
                try {
                    this.getExpressionPool().add(xmlRawExpression);
                }
                catch (PoolException poolException) {
                    throw new BuildException("Failed to add child to pool " + xmlRawExpression.getId(), (Throwable)((Object)poolException));
                }
            } else {
                FlowExpression flowExpression = xmlRawExpression.resolveExpression(this.getProcessDefinition());
                if (flowExpression instanceof DefinitionExpression) {
                    String string = (String)flowExpression.getAttributes().get(A_NAME);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("prepareChildren() DefinitionExpression named '" + string + "'"));
                    }
                    this.getGeneratedExpression().bindVariable(string, flowExpression);
                }
                this.getProcessDefinition().add(flowExpression);
            }
            arrayList.add(xmlRawExpression.getId());
        }
        return arrayList;
    }

    public Element dump() {
        Element element = super.dump();
        Element element2 = new Element("raw");
        Element element3 = (Element)this.xmlBranch.clone();
        element3.detach();
        element2.addContent((Content)element3);
        element.addContent((Content)element2);
        return element;
    }

    protected FlowExpression fetchParent() {
        return this.getExpressionPool().fetch(this.getParent());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

