/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.state;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.state.AbstractExpressionState;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class FrozenState
extends AbstractExpressionState {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$state$FrozenState == null ? (class$openwfe$org$engine$expressions$state$FrozenState = FrozenState.class$("openwfe.org.engine.expressions.state.FrozenState")) : class$openwfe$org$engine$expressions$state$FrozenState).getName());
    public static final String EVT_FREEZE = "+FRZ";
    public static final String EVT_UNFREEZE = "+UFZ";
    private static final String NAME = "frozen";
    private static final char IDENTIFIER = 'f';
    private InFlowWorkItem appliedItem = null;
    private List replyQueue = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$state$FrozenState;

    public InFlowWorkItem getAppliedItem() {
        return this.appliedItem;
    }

    public List getReplyQueue() {
        return this.replyQueue;
    }

    public void setAppliedItem(InFlowWorkItem inFlowWorkItem) {
        this.appliedItem = inFlowWorkItem;
    }

    public void setReplyQueue(List list) {
        this.replyQueue = list;
    }

    public String getName() {
        return NAME;
    }

    public char getIdentifier() {
        return 'f';
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        if (this.appliedItem != null) {
            throw new ApplyException("An expression should not get applied twice.");
        }
        this.appliedItem = (InFlowWorkItem)inFlowWorkItem.clone();
        if (log.isDebugEnabled()) {
            log.debug((Object)("apply() applied item lastExpressionId : " + this.appliedItem.getLastExpressionId()));
        }
        this.expression.storeItself();
    }

    public void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        log.debug((Object)"reply() freezing incoming wi");
        if (this.replyQueue == null) {
            this.replyQueue = new LinkedList();
        }
        this.replyQueue.add(inFlowWorkItem);
        this.expression.storeItself();
    }

    public InFlowWorkItem cancel() throws ApplyException {
        this.expression.cancel();
        return this.appliedItem;
    }

    public void exitState() throws ApplyException {
        this.expression.setState(null);
        if (this.appliedItem == null && this.replyQueue == null) {
            log.debug((Object)"exitState() simple unfreeze done.");
            return;
        }
        if (this.replyQueue == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("exitState() applying (exp) " + this.expression.getId()));
                log.debug((Object)("exitState() applying (itm) " + this.appliedItem.getLastExpressionId()));
            }
            this.expression.apply(this.appliedItem);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("exitState() replying to " + this.expression.getId()));
            }
            Iterator iterator = this.replyQueue.iterator();
            while (iterator.hasNext()) {
                InFlowWorkItem inFlowWorkItem = (InFlowWorkItem)iterator.next();
                try {
                    this.expression.reply(inFlowWorkItem);
                }
                catch (ReplyException replyException) {
                    log.warn((Object)"exitState() failure during 'reply' defreeze", (Throwable)((Object)replyException));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

