/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.sync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.sync.ClassicalSyncExpression;
import openwfe.org.engine.expressions.sync.MergeUtils;
import openwfe.org.engine.expressions.sync.SynchableExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class GenericSyncExpression
extends ClassicalSyncExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$sync$GenericSyncExpression == null ? (class$openwfe$org$engine$expressions$sync$GenericSyncExpression = GenericSyncExpression.class$("openwfe.org.engine.expressions.sync.GenericSyncExpression")) : class$openwfe$org$engine$expressions$sync$GenericSyncExpression).getName());
    public static final String A_SYNC = "sync";
    public static final String A_COUNT = "count";
    public static final String A_MERGE = "merge";
    public static final String A_MERGE_TYPE = "merge-type";
    public static final String A_REMAINING = "remaining";
    public static final String MG_FIRST = "first";
    public static final String MG_LAST = "last";
    public static final String MG_HIGHEST = "highest";
    public static final String MG_LOWEST = "lowest";
    public static final String DEFAULT_MG = "first";
    public static final String MT_MIX = "mix";
    public static final String MT_OVERRIDE = "override";
    public static final String DEFAULT_MT = "mix";
    public static final String REM_CANCEL = "cancel";
    public static final String REM_FORGET = "forget";
    public static final String DEFAULT_REM = "cancel";
    private int count = -1;
    private String merge = null;
    private String mergeType = null;
    private String remaining = null;
    private List childrenAltitudes = null;
    private int replyCount = 0;
    private InFlowWorkItem overridenWorkitem = null;
    private List incomingWorkitems = null;
    private List unreadyQueue = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$sync$GenericSyncExpression;

    public void init(SynchableExpression synchableExpression, List list, InFlowWorkItem inFlowWorkItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() on behalf of " + synchableExpression.getId()));
        }
        String string = synchableExpression.lookupAttribute(A_COUNT, inFlowWorkItem);
        try {
            this.count = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.count = -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() count : " + this.count));
        }
        this.merge = synchableExpression.lookupAttribute(A_MERGE, inFlowWorkItem);
        if (!("first".equals(this.merge) || MG_LAST.equals(this.merge) || MG_HIGHEST.equals(this.merge) || MG_LOWEST.equals(this.merge))) {
            this.merge = "first";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() merge : '" + this.merge + "'"));
        }
        this.mergeType = synchableExpression.lookupAttribute(A_MERGE_TYPE, inFlowWorkItem);
        if (!"mix".equals(this.mergeType) && !MT_OVERRIDE.equals(this.mergeType)) {
            this.mergeType = "mix";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() merge : '" + this.mergeType + "'"));
        }
        this.remaining = synchableExpression.lookupAttribute(A_REMAINING, inFlowWorkItem);
        if (!"cancel".equals(this.remaining) && !REM_FORGET.equals(this.remaining)) {
            this.remaining = "cancel";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() remaining : '" + this.remaining + "'"));
        }
        if (list == null) {
            this.incomingWorkitems = new LinkedList();
            this.unreadyQueue = new LinkedList();
        } else {
            this.incomingWorkitems = new ArrayList(list.size());
            this.unreadyQueue = new ArrayList(list.size());
        }
        if (this.merge.equals(MG_LAST) || this.merge.equals("first")) {
            return;
        }
        this.childrenAltitudes = this.listAltitudes(list);
    }

    private List listAltitudes(List list) {
        if (list == null) {
            return new LinkedList();
        }
        ArrayList<FlowExpressionId> arrayList = new ArrayList<FlowExpressionId>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FlowExpressionId flowExpressionId = (FlowExpressionId)iterator.next();
            arrayList.add(flowExpressionId);
        }
        return arrayList;
    }

    public int getCount() {
        return this.count;
    }

    public String getMerge() {
        return this.merge;
    }

    public String getMergeType() {
        return this.mergeType;
    }

    public String getRemaining() {
        return this.remaining;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void setMerge(String string) {
        this.merge = string;
    }

    public void setMergeType(String string) {
        this.mergeType = string;
    }

    public void setRemaining(String string) {
        this.remaining = string;
    }

    public int getReplyCount() {
        return this.replyCount;
    }

    public InFlowWorkItem getOverridenWorkitem() {
        return this.overridenWorkitem;
    }

    public List getIncomingWorkitems() {
        return this.incomingWorkitems;
    }

    public List getChildrenAltitudes() {
        return this.childrenAltitudes;
    }

    public List getUnreadyQueue() {
        return this.unreadyQueue;
    }

    public void setReplyCount(int n) {
        this.replyCount = n;
    }

    public void setOverridenWorkitem(InFlowWorkItem inFlowWorkItem) {
        this.overridenWorkitem = inFlowWorkItem;
    }

    public void setIncomingWorkitems(List list) {
        this.incomingWorkitems = list;
    }

    public void setChildrenAltitudes(List list) {
        this.childrenAltitudes = list;
    }

    public void setUnreadyQueue(List list) {
        this.unreadyQueue = list;
    }

    public synchronized void applyChild(SynchableExpression synchableExpression, FlowExpressionId flowExpressionId, InFlowWorkItem inFlowWorkItem) throws ApplyException {
        if (this.isSyncOver()) {
            return;
        }
        synchableExpression.getExpressionPool().apply(flowExpressionId, inFlowWorkItem);
    }

    public synchronized void ready(SynchableExpression synchableExpression) throws ReplyException {
        if (this.unreadyQueue == null) {
            return;
        }
        List list = this.unreadyQueue;
        this.unreadyQueue = null;
        synchableExpression.storeItself();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            InFlowWorkItem inFlowWorkItem = (InFlowWorkItem)iterator.next();
            this.reply(synchableExpression, inFlowWorkItem);
        }
    }

    public void addChild(FlowExpressionId flowExpressionId) {
        super.addChild(flowExpressionId);
        if (this.childrenAltitudes != null) {
            this.childrenAltitudes.add(flowExpressionId.getWorkflowInstanceId());
        }
    }

    private void removeChild(FlowExpressionId flowExpressionId) {
        boolean bl = this.getChildren().remove(flowExpressionId);
        if (bl) {
            log.debug((Object)"removeChild() removed (fei)");
            return;
        }
        FlowExpressionId flowExpressionId2 = null;
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            FlowExpressionId flowExpressionId3 = (FlowExpressionId)iterator.next();
            if (!flowExpressionId3.getWorkflowInstanceId().equals(flowExpressionId.getWorkflowInstanceId())) continue;
            flowExpressionId2 = flowExpressionId3;
            break;
        }
        if (flowExpressionId2 != null) {
            log.debug((Object)"removeChild() removed (wfid)");
            this.getChildren().remove(flowExpressionId2);
        }
    }

    public synchronized void reply(SynchableExpression synchableExpression, InFlowWorkItem inFlowWorkItem) throws ReplyException {
        if (this.unreadyQueue != null) {
            log.debug((Object)"reply() sync expression not ready : queueing reply");
            this.unreadyQueue.add(inFlowWorkItem.clone());
            synchableExpression.storeItself();
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("reply() from " + inFlowWorkItem.getLastExpressionId()));
        }
        int n = this.getChildren().size();
        boolean bl = false;
        this.receiveWorkitem(inFlowWorkItem);
        this.removeChild(inFlowWorkItem.getLastExpressionId());
        bl = bl || this.getChildren().size() < 1;
        boolean bl2 = bl = bl || this.getCount() > 0 && this.replyCount >= this.count;
        if (log.isDebugEnabled()) {
            log.debug((Object)("reply() delta is " + (n - this.getChildren().size())));
            log.debug((Object)("reply() is sync over for " + synchableExpression.getId() + " ? " + bl));
        }
        if (bl) {
            this.terminateSync(synchableExpression);
            return;
        }
        synchableExpression.storeItself();
    }

    private void receiveWorkitem(InFlowWorkItem inFlowWorkItem) {
        ++this.replyCount;
        if (this.getMergeType().equals("mix")) {
            if (this.getMerge().equals(MG_HIGHEST) || this.getMerge().equals(MG_LOWEST)) {
                this.getIncomingWorkitems().add(inFlowWorkItem.clone());
                return;
            }
            if (this.overridenWorkitem == null) {
                this.overridenWorkitem = (InFlowWorkItem)inFlowWorkItem.clone();
                return;
            }
            if (this.getMerge().equals("first")) {
                this.overridenWorkitem = MergeUtils.merge(inFlowWorkItem, this.overridenWorkitem);
                return;
            }
            this.overridenWorkitem = MergeUtils.merge(this.overridenWorkitem, inFlowWorkItem);
            return;
        }
        if (this.overridenWorkitem == null) {
            this.overridenWorkitem = (InFlowWorkItem)inFlowWorkItem.clone();
            return;
        }
        if (this.getMerge().equals("first")) {
            if (this.overridenWorkitem != null) {
                return;
            }
            this.overridenWorkitem = (InFlowWorkItem)inFlowWorkItem.clone();
            return;
        }
        if (this.getMerge().equals(MG_LAST)) {
            this.overridenWorkitem = (InFlowWorkItem)inFlowWorkItem.clone();
            return;
        }
        int n = this.determineAltitude(this.overridenWorkitem);
        int n2 = this.determineAltitude(inFlowWorkItem);
        if (n2 < 0) {
            throw new IllegalArgumentException("Not waiting on the incoming workitem");
        }
        if (this.getMerge().equals(MG_HIGHEST)) {
            if (n2 < n) {
                this.overridenWorkitem = (InFlowWorkItem)inFlowWorkItem.clone();
            }
        } else if (n2 > n) {
            this.overridenWorkitem = (InFlowWorkItem)inFlowWorkItem.clone();
        }
    }

    private int determineAltitude(InFlowWorkItem inFlowWorkItem) {
        String string = inFlowWorkItem.getLastExpressionId().getWorkflowInstanceId();
        return this.getChildrenAltitudes().indexOf(string);
    }

    private void terminateSync(SynchableExpression synchableExpression) throws ReplyException {
        this.setSyncOver(true);
        try {
            this.treatRemainingChildren(synchableExpression);
        }
        catch (ApplyException applyException) {
            log.warn((Object)("Failed to '" + this.getRemaining() + "' remaining children"), (Throwable)((Object)applyException));
            throw new ReplyException("Failed to '" + this.getRemaining() + "' remaining children", (Throwable)((Object)applyException));
        }
        InFlowWorkItem inFlowWorkItem = null;
        if (this.overridenWorkitem != null) {
            inFlowWorkItem = this.overridenWorkitem;
        } else {
            Collections.sort(this.getChildrenAltitudes());
            if (this.getMerge().equals(MG_HIGHEST)) {
                Collections.reverse(this.getChildrenAltitudes());
            }
            Map map = this.determineAnswerMap();
            Iterator iterator = this.getChildrenAltitudes().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                InFlowWorkItem inFlowWorkItem2 = (InFlowWorkItem)map.get(string);
                if (inFlowWorkItem2 == null) continue;
                inFlowWorkItem = MergeUtils.merge(inFlowWorkItem, inFlowWorkItem2);
            }
        }
        if (inFlowWorkItem == null) {
            log.warn((Object)"reply() resultingWorkitem is null");
        }
        synchableExpression.replyToParent(inFlowWorkItem);
    }

    private Map determineAnswerMap() {
        HashMap<String, InFlowWorkItem> hashMap = new HashMap<String, InFlowWorkItem>(this.getIncomingWorkitems().size());
        Iterator iterator = this.getIncomingWorkitems().iterator();
        while (iterator.hasNext()) {
            InFlowWorkItem inFlowWorkItem = (InFlowWorkItem)iterator.next();
            hashMap.put(inFlowWorkItem.getLastExpressionId().getWorkflowInstanceId(), inFlowWorkItem);
        }
        return hashMap;
    }

    private void treatRemainingChildren(SynchableExpression synchableExpression) throws ApplyException {
        Cloneable cloneable;
        if (log.isDebugEnabled()) {
            log.debug((Object)("treatRemainingChildren() - " + this.getChildren().size() + " children in total"));
        }
        ArrayList<FlowExpressionId> arrayList = new ArrayList<FlowExpressionId>(this.getIncomingWorkitems().size());
        Iterator iterator = this.getIncomingWorkitems().iterator();
        while (iterator.hasNext()) {
            cloneable = (InFlowWorkItem)iterator.next();
            arrayList.add(cloneable.getLastExpressionId());
        }
        iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            cloneable = (FlowExpressionId)iterator.next();
            if (arrayList.contains(cloneable)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("treatRemainingChildren() '" + this.getRemaining() + "' on " + cloneable));
            }
            if ("cancel".equals(this.getRemaining())) {
                synchableExpression.getExpressionPool().childCancel((FlowExpressionId)cloneable);
                continue;
            }
            synchableExpression.getExpressionPool().forget((FlowExpressionId)cloneable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

