/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.xeme;

import java.util.HashMap;
import java.util.Map;
import openwfe.org.engine.expressions.AbstractCompositeFlowExpression;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.WithChildren;
import openwfe.org.engine.expressions.xeme.XemeUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.XmlAttribute;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class ListExpression
extends AbstractCompositeFlowExpression
implements WithChildren {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$xeme$ListExpression == null ? (class$openwfe$org$engine$expressions$xeme$ListExpression = ListExpression.class$("openwfe.org.engine.expressions.xeme.ListExpression")) : class$openwfe$org$engine$expressions$xeme$ListExpression).getName());
    public static final String A_SEP = "sep";
    public static final String DEFAULT_SEP = ",\\s*";
    public static final XmlAttribute EMPTY_LIST = new XmlAttribute((Content)new Element("list"));
    private String separator = null;
    private Map childResults = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$xeme$ListExpression;

    public String getSeparator() {
        return this.separator;
    }

    public Map getChildResults() {
        return this.childResults;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public void setChildResults(Map map) {
        this.childResults = map;
    }

    public synchronized void apply(final InFlowWorkItem inFlowWorkItem) throws ApplyException {
        if (this.getChildren().size() < 1) {
            ValueUtils.setResult(inFlowWorkItem, EMPTY_LIST);
            this.applyToParent(inFlowWorkItem);
            return;
        }
        this.separator = this.lookupAttribute(A_SEP, inFlowWorkItem, DEFAULT_SEP);
        boolean bl = true;
        this.childResults = new HashMap();
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Object object;
            final Object e = this.getChildren().get(i);
            if (e instanceof String) {
                object = this.substituteText((String)e, inFlowWorkItem);
                this.childResults.put(new Integer(i), object);
                continue;
            }
            if (!(e instanceof FlowExpressionId)) continue;
            bl = false;
            object = new Integer(i);
            new Thread((Integer)object){
                private final /* synthetic */ Integer val$ii;
                {
                    this.val$ii = n;
                }

                public void run() {
                    FlowExpressionId flowExpressionId = (FlowExpressionId)e;
                    InFlowWorkItem inFlowWorkItem2 = (InFlowWorkItem)inFlowWorkItem.clone();
                    try {
                        ListExpression.this.getExpressionPool().apply(flowExpressionId, inFlowWorkItem2);
                    }
                    catch (Throwable throwable) {
                        log.info((Object)"Failed to apply child", throwable);
                        ListExpression.this.childResults.put(this.val$ii, throwable);
                    }
                }
            }.start();
        }
        if (bl) {
            try {
                this.reply(inFlowWorkItem);
            }
            catch (ReplyException replyException) {
                throw new ApplyException("apply failed", (Throwable)((Object)replyException));
            }
            return;
        }
        this.storeItself();
    }

    public synchronized void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("reply() from " + inFlowWorkItem.getLastExpressionId()));
        }
        Attribute attribute = ValueUtils.getResult(inFlowWorkItem);
        int n = this.getChildren().indexOf(inFlowWorkItem.getLastExpressionId());
        if (n > -1) {
            this.childResults.put(new Integer(n), attribute);
        }
        if (this.childResults.size() < this.getChildren().size()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("reply() all replies not yet received (" + this.childResults.size() + "/" + this.getChildren().size() + ")"));
            }
            return;
        }
        if (this.getChildren().size() > 1) {
            ValueUtils.setResult(inFlowWorkItem, this.newXmlAttribute(this.childResults));
            this.replyToParent(inFlowWorkItem);
            return;
        }
        Object v = this.childResults.get(new Integer(0));
        String[] stringArray = v.toString().split(this.separator);
        ValueUtils.setResult(inFlowWorkItem, this.newXmlAttribute(stringArray));
        this.replyToParent(inFlowWorkItem);
    }

    private XmlAttribute newXmlAttribute(Object object) {
        Element element = new Element("list");
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                Element element2 = new Element("string");
                element2.addContent((Content)new Text(stringArray[i]));
                element.addContent((Content)element2);
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            for (int i = 0; i < map.size(); ++i) {
                Integer n = new Integer(i);
                Object v = this.childResults.get(n);
                if (v instanceof String) {
                    element.addContent((Content)new Text((String)v));
                    continue;
                }
                element.addContent(XemeUtils.toXemeResult(this, (Attribute)v));
            }
        } else if (object instanceof Attribute) {
            element = XemeUtils.toXemeResult(this, (Attribute)object);
        }
        return new XmlAttribute((Content)element);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

