/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.xeme;

import java.util.Iterator;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public abstract class XemeUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$xeme$XemeUtils == null ? (class$openwfe$org$engine$expressions$xeme$XemeUtils = XemeUtils.class$("openwfe.org.engine.expressions.xeme.XemeUtils")) : class$openwfe$org$engine$expressions$xeme$XemeUtils).getName());
    public static final Content NULL_RESULT = new Text("");
    static /* synthetic */ Class class$openwfe$org$engine$expressions$xeme$XemeUtils;

    public static int size(Content content) {
        if (content instanceof Text) {
            if (XemeUtils.isNotEmptyText(content)) {
                return 1;
            }
            return 0;
        }
        int n = 0;
        Element element = (Element)content;
        Iterator iterator = element.getContent().iterator();
        while (iterator.hasNext()) {
            Content content2 = (Content)iterator.next();
            if (content2 instanceof Element) {
                ++n;
                continue;
            }
            if (!(content2 instanceof Text) || !XemeUtils.isNotEmptyText(content2)) continue;
            ++n;
        }
        return n;
    }

    public static Content nth(int n, Content content) {
        if (content instanceof Text) {
            String string = ((Text)content).getTextTrim();
            while (n < 0) {
                n = string.length() + n;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("nth() 0 index : " + n));
            }
            if (n >= string.length()) {
                return NULL_RESULT;
            }
            return new Text("" + string.charAt(n));
        }
        int n2 = XemeUtils.size(content);
        while (n < 0) {
            n = n2 + n;
        }
        Element element = (Element)content;
        int n3 = 0;
        Iterator iterator = element.getContent().iterator();
        while (iterator.hasNext()) {
            Content content2 = (Content)iterator.next();
            if (XemeUtils.isNotEmptyText(content2) && n3 == n) {
                return content2;
            }
            if (!XemeUtils.isNotEmptyText(content2)) continue;
            ++n3;
        }
        return NULL_RESULT;
    }

    private static boolean isNotEmptyText(Content content) {
        if (!(content instanceof Text)) {
            return true;
        }
        return ((Text)content).getTextTrim().length() > 0;
    }

    public static Content car(Content content) {
        Element element;
        if (log.isDebugEnabled()) {
            log.debug((Object)("car() input is of class " + content.getClass().getName()));
        }
        if ((element = XemeUtils.toElement(content)).getContent().size() < 1) {
            throw new IllegalArgumentException("cannot car an empty element");
        }
        for (int i = 0; i < element.getContent().size(); ++i) {
            Content content2 = (Content)element.getContent().get(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("car() result is >" + content2.toString() + "<"));
            }
            if (content2 instanceof Text && ((Text)content2).getTextTrim().length() < 1) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("car() returning >" + XmlUtils.xmlToString((Content)content2) + "<"));
            }
            return (Content)content2.clone();
        }
        return null;
    }

    public static Element cdr(Content content) {
        Element element = XemeUtils.toElement(content);
        if (element.getContent().size() < 1) {
            throw new IllegalArgumentException("cannot cdr an empty element");
        }
        Element element2 = (Element)element.clone();
        element2 = XemeUtils.removeFirstChild(element2);
        return element2;
    }

    private static Element removeFirstChild(Element element) {
        Content content = element.removeContent(0);
        if (content == null) {
            return element;
        }
        if (content instanceof Element) {
            return element;
        }
        if (content instanceof Text && ((Text)content).getTextTrim().length() > 0) {
            return element;
        }
        return XemeUtils.removeFirstChild(element);
    }

    public static Text xar(Content content) {
        Element element = XemeUtils.toElement(content);
        return new Text(element.getName());
    }

    public static Element cons(Content content, Content content2) {
        Element element = XemeUtils.toElement(content2);
        element.addContent(0, (Content)content.clone());
        return element;
    }

    public static Element append(Content content, Content content2) {
        Element element = XemeUtils.toElement(content);
        Element element2 = XemeUtils.toElement(content2);
        Iterator iterator = element2.getContent().iterator();
        while (iterator.hasNext()) {
            Content content3 = (Content)iterator.next();
            content3 = (Content)content3.clone();
            content3.detach();
            element.addContent(content3);
        }
        return element;
    }

    public static Element xons(Content content, Content content2) {
        Element element = XemeUtils.toElement(content2);
        if (content instanceof Text) {
            element.setName(((Text)content).getTextTrim());
            return element;
        }
        Element element2 = XemeUtils.toElement(content);
        if (element2.getChildren().size() < 1) {
            String string = element2.getName();
            String string2 = element2.getTextTrim();
            element.setAttribute(string, string2);
            return element;
        }
        element.setName(element2.getName());
        Iterator iterator = element2.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            String string = element3.getName();
            String string3 = element3.getTextTrim();
            element.setAttribute(string, string3);
        }
        return element;
    }

    public static Element xdr(Content content) {
        Element element = XemeUtils.toElement(content);
        Element element2 = new Element(element.getName());
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            Element element3 = new Element(attribute.getName());
            element3.addContent((Content)new Text(attribute.getValue()));
            element2.addContent((Content)element3);
        }
        return element2;
    }

    public static boolean isEmpty(Content content) {
        if (!(content instanceof Element)) {
            return true;
        }
        return ((Element)content).getChildren().size() < 1;
    }

    public static boolean isNull(Content content) {
        if (content == null) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isNull() c is \n" + XmlUtils.xmlToString((Content)content)));
        }
        if (content instanceof Element) {
            return ((Element)content).getContent().size() < 1;
        }
        if (content instanceof Text) {
            return content.equals((Object)NULL_RESULT);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"isNull() returning false (default).");
        }
        return false;
    }

    public static boolean isAtom(Content content) {
        return !(content instanceof Element);
    }

    public static boolean isList(Content content) {
        return content instanceof Element;
    }

    public static Content fetchWorkitemResult(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem) {
        openwfe.org.engine.workitem.Attribute attribute = ValueUtils.getResult(inFlowWorkItem);
        return XemeUtils.toXemeResult(flowExpression, attribute);
    }

    public static Content toXemeResult(FlowExpression flowExpression, Object object) {
        Object object2;
        if (object == null) {
            return NULL_RESULT;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("toXemeResult() o.class is " + object.getClass().getName()));
        }
        if (object instanceof Content) {
            return (Content)object;
        }
        if (object instanceof XmlAttribute) {
            return ((XmlAttribute)object).getContent();
        }
        if (object instanceof String || object instanceof StringAttribute) {
            object2 = object.toString();
            if (((String)object2).equals("")) {
                return NULL_RESULT;
            }
            try {
                return XmlUtils.extractXmlElement((String)object2);
            }
            catch (Throwable throwable) {
                log.debug((Object)"toXemeResult() String[Attribute] doesn't contain XML");
            }
        }
        if (object instanceof openwfe.org.engine.workitem.Attribute) {
            object2 = Definitions.getXmlCoder(flowExpression.context());
            try {
                return ((XmlWorkItemCoder)object2).encodeAttribute((openwfe.org.engine.workitem.Attribute)object);
            }
            catch (Exception exception) {
                log.debug((Object)"toXemeResult() couldn't code attribute", (Throwable)exception);
                return NULL_RESULT;
            }
        }
        if (object instanceof FlowExpressionId) {
            return new Text("subprocess '" + object + "'");
        }
        if (object instanceof RawExpression) {
            return new Text("process '" + object + "'");
        }
        return new Text(object.toString());
    }

    public static Element toElement(Content content) {
        if (content instanceof Element) {
            return (Element)content.clone();
        }
        if (content instanceof Text) {
            String string = ((Text)content).getText();
            if (log.isDebugEnabled()) {
                log.debug((Object)("toElement() text is >" + string + "<"));
            }
            try {
                return XmlUtils.extractXmlElement((String)string);
            }
            catch (Exception exception) {
                log.debug((Object)"toElement() couldn't fetch XML");
            }
        }
        throw new IllegalArgumentException("Not an element : " + content);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

