/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.dispatch;

import java.util.Map;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.dispatch.AbstractWorkItemDispatcher;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.mail.MailUtils;
import org.apache.log4j.Logger;

public class SmtpDispatcher
extends AbstractWorkItemDispatcher {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$dispatch$SmtpDispatcher == null ? (class$openwfe$org$engine$impl$dispatch$SmtpDispatcher = SmtpDispatcher.class$("openwfe.org.engine.impl.dispatch.SmtpDispatcher")) : class$openwfe$org$engine$impl$dispatch$SmtpDispatcher).getName());
    public static final String P_RECIPIENT = "recipient";
    public static final String P_RECIPIENT_FIELD = "recipient-field";
    public static final String P_CC = "cc";
    public static final String SUBJECT_PREFIX = "openwfe.workitem::";
    private String recipient = null;
    private String recipientField = null;
    private String cc = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$dispatch$SmtpDispatcher;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.recipient = MapUtils.getAsString((Map)map, (String)P_RECIPIENT);
        this.recipientField = MapUtils.getAsString((Map)map, (String)P_RECIPIENT_FIELD);
        this.cc = MapUtils.getAsString((Map)map, (String)P_CC);
    }

    public Object dispatch(WorkItem workItem) throws DispatchingException {
        try {
            Object object;
            Session session = MailUtils.getMailSession((Map)this.getParams());
            MimeMessage mimeMessage = new MimeMessage(session);
            MailUtils.setMailFrom((Message)mimeMessage, (Map)this.getParams());
            String string = this.recipient;
            if (this.recipientField != null && (object = workItem.getAttributes().sget(this.recipientField)) != null) {
                string = object;
            }
            if (string == null) {
                throw new DispatchingException("Cannot dispatch to 'null' recipient");
            }
            MailUtils.addRecipients((Message)mimeMessage, (Message.RecipientType)Message.RecipientType.TO, (String)string);
            MailUtils.addRecipients((Message)mimeMessage, (Message.RecipientType)Message.RecipientType.CC, (String)this.cc);
            mimeMessage.setSubject(this.determineSubject(workItem));
            object = (byte[])this.instantiateEncoder().encode(workItem, this.getContext(), this.getParams());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getWorkItemCoderName()).append("\n").append(new String((byte[])object, Utils.getEncoding()));
            mimeMessage.setText(stringBuffer.toString(), Utils.getEncoding());
            session.getTransport("smtp");
            Transport.send((Message)mimeMessage);
            log.debug((Object)("dispatch() mail sent to '" + string + "'"));
        }
        catch (Throwable throwable) {
            log.debug((Object)"Failed to dispatch workitem over SMTP", throwable);
            throw new DispatchingException("Failed to dispatch workitem over SMTP", throwable);
        }
        return null;
    }

    protected String determineSubject(WorkItem workItem) {
        String string = SUBJECT_PREFIX + workItem.getClass().getName();
        if (workItem instanceof InFlowWorkItem) {
            InFlowWorkItem inFlowWorkItem = (InFlowWorkItem)workItem;
            FlowExpressionId flowExpressionId = inFlowWorkItem.getLastExpressionId();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(SUBJECT_PREFIX).append(flowExpressionId.getEngineId()).append(":").append(flowExpressionId.getWorkflowInstanceId()).append(":").append(flowExpressionId.getExpressionId());
            string = stringBuffer.toString();
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

