/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.dispatch;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import javax.net.SocketFactory;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ReflectionUtils;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.dispatch.AbstractWorkItemDispatcher;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.listen.reply.WarningReply;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public class SocketDispatcher
extends AbstractWorkItemDispatcher {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$dispatch$SocketDispatcher == null ? (class$openwfe$org$engine$impl$dispatch$SocketDispatcher = SocketDispatcher.class$("openwfe.org.engine.impl.dispatch.SocketDispatcher")) : class$openwfe$org$engine$impl$dispatch$SocketDispatcher).getName());
    public static final String P_HOST = "host";
    public static final String P_PORT = "port";
    private static final int DEFAULT_PORT = 7007;
    public static final String P_SOCKET_TIMEOUT = "socketTimeout";
    public static final String P_SOCKET_FACTORY = "socketFactory";
    public static final String P_RETRY_COUNT = "retryCount";
    private String targetHost = null;
    private int targetPort = -1;
    private int retryCount = 2;
    private int socketTimeout = 120000;
    private SocketFactory socketFactory = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$dispatch$SocketDispatcher;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        block4: {
            super.init(string, applicationContext, map);
            this.targetHost = (String)map.get(P_HOST);
            if (this.targetHost == null) {
                this.targetHost = "127.0.0.1";
            }
            this.targetPort = MapUtils.getAsInt((Map)map, (String)P_PORT, (int)7007);
            this.retryCount = MapUtils.getAsInt((Map)map, (String)P_RETRY_COUNT, (int)3);
            this.socketTimeout = MapUtils.getAsInt((Map)map, (String)P_SOCKET_TIMEOUT, (int)120000);
            String string2 = (String)map.get(P_SOCKET_FACTORY);
            try {
                this.socketFactory = (SocketFactory)ReflectionUtils.invokeStatic(Class.forName(string2), (String)"getDefault", (Class[])new Class[0], (Object[])new Object[0]);
            }
            catch (Exception exception) {
                if (string2 != null) {
                    log.warn((Object)("Failed to use custom SocketFactory '" + string2 + "'"), (Throwable)exception);
                }
                this.socketFactory = SocketFactory.getDefault();
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("Using default socket factory '" + this.socketFactory.getClass().getName() + "'"));
            }
        }
    }

    protected byte[] encodeWorkitem(WorkItemCoder workItemCoder, WorkItem workItem) throws DispatchingException {
        long l = System.currentTimeMillis();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (workItem instanceof InFlowWorkItem) {
                ((InFlowWorkItem)workItem).setDispatchTime(Time.toIsoDate());
            }
            byte[] byArray = (byte[])workItemCoder.encode(workItem, this.getContext(), this.getParams());
            String string = this.getWorkItemCoderName() + " " + byArray.length + "\n\n";
            byteArrayOutputStream.write(string.getBytes(Utils.getEncoding()));
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.flush();
            if (log.isDebugEnabled()) {
                log.debug((Object)("encodeWorkitem() took " + (System.currentTimeMillis() - l)));
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new DispatchingException("Failed to encode workitem", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatch(WorkItem workItem) throws DispatchingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("dispatch() to " + this.targetHost + ":" + this.targetPort));
        }
        long l = System.currentTimeMillis();
        ListenerReply listenerReply = null;
        WorkItemCoder workItemCoder = this.instantiateEncoder();
        byte[] byArray = this.encodeWorkitem(workItemCoder, workItem);
        for (int i = 0; i < this.retryCount; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("dispatch() attempt #" + i));
            }
            Socket socket = null;
            OutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                socket = this.socketFactory.createSocket(this.targetHost, this.targetPort);
                socket.setSoTimeout(this.socketTimeout);
                socket.setTcpNoDelay(true);
                outputStream = socket.getOutputStream();
                inputStream = socket.getInputStream();
                outputStream.write(byArray);
                outputStream.flush();
                listenerReply = workItemCoder.getReplyCoder().decode(inputStream);
                if (listenerReply instanceof WarningReply) {
                    WarningReply warningReply = (WarningReply)listenerReply;
                    if (i == 0) {
                        log.warn((Object)("dispatch() problem \"" + warningReply.getMessage() + "\""));
                        if (warningReply.getCause() != null) {
                            log.warn((Object)"dispatch() problem", warningReply.getCause());
                        }
                    }
                    throw new DispatchingException("" + warningReply.getClass().getName() + "\n" + warningReply.getMessage());
                }
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("dispatch() #" + i + " is successful"));
                break;
            }
            catch (Throwable throwable) {
                log.info((Object)("dispatch() try #" + i), throwable);
                if (i >= this.retryCount - 1) {
                    throw new DispatchingException("last dispatch attempt failed", throwable);
                }
                Thread.currentThread();
                Thread.yield();
                continue;
            }
            finally {
                try {
                    outputStream.flush();
                }
                catch (Throwable throwable) {}
                try {
                    socket.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("dispatch() took " + (System.currentTimeMillis() - l)));
        }
        return this.handleReply(listenerReply);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

