/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.expool;

import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.expool.SimpleExpressionPool;
import openwfe.org.misc.Cache;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class CachedExpressionPool
extends SimpleExpressionPool {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$expool$CachedExpressionPool == null ? (class$openwfe$org$engine$impl$expool$CachedExpressionPool = CachedExpressionPool.class$("openwfe.org.engine.impl.expool.CachedExpressionPool")) : class$openwfe$org$engine$impl$expool$CachedExpressionPool).getName());
    public static String P_CACHE_SIZE = "cacheSize";
    private int cacheSize = -1;
    private Cache cache = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$CachedExpressionPool;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.cacheSize = MapUtils.getAsInt((Map)map, (String)P_CACHE_SIZE, (int)500);
        this.cache = new Cache(this.cacheSize);
        log.info((Object)("init() " + P_CACHE_SIZE + " : " + this.cacheSize));
    }

    public Cache getCache() {
        return this.cache;
    }

    public void add(FlowExpression flowExpression) throws PoolException {
        this.cache.put((Object)flowExpression.getId(), (Object)flowExpression);
        super.add(flowExpression);
    }

    public void update(FlowExpression flowExpression) throws PoolException {
        this.cache.put((Object)flowExpression.getId(), (Object)flowExpression);
        super.update(flowExpression);
    }

    public FlowExpression fetch(FlowExpressionId flowExpressionId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fetch() for " + flowExpressionId));
        }
        if (flowExpressionId == null) {
            return null;
        }
        FlowExpression flowExpression = (FlowExpression)this.cache.get((Object)flowExpressionId);
        if (flowExpression != null) {
            return flowExpression;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("fetch() not cached : " + flowExpressionId));
        }
        if ((flowExpression = super.fetch(flowExpressionId)) != null) {
            this.cache.put((Object)flowExpression.getId(), (Object)flowExpression);
        }
        return flowExpression;
    }

    public void removeExpression(FlowExpression flowExpression) {
        this.cache.remove((Object)flowExpression.getId());
        super.removeExpression(flowExpression);
    }

    public Element getStatus() {
        Element element = super.getStatus();
        element.addContent((Content)this.cache.getStatus());
        return element;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

