/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.expool;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.EngineEnvironmentId;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.expool.AbstractExpressionStore;
import openwfe.org.engine.impl.expool.ExpoolUtils;
import openwfe.org.misc.DirectoryFilter;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public abstract class FileExpressionStore
extends AbstractExpressionStore {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$expool$FileExpressionStore == null ? (class$openwfe$org$engine$impl$expool$FileExpressionStore = FileExpressionStore.class$("openwfe.org.engine.impl.expool.FileExpressionStore")) : class$openwfe$org$engine$impl$expool$FileExpressionStore).getName());
    public static String P_WORK_DIRECTORY = "workDirectory";
    public static final String DEFAULT_WORK_DIRECTORY = "work/engine/pool";
    private String workDirectory = null;
    private String engineEnvExpressionPath = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$FileExpressionStore;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$FileExpressionStore$StoreIterator;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.workDirectory = MapUtils.getAsString((Map)map, (String)P_WORK_DIRECTORY, (String)DEFAULT_WORK_DIRECTORY);
        this.workDirectory = Utils.getCanonicalPath((String)this.getContext().getApplicationDirectory(), (String)this.workDirectory);
        this.workDirectory = this.workDirectory + File.separator;
        this.engineEnvExpressionPath = this.workDirectory + "engine-env-expression.xml";
        log.info((Object)("init() workDirectory set to " + this.workDirectory));
    }

    protected abstract void saveExpression(String var1, FlowExpression var2) throws Exception;

    protected abstract FlowExpression loadExpression(String var1) throws Exception;

    public void storeExpression(FlowExpression flowExpression) throws PoolException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("storeExpression() for " + flowExpression.getId()));
        }
        long l = System.currentTimeMillis();
        try {
            File file = new File(this.determineDirName(flowExpression.getId()));
            if (!file.exists()) {
                file.mkdirs();
            }
            String string = this.determineFileName(flowExpression.getId());
            this.saveExpression(string, flowExpression);
        }
        catch (Exception exception) {
            throw new PoolException("Failed to store expression", exception);
        }
        long l2 = System.currentTimeMillis() - l;
        if (log.isDebugEnabled()) {
            log.debug((Object)("storeExpression() took " + l2 + " ms"));
        }
    }

    public void unstoreExpression(FlowExpression flowExpression) throws PoolException {
        String string = this.determineFileName(flowExpression.getId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("unstoreExpression() deleting file " + string));
        }
        File file = new File(string);
        boolean bl = file.delete();
        if (log.isDebugEnabled() && !bl) {
            log.debug((Object)"unstoreExpression() delete failed");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("unstoreExpression() unstored   " + flowExpression.getId()));
        }
    }

    public FlowExpression loadExpression(FlowExpressionId flowExpressionId) throws PoolException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadExpression() requested for " + flowExpressionId));
        }
        long l = System.currentTimeMillis();
        String string = this.determineFileName(flowExpressionId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadExpression() fileName is " + string));
        }
        FlowExpression flowExpression = null;
        try {
            flowExpression = this.loadExpression(string);
        }
        catch (Exception exception) {
            throw new PoolException("Failed to load expression", exception);
        }
        long l2 = System.currentTimeMillis() - l;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadExpression() took " + l2 + " ms"));
        }
        return flowExpression;
    }

    private String getLastDigit(FlowExpressionId flowExpressionId) {
        String string = flowExpressionId.getParentWorkflowInstanceId();
        return string.substring(string.length() - 1);
    }

    protected String determineDirName(FlowExpressionId flowExpressionId) {
        if (EngineEnvironmentId.ID.equals(flowExpressionId)) {
            return this.workDirectory;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.workDirectory);
        stringBuffer.append(Utils.ensureForFileName((String)flowExpressionId.getWorkflowDefinitionName()));
        stringBuffer.append("--");
        stringBuffer.append(Utils.ensureForFileName((String)flowExpressionId.getWorkflowDefinitionRevision()));
        stringBuffer.append(File.separator);
        stringBuffer.append(this.getLastDigit(flowExpressionId));
        stringBuffer.append(File.separator);
        stringBuffer.append(flowExpressionId.getParentWorkflowInstanceId());
        stringBuffer.append(File.separator);
        return stringBuffer.toString();
    }

    protected String determineFileName(FlowExpressionId flowExpressionId) {
        if (EngineEnvironmentId.ID.equals(flowExpressionId)) {
            return this.engineEnvExpressionPath;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.determineDirName(flowExpressionId));
        stringBuffer.append(Utils.ensureForFileName((String)flowExpressionId.getInitialEngineId()));
        stringBuffer.append("--");
        stringBuffer.append(flowExpressionId.getWorkflowInstanceId());
        stringBuffer.append("--");
        stringBuffer.append(flowExpressionId.getExpressionName());
        stringBuffer.append("--");
        stringBuffer.append(flowExpressionId.getExpressionId());
        stringBuffer.append(".xml");
        return stringBuffer.toString();
    }

    protected boolean cleanedDir(File file) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cleanedDir() called for  " + file.getPath()));
        }
        if (file.list().length > 0) {
            return false;
        }
        long l = -1L;
        try {
            l = Long.parseLong(file.getName());
        }
        catch (Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cleanedDir() not a wfid dir >" + file.getName() + "< skipping"));
            }
            return true;
        }
        long l2 = System.currentTimeMillis() - l;
        if (l2 > 60000L) {
            boolean bl = file.delete();
            if (log.isDebugEnabled()) {
                if (bl) {
                    log.debug((Object)("cleanedDir() removed dir : " + file.getPath()));
                } else {
                    log.debug((Object)("cleanedDir() failed to remove dir : " + file.getPath()));
                }
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("cleanedDir() did not remove young dir : " + file.getPath()));
        }
        return false;
    }

    public Iterator contentIterator(Class clazz) {
        return new StoreIterator(clazz);
    }

    private boolean isNotDigitDir(File file) {
        if (file.getName().length() != 1) {
            return true;
        }
        return !Character.isDigit(file.getName().charAt(0));
    }

    public int size() {
        int n = 0;
        File[] fileArray = new File(this.workDirectory).listFiles((FileFilter)new DirectoryFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            File[] fileArray2 = fileArray[i].listFiles(new FilenameFilter(".*\\.xml"));
            n += fileArray2.length;
        }
        return n;
    }

    public Element getStatus() {
        File[] fileArray;
        Element element;
        Iterator iterator;
        Element element2 = new Element(this.getName());
        element2.addContent((Content)XmlUtils.getClassElt((Service)this));
        element2.addContent((Content)XmlUtils.getRevisionElt((String)"$Id: FileExpressionStore.java 2899 2006-06-29 21:09:21Z jmettraux $"));
        int n = 0;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        File file = new File(this.workDirectory);
        File[] fileArray2 = file.listFiles((FileFilter)new DirectoryFilter());
        for (int i = 0; i < fileArray2.length; ++i) {
            iterator = fileArray2[i];
            if (log.isDebugEnabled()) {
                log.debug((Object)("getStatus() considering dir " + iterator));
            }
            element = ((File)((Object)iterator)).listFiles((FileFilter)new DirectoryFilter());
            for (int j = 0; j < ((File[])element).length; ++j) {
                if (this.isNotDigitDir(element[j])) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getStatus() considering digitDir " + element[j]));
                }
                fileArray = element[j].listFiles((FileFilter)new DirectoryFilter());
                for (int k = 0; k < fileArray.length; ++k) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getStatus() considering wfidDir " + fileArray[k]));
                    }
                    File[] fileArray3 = fileArray[k].listFiles(new ExpressionFilter());
                    n += fileArray3.length;
                    Utils.inc(hashMap, (String)((File)((Object)iterator)).getName(), (int)fileArray3.length);
                    for (int i2 = 0; i2 < fileArray3.length; ++i2) {
                        String string = fileArray3[i2].getName();
                        String string2 = fileArray[k].getName();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("getStatus() considering file " + string));
                        }
                        Utils.inc(hashMap2, (String)string2);
                    }
                }
            }
        }
        Element element3 = new Element("flows");
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            element = (String)iterator.next();
            Integer n2 = (Integer)hashMap.get(element);
            fileArray = new Element("flow");
            fileArray.setAttribute("def", (String)element);
            fileArray.setAttribute("expressions", n2.toString());
            element3.addContent((Content)fileArray);
        }
        iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            element = (String)iterator.next();
            Integer n3 = (Integer)hashMap2.get(element);
            fileArray = new Element("flow");
            fileArray.setAttribute("id", (String)element);
            fileArray.setAttribute("expressions", n3.toString());
            element3.addContent((Content)fileArray);
        }
        element2.addContent((Content)element3);
        element = new Element("expressionsStored");
        element.addContent((Content)new Text("" + n));
        element2.addContent((Content)element);
        return element2;
    }

    private boolean filenameDoesntMatch(Class clazz, File file) {
        if (clazz == null) {
            return false;
        }
        String[] stringArray = Definitions.getExpressionMap(this.getContext()).getNames(clazz);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "--" + stringArray[i] + "--";
            if (file.getName().indexOf(string) <= -1) continue;
            return false;
        }
        return true;
    }

    private static long extractInstanceId(String string) {
        int n = string.indexOf("--");
        if (n < 0) {
            return -1L;
        }
        try {
            return Long.parseLong(string.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            log.warn((Object)("failed to parse '" + string + "' (til '--') into a long"));
            return -1L;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class StoreIterator
    implements Iterator {
        private final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$expool$FileExpressionStore$StoreIterator == null ? (class$openwfe$org$engine$impl$expool$FileExpressionStore$StoreIterator = FileExpressionStore.class$("openwfe.org.engine.impl.expool.FileExpressionStore$StoreIterator")) : class$openwfe$org$engine$impl$expool$FileExpressionStore$StoreIterator).getName());
        private Class assignClass = null;
        private Level wfDirLevel = null;
        private Level digitDirLevel = null;
        private Level wfidDirLevel = null;
        private Level expressionLevel = null;
        private FlowExpression next = null;

        public StoreIterator(Class clazz) {
            this.assignClass = clazz;
            String[] stringArray = FileExpressionStore.this.determineExpressionShortNames(clazz);
            this.wfDirLevel = new Level("wf    (0)", null);
            this.digitDirLevel = new Level("digit (1)", this.wfDirLevel);
            this.wfidDirLevel = new Level("wfid  (2)", this.digitDirLevel);
            this.expressionLevel = new Level("exp   (3)", this.wfidDirLevel, new FilenameFilter(stringArray));
            this.wfDirLevel.init(new File(FileExpressionStore.this.workDirectory));
            this.next = this.fetchNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        private FlowExpression fetchNext() {
            File file = this.expressionLevel.next();
            if (file == null) {
                return null;
            }
            if (FileExpressionStore.this.filenameDoesntMatch(this.assignClass, file)) {
                return this.fetchNext();
            }
            FlowExpression flowExpression = null;
            try {
                flowExpression = FileExpressionStore.this.loadExpression(file.getPath());
            }
            catch (Throwable throwable) {
                this.log.warn((Object)("fetchNext() failed to load a file during iteration, skipping it" + throwable));
                return this.fetchNext();
            }
            if (!ExpoolUtils.isAssignableFromClass(flowExpression, this.assignClass)) {
                this.log.warn((Object)("fetchNext()  ? expression of class '" + flowExpression.getClass().getName() + "' not assignable from class '" + this.assignClass.getName() + "'"));
                return this.fetchNext();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("fetchNext()\n   assignClass : " + this.assignClass + "\n" + "   returning :   " + flowExpression.getClass().getName() + "   " + flowExpression.getId()));
            }
            return flowExpression;
        }

        public Object next() throws NoSuchElementException {
            FlowExpression flowExpression = this.next;
            if (flowExpression == null) {
                throw new NoSuchElementException();
            }
            this.next = this.fetchNext();
            return flowExpression;
        }

        public void remove() {
        }

        protected class Level {
            public String name = null;
            public Level previous = null;
            public int index = -1;
            public File[] files = null;
            public FileFilter fFilter = null;
            public java.io.FilenameFilter fnFilter = null;

            public Level(String string, Level level) {
                this.name = string;
                this.previous = level;
                this.fFilter = new DirectoryFilter();
            }

            public Level(String string, Level level, FileFilter fileFilter) {
                this.name = string;
                this.previous = level;
                this.fFilter = fileFilter;
            }

            public Level(String string, Level level, java.io.FilenameFilter filenameFilter) {
                this.name = string;
                this.previous = level;
                this.fnFilter = filenameFilter;
            }

            public void init(File file) {
                if (StoreIterator.this.log.isDebugEnabled()) {
                    StoreIterator.this.log.debug((Object)("init() '" + this.name + "' to " + file.getPath()));
                }
                this.index = 0;
                this.files = this.fFilter != null ? file.listFiles(this.fFilter) : (this.fnFilter != null ? file.listFiles(this.fnFilter) : file.listFiles());
                if (StoreIterator.this.log.isDebugEnabled()) {
                    if (this.files == null) {
                        StoreIterator.this.log.debug((Object)("init() '" + this.name + "' empty dir : " + file.getPath()));
                    } else {
                        StoreIterator.this.log.debug((Object)("init() '" + this.name + "' this.files.length is " + this.files.length));
                    }
                }
            }

            public File next() {
                if (this.files == null) {
                    if (this.previous == null) {
                        return null;
                    }
                    File file = this.previous.next();
                    if (file == null) {
                        return null;
                    }
                    if (FileExpressionStore.this.cleanedDir(file)) {
                        return this.next();
                    }
                    this.init(file);
                }
                return this.pnext();
            }

            private File pnext() {
                if (this.index < this.files.length) {
                    File file = this.files[this.index];
                    ++this.index;
                    if (StoreIterator.this.log.isDebugEnabled()) {
                        StoreIterator.this.log.debug((Object)("pnext() '" + this.name + "' f : " + file.getPath()));
                        StoreIterator.this.log.debug((Object)("pnext() '" + this.name + "' f.exists() ? " + file.exists()));
                    }
                    if (!file.exists()) {
                        return this.pnext();
                    }
                    if (StoreIterator.this.log.isDebugEnabled()) {
                        StoreIterator.this.log.debug((Object)("pnext() '" + this.name + "' returning " + file.getPath()));
                    }
                    return file;
                }
                this.files = null;
                return this.next();
            }
        }
    }

    private static class FilenameFilter
    implements java.io.FilenameFilter {
        private String[] shortNames = null;

        public FilenameFilter() {
        }

        public FilenameFilter(String string) {
            this.shortNames = new String[]{string};
        }

        public FilenameFilter(String[] stringArray) {
            this.shortNames = stringArray;
        }

        public boolean accept(File file, String string) {
            if (!string.endsWith(".xml")) {
                return false;
            }
            if (this.shortNames == null) {
                return true;
            }
            for (int i = 0; i < this.shortNames.length; ++i) {
                if (!string.matches(".*--" + this.shortNames[i] + "--.*\\.xml")) continue;
                return true;
            }
            return false;
        }
    }

    private static class ExpressionFilter
    implements java.io.FilenameFilter {
        private ExpressionFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".xml");
        }
    }
}

