/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.expool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.EngineEnvironmentId;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.expool.ExpoolUtils;
import openwfe.org.engine.impl.expool.SimpleExpressionPool;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class InMemoryExpressionPool
extends SimpleExpressionPool {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$expool$InMemoryExpressionPool == null ? (class$openwfe$org$engine$impl$expool$InMemoryExpressionPool = InMemoryExpressionPool.class$("openwfe.org.engine.impl.expool.InMemoryExpressionPool")) : class$openwfe$org$engine$impl$expool$InMemoryExpressionPool).getName());
    private Map expressionMap = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$InMemoryExpressionPool;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        try {
            this.reload();
        }
        catch (PoolException poolException) {
            log.warn((Object)"init() reload() failed, resuming with an empty expression pool. No flow instance could be rebuilt", (Throwable)((Object)poolException));
        }
    }

    public void add(FlowExpression flowExpression) throws PoolException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("add() " + flowExpression.getId()));
        }
        flowExpression.setApplicationContext(this.getContext());
        this.expressionMap.put(flowExpression.getId(), flowExpression);
        if (this.getStore() != null) {
            this.getStore().storeExpression(flowExpression);
        }
    }

    public int size() {
        return this.expressionMap.size();
    }

    public void update(FlowExpression flowExpression) throws PoolException {
        this.add(flowExpression);
    }

    public Environment fetchEngineEnvironment() {
        Environment environment = (Environment)this.fetch(EngineEnvironmentId.ID);
        if (environment == null) {
            if (this.getStore() == null) {
                Environment environment2 = new Environment();
                environment2.setId(EngineEnvironmentId.ID);
                environment2.setApplicationContext(this.getContext());
                this.expressionMap.put(environment2.getId(), environment2);
                return environment2;
            }
            environment = this.getStore().loadEngineEnvironment();
            try {
                this.update(environment);
            }
            catch (PoolException poolException) {
                log.warn((Object)"Failed to store Engine Environment.", (Throwable)((Object)poolException));
            }
        }
        return environment;
    }

    public FlowExpression fetch(FlowExpressionId flowExpressionId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fetch() for " + flowExpressionId));
        }
        return (FlowExpression)this.expressionMap.get(flowExpressionId);
    }

    public void removeExpression(FlowExpression flowExpression) {
        this.expressionMap.remove(flowExpression.getId());
        super.removeExpression(flowExpression);
    }

    public boolean isActive(FlowExpressionId flowExpressionId) {
        return this.expressionMap.get(flowExpressionId) != null;
    }

    public Iterator contentIterator(Class clazz) {
        ArrayList<FlowExpression> arrayList = new ArrayList<FlowExpression>(this.expressionMap.size());
        Iterator iterator = this.expressionMap.values().iterator();
        while (iterator.hasNext()) {
            FlowExpression flowExpression = (FlowExpression)iterator.next();
            if (!ExpoolUtils.isAssignableFromClass(flowExpression, clazz)) continue;
            arrayList.add(flowExpression);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentIterator() found " + arrayList.size() + " matching expressions"));
        }
        return arrayList.iterator();
    }

    protected void reload() throws PoolException {
        this.expressionMap = new HashMap(10000);
        if (this.getStore() != null) {
            this.getStore().loadAll(this.expressionMap);
        } else {
            log.info((Object)("reload() no store attached to " + this.getClass().getName()));
        }
        log.info((Object)("reload() done. Reloaded " + this.expressionMap.size() + " expressions."));
    }

    public Element getStatus() {
        Element element = new Element(this.getName());
        element.addContent((Content)XmlUtils.getClassElt((Service)this));
        element.addContent((Content)XmlUtils.getRevisionElt((String)"$Id: InMemoryExpressionPool.java 2717 2006-06-01 15:26:06Z jmettraux $"));
        Element element2 = new Element("pooledExpressionCount");
        element2.addContent("" + this.expressionMap.size());
        element.addContent((Content)element2);
        return element;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

