/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.expool;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import openwfe.org.AbstractService;
import openwfe.org.Application;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ReflectionUtils;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.control.auth.ControlPermission;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expool.ExpressionStore;
import openwfe.org.engine.expool.FailureStrategy;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.DoExpression;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.ExpressionWithTimeOut;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.GoneParentId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.TimeoutUtils;
import openwfe.org.engine.expressions.state.ExpressionState;
import openwfe.org.engine.expressions.state.FrozenState;
import openwfe.org.engine.expressions.state.NormalState;
import openwfe.org.engine.history.History;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.time.Schedulable;
import openwfe.org.time.Scheduler;
import openwfe.org.time.Time;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class SimpleExpressionPool
extends AbstractService
implements ExpressionPool {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$expool$SimpleExpressionPool == null ? (class$openwfe$org$engine$impl$expool$SimpleExpressionPool = SimpleExpressionPool.class$("openwfe.org.engine.impl.expool.SimpleExpressionPool")) : class$openwfe$org$engine$impl$expool$SimpleExpressionPool).getName());
    private static final String PP_RESCHEDULE_IN = "1m";
    public static final String P_SCHEDULER_PRECISION = "schedulerPrecision";
    public static final String P_FAILURE_STRATEGY_CLASS = "failureStrategyClass";
    protected static final String DEFAULT_FAILURE_STRATEGY_CLASSNAME = (class$openwfe$org$engine$impl$expool$FailureStrategyNone == null ? (class$openwfe$org$engine$impl$expool$FailureStrategyNone = SimpleExpressionPool.class$("openwfe.org.engine.impl.expool.FailureStrategyNone")) : class$openwfe$org$engine$impl$expool$FailureStrategyNone).getName();
    private final int C_LAUNCH = -1;
    private final int C_APPLY = 1;
    private ExpressionStore store = null;
    private TimerTask purgeTask = null;
    private Scheduler scheduler = null;
    private long schedFrequency = Time.parseTimeString((String)"3m");
    private Long expressionTimeOut = null;
    private FailureStrategy failureStrategy = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$SimpleExpressionPool;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$FailureStrategyNone;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$ExpressionWithTimeOut;
    static /* synthetic */ Class class$openwfe$org$time$Schedulable;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        String string2 = MapUtils.getAsString((Map)this.getParams(), (String)"purgeFrequency", (String)"4h");
        long l = Time.parseTimeString((String)string2);
        this.purgeTask = new TimerTask(){

            public void run() {
                try {
                    SimpleExpressionPool.this.purge();
                }
                catch (Throwable throwable) {
                    log.warn((Object)"purgeTask : problem", throwable);
                }
            }
        };
        Application.getTimer().schedule(this.purgeTask, 180000L, l);
        log.info((Object)("init() started purge daemon every '" + string2 + "'"));
        float f = MapUtils.getAsFloat((Map)map, (String)P_SCHEDULER_PRECISION, (float)0.25f);
        log.info((Object)("init() schedPrecision is " + f));
        this.schedFrequency = MapUtils.getAsTime((Map)map, (String)"whenFrequency", (String)"2m");
        log.info((Object)("init() schedFrequency is " + this.schedFrequency + " ms"));
        this.scheduler = new Scheduler(this.getContext().getApplicationName() + "::expool.sched");
        this.scheduler.setPrecision(f);
        this.scheduler.start();
        if (MapUtils.getAsBoolean((Map)this.getParams(), (String)"reschedule", (boolean)true)) {
            log.info((Object)"init() reschedule will occur in 1m");
            this.scheduler.scheduleIn(PP_RESCHEDULE_IN, (Schedulable)this, null);
        }
        this.expressionTimeOut = null;
        String string3 = MapUtils.getAsString((Map)this.getParams(), (String)"expressionTimeout");
        if (string3 != null && log.isDebugEnabled()) {
            log.debug((Object)("init() eto >" + string3 + "<"));
        }
        this.expressionTimeOut = TimeoutUtils.determineTimeout(string3);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() eto 0 is " + this.expressionTimeOut));
        }
        if (this.expressionTimeOut == null) {
            this.expressionTimeOut = ExpressionPool.DEFAULT_EXPRESSION_TIMEOUT;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() eto 1 is " + this.expressionTimeOut));
        }
        if (this.expressionTimeOut > -1L) {
            log.info((Object)("init() expool (engine-level) expression timeout set to " + this.expressionTimeOut + " ms  (" + Time.toTimeString((Long)this.expressionTimeOut, (boolean)false) + ")"));
        } else {
            log.info((Object)"init() expool (engine-level) expression timeout set to 'no timeout'");
        }
        String string4 = MapUtils.getAsString((Map)map, (String)P_FAILURE_STRATEGY_CLASS, (String)DEFAULT_FAILURE_STRATEGY_CLASSNAME);
        try {
            this.failureStrategy = (FailureStrategy)ReflectionUtils.initObjectOfClass((String)string4, (Map)map);
        }
        catch (Exception exception) {
            throw new ServiceException("failed to init FailureStrategy '" + string4 + "'", (Throwable)exception);
        }
        log.info((Object)"OpenWFE version : 1.7.1pre10");
    }

    public Long getExpressionTimeOut() {
        return this.expressionTimeOut;
    }

    public FailureStrategy getFailureStrategy() {
        return this.failureStrategy;
    }

    public void stop() throws ServiceException {
        super.stop();
        this.purgeTask.cancel();
        log.info((Object)"stop() PurgeDaemon stopped.");
        this.scheduler.stop();
        log.info((Object)"stop() scheduler stopped.");
        log.info((Object)("stop() Service '" + this.getName() + "' stopped."));
    }

    public void add(FlowExpression flowExpression) throws PoolException {
        flowExpression.setApplicationContext(this.getContext());
        this.getStore().storeExpression(flowExpression);
        if (log.isDebugEnabled()) {
            log.debug((Object)("add() added  " + flowExpression.getId()));
        }
    }

    public int size() {
        return this.getStore().size();
    }

    public synchronized Document dump() {
        Element element = new Element("expool");
        Document document = new Document(element);
        List list = this.listExpressions();
        element.setAttribute("time", new Date().toString());
        element.setAttribute("size", "" + list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FlowExpression flowExpression = (FlowExpression)iterator.next();
            element.addContent((Content)flowExpression.dump());
        }
        return document;
    }

    public void update(FlowExpression flowExpression) throws PoolException {
        this.getStore().storeExpression(flowExpression);
    }

    public FlowExpression fetch(FlowExpressionId flowExpressionId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("fetch() for " + flowExpressionId));
        }
        if (flowExpressionId == null) {
            return null;
        }
        FlowExpression flowExpression = null;
        try {
            flowExpression = this.getStore().loadExpression(flowExpressionId);
        }
        catch (PoolException poolException) {
            log.info((Object)("fetch() Failed to retrieve expression " + flowExpressionId + " because of " + (Object)((Object)poolException)));
            return null;
        }
        return flowExpression;
    }

    public Environment fetchEngineEnvironment() {
        Environment environment = this.getStore().loadEngineEnvironment();
        environment.setApplicationContext(this.getContext());
        return environment;
    }

    public FlowExpressionId getEnvironmentId(FlowExpressionId flowExpressionId) {
        FlowExpression flowExpression = this.fetch(flowExpressionId);
        if (flowExpression == null) {
            return null;
        }
        return flowExpression.getEnvironmentId();
    }

    protected FlowExpression fetchRootOfFlow(FlowExpressionId flowExpressionId) {
        FlowExpression flowExpression = this.fetch(flowExpressionId);
        FlowExpressionId flowExpressionId2 = flowExpression.getParent();
        if (flowExpressionId2 == null) {
            return flowExpression;
        }
        return this.fetchRootOfFlow(flowExpressionId2);
    }

    protected FlowExpression fetchRootOfFlow(String string) {
        Iterator iterator = this.contentIterator(null);
        while (iterator.hasNext()) {
            FlowExpression flowExpression = (FlowExpression)iterator.next();
            if (flowExpression instanceof Environment || !flowExpression.getId().getWorkflowInstanceId().equals(string)) continue;
            return this.fetchRootOfFlow(flowExpression.getId());
        }
        return null;
    }

    protected void log(FlowExpressionId flowExpressionId, WorkItem workItem, String string, String string2) {
        History history = Definitions.getHistory(this.getContext());
        if (log.isDebugEnabled()) {
            log.debug((Object)("" + flowExpressionId + " :: " + string + " :: " + string2));
        }
        if (history == null) {
            return;
        }
        history.log(flowExpressionId, workItem, string, null, string2);
    }

    private void applyOrLaunch(int n, FlowExpressionId flowExpressionId, InFlowWorkItem inFlowWorkItem) throws ApplyException {
        FlowExpression flowExpression = this.fetch(flowExpressionId);
        if (flowExpression == null) {
            log.warn((Object)("Failed to find expression  " + flowExpressionId + "  cannot apply it."));
            throw new ApplyException("Failed to find expression  " + flowExpressionId + "  cannot apply it.");
        }
        this.log(flowExpressionId, inFlowWorkItem, "-dbg", "applying");
        flowExpression.tag(inFlowWorkItem);
        flowExpression.touchApplyTime();
        if (n == -1) {
            flowExpression.launch(inFlowWorkItem);
        } else {
            SimpleExpressionPool.getState(flowExpression).apply(inFlowWorkItem);
        }
    }

    public void apply(FlowExpressionId flowExpressionId, InFlowWorkItem inFlowWorkItem) throws ApplyException {
        this.applyOrLaunch(1, flowExpressionId, inFlowWorkItem);
    }

    public void apply(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem) throws ApplyException {
        this.apply(flowExpression.getId(), inFlowWorkItem);
    }

    public void launch(FlowExpressionId flowExpressionId, InFlowWorkItem inFlowWorkItem) throws ApplyException {
        this.applyOrLaunch(-1, flowExpressionId, inFlowWorkItem);
    }

    public void launch(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem) throws ApplyException {
        this.launch(flowExpression.getId(), inFlowWorkItem);
    }

    public void replyToParent(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem) throws ReplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("replyToParent() fe.id     " + flowExpression.getId()));
            log.debug((Object)("replyToParent() fe.parent " + flowExpression.getParent()));
        }
        if (flowExpression.getParent() == null) {
            String string = "";
            if (flowExpression.getId().isInSubFlow()) {
                string = "sub";
            }
            this.log(flowExpression.getId(), inFlowWorkItem, "+END", "");
            this.removeExpression(flowExpression);
            return;
        }
        if (flowExpression.getParent() == GoneParentId.GONE_PARENT_ID) {
            this.log(flowExpression.getId(), inFlowWorkItem, "+GNE", "");
            this.removeExpression(flowExpression);
            return;
        }
        if (!flowExpression.getId().getWorkflowInstanceId().equals(flowExpression.getParent().getWorkflowInstanceId())) {
            this.log(flowExpression.getId(), inFlowWorkItem, "+END", "sub");
        }
        FlowExpressionId flowExpressionId = flowExpression.getParent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("replyToParent() \n   " + flowExpression.getId() + "\n   replies to\n   " + flowExpressionId));
        }
        if (flowExpression.getId().getEngineId().equals(flowExpressionId.getEngineId())) {
            this.reply(flowExpressionId, inFlowWorkItem);
        } else {
            this.replyToRemoteParent(flowExpressionId, inFlowWorkItem);
        }
        this.removeExpression(flowExpression);
    }

    protected void replyToRemoteParent(FlowExpressionId flowExpressionId, InFlowWorkItem inFlowWorkItem) throws ReplyException {
        this.log(flowExpressionId, inFlowWorkItem, "-dbg", "replying (to remote parent)");
        ParticipantMap participantMap = Definitions.getParticipantMap(this.getContext());
        Participant participant = participantMap.get(flowExpressionId.getEngineId());
        if (participant == null) {
            throw new ReplyException("No remote engine named '" + flowExpressionId.getEngineId() + "'");
        }
        try {
            participant.dispatch(this.getContext(), inFlowWorkItem);
        }
        catch (DispatchingException dispatchingException) {
            throw new ReplyException("Failed to reply to remote engine '" + flowExpressionId.getEngineId() + "'");
        }
    }

    public void reply(FlowExpressionId flowExpressionId, InFlowWorkItem inFlowWorkItem) throws ReplyException {
        this.log(flowExpressionId, inFlowWorkItem, "-dbg", "replying");
        FlowExpression flowExpression = this.fetch(flowExpressionId);
        if (flowExpression == null) {
            throw new ReplyException("Cannot reply : expression not found " + flowExpressionId);
        }
        SimpleExpressionPool.getState(flowExpression).reply(inFlowWorkItem);
        flowExpression.tag(inFlowWorkItem);
    }

    public void removeExpression(FlowExpression flowExpression) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeExpression() " + flowExpression.getId()));
        }
        try {
            if (this.getStore() != null) {
                this.getStore().unstoreExpression(flowExpression);
            }
            if (!(flowExpression instanceof Environment) && Environment.ownsEnvironment(flowExpression)) {
                this.removeEnvironment(flowExpression);
            }
            if (flowExpression instanceof Environment) {
                ((Environment)flowExpression).unbind();
            }
        }
        catch (PoolException poolException) {
            log.warn((Object)"removeExpression() trouble", (Throwable)((Object)poolException));
        }
    }

    public void removeExpression(FlowExpressionId flowExpressionId) {
        FlowExpression flowExpression;
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeExpression(fei) for " + flowExpressionId));
        }
        if ((flowExpression = this.fetch(flowExpressionId)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("removeExpression(fei) has already been removed : " + flowExpressionId));
            }
            return;
        }
        this.removeExpression(flowExpression);
    }

    public void removeEnvironment(FlowExpression flowExpression) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeEnvironment() for           " + flowExpression.getId()));
            log.debug((Object)("removeEnvironment() thus removing " + flowExpression.getEnvironmentId()));
        }
        this.removeExpression(flowExpression.getEnvironmentId());
    }

    public InFlowWorkItem childCancel(FlowExpressionId flowExpressionId) throws ApplyException {
        FlowExpression flowExpression;
        if (log.isDebugEnabled()) {
            log.debug((Object)("childCancel() " + flowExpressionId));
        }
        if ((flowExpression = this.fetch(flowExpressionId)) == null) {
            log.debug((Object)"childCancel() expression not found, not cancelling it.");
            return null;
        }
        InFlowWorkItem inFlowWorkItem = SimpleExpressionPool.getState(flowExpression).cancel();
        this.removeExpression(flowExpression);
        return inFlowWorkItem;
    }

    public void cancel(FlowExpressionId flowExpressionId) {
        FlowExpression flowExpression;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cancel() " + flowExpressionId));
        }
        if ((flowExpression = this.fetch(flowExpressionId)) == null) {
            return;
        }
        this.log(flowExpressionId, null, "+CNX", "cancelling exp");
        try {
            InFlowWorkItem inFlowWorkItem = SimpleExpressionPool.getState(flowExpression).cancel();
            if (inFlowWorkItem != null) {
                this.replyToParent(flowExpression, inFlowWorkItem);
            }
            this.removeExpression(flowExpression);
        }
        catch (Throwable throwable) {
            log.warn((Object)"cancel() Failed to cancel an expression, removing it from pool anyway.", throwable);
        }
    }

    public void cancelFlow(FlowExpressionId flowExpressionId) {
        FlowExpression flowExpression;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cancelFlow() requested by  " + flowExpressionId));
        }
        if ((flowExpression = this.fetchRootOfFlow(flowExpressionId)) == null) {
            log.warn((Object)("cancelFlow(fei) did not find root of flow for exp  " + flowExpressionId + ". Cannot cancel flow"));
            return;
        }
        this.cancel(flowExpression.getId());
    }

    public void cancelFlow(String string) {
        FlowExpression flowExpression;
        if (log.isDebugEnabled()) {
            log.debug((Object)("cancelFlow() for wfid " + string));
        }
        if ((flowExpression = this.fetchRootOfFlow(string)) == null) {
            log.warn((Object)("cancelFlow(l) did not find root of flow for wfid " + string + ". Cannot cancel flow"));
            return;
        }
        this.cancel(flowExpression.getId());
    }

    public void forget(FlowExpressionId flowExpressionId) {
        FlowExpression flowExpression = this.fetch(flowExpressionId);
        if (flowExpression == null) {
            return;
        }
        flowExpression.setParent(GoneParentId.GONE_PARENT_ID);
        flowExpression.storeItself();
    }

    public Iterator contentIterator(Class clazz) {
        return this.getStore().contentIterator(clazz);
    }

    protected synchronized void purge() {
        ExpressionWithTimeOut expressionWithTimeOut;
        FlowExpression flowExpression;
        long l = System.currentTimeMillis();
        HashSet<ExpressionWithTimeOut> hashSet = new HashSet<ExpressionWithTimeOut>();
        log.info((Object)"purge() starting...");
        Iterator iterator = this.contentIterator(class$openwfe$org$engine$expressions$ExpressionWithTimeOut == null ? (class$openwfe$org$engine$expressions$ExpressionWithTimeOut = SimpleExpressionPool.class$("openwfe.org.engine.expressions.ExpressionWithTimeOut")) : class$openwfe$org$engine$expressions$ExpressionWithTimeOut);
        while (iterator.hasNext()) {
            flowExpression = (FlowExpression)iterator.next();
            if (flowExpression.getApplyTime() == null || !(expressionWithTimeOut = (ExpressionWithTimeOut)((Object)flowExpression)).isTimeOutActivated() || flowExpression.getTimeSinceApplied() <= expressionWithTimeOut.determineTimeOut()) continue;
            hashSet.add(expressionWithTimeOut);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            flowExpression = iterator.next();
            expressionWithTimeOut = (ExpressionWithTimeOut)((Object)flowExpression);
            FlowExpression flowExpression2 = flowExpression;
            try {
                log.info((Object)("purge() Timeout reply for " + flowExpression2.getId()));
                expressionWithTimeOut.timeOutReply();
            }
            catch (ReplyException replyException) {
                log.warn((Object)("purge() Failed to reply to " + flowExpression2.getId()), (Throwable)((Object)replyException));
            }
        }
        long l2 = (System.currentTimeMillis() - l) / 1000L;
        log.info((Object)("purge() Purge ends. It took " + l2 + "s."));
    }

    private DoExpression lookupDoExpression(FlowExpression flowExpression, String string) throws ApplyException {
        String string2 = "__do__";
        string2 = string != null ? string2 + string : string2 + ".*";
        FlowExpressionId flowExpressionId = (FlowExpressionId)this.lookupVariable(flowExpression, string2);
        DoExpression doExpression = (DoExpression)this.fetch(flowExpressionId);
        if (doExpression == null) {
            throw new ApplyException("Cannot undo : didn't find 'do' named '" + string2 + "'");
        }
        return doExpression;
    }

    public void undo(FlowExpression flowExpression, String string) throws ApplyException {
        this.lookupDoExpression(flowExpression, string).undo();
    }

    public void redo(FlowExpression flowExpression, String string) throws ApplyException {
        this.lookupDoExpression(flowExpression, string).redo();
    }

    private boolean isSecurityManagerPresent() {
        try {
            return System.getProperty("java.security.manager") != null;
        }
        catch (AccessControlException accessControlException) {
            return true;
        }
    }

    private void securityCheck(String string) {
        if (this.isSecurityManagerPresent()) {
            AccessController.checkPermission((Permission)((Object)ControlPermission.newControlPermission(this.getName(), string)));
        }
    }

    public List listExpressions() {
        this.securityCheck("read");
        ArrayList arrayList = new ArrayList(2048);
        Iterator iterator = this.contentIterator(null);
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("listExpressions() returning " + arrayList.size() + " expressions"));
        }
        return arrayList;
    }

    public void unfreezeExpression(FlowExpressionId flowExpressionId) throws PoolException {
        this.securityCheck("freeze");
        FlowExpression flowExpression = this.fetch(flowExpressionId);
        try {
            SimpleExpressionPool.getState(flowExpression).exitState();
        }
        catch (ApplyException applyException) {
            throw new PoolException("Unfreeze failure", (Throwable)((Object)applyException));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("unfreezeExpression() unfroze " + flowExpressionId));
        }
        this.getHistory().log(flowExpression.getId(), null, "+UFZ", null, "");
    }

    public void freezeFlow(String string) throws PoolException {
        this.securityCheck("freeze");
        log.warn((Object)"freezeFlow() not yet implemented.");
        throw new PoolException("freezeFlow() not yet implemented.");
    }

    public void freezeExpression(FlowExpressionId flowExpressionId) throws PoolException {
        this.securityCheck("freeze");
        FlowExpression flowExpression = this.fetch(flowExpressionId);
        if (flowExpression.getState() != null) {
            throw new PoolException("Expression already in state '" + flowExpression.getState().getName() + "'");
        }
        flowExpression.setState(new FrozenState());
        flowExpression.storeItself();
        if (log.isDebugEnabled()) {
            log.debug((Object)("freezeExpression() froze " + flowExpressionId));
        }
        this.getHistory().log(flowExpression.getId(), null, "+FRZ", null, "");
    }

    protected Environment lookupEnvironment(FlowExpression flowExpression) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookupEnvironment() requester :       " + flowExpression.getId()));
        }
        if (flowExpression.getEnvironmentId() == null) {
            return this.fetchEngineEnvironment();
        }
        return (Environment)this.fetch(flowExpression.getEnvironmentId());
    }

    public Environment fetchRootEnvironment(FlowExpression flowExpression) {
        if (flowExpression instanceof Environment) {
            if (flowExpression.getEnvironmentId() == null) {
                return (Environment)flowExpression;
            }
            Environment environment = (Environment)this.fetch(flowExpression.getEnvironmentId());
            return this.fetchRootEnvironment(environment);
        }
        return this.fetchRootEnvironment(this.lookupEnvironment(flowExpression));
    }

    public void setVariable(FlowExpression flowExpression, String string, Object object) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setVariable() '" + string + "' -> " + object));
            if (flowExpression != null) {
                log.debug((Object)("setVariable() '" + string + "' for " + flowExpression.getId()));
            }
        }
        if (string.startsWith("///")) {
            this.fetchEngineEnvironment().put(string.substring(3), object);
            return;
        }
        if (string.startsWith("//")) {
            this.fetchEngineEnvironment().put(string.substring(2), object);
            return;
        }
        if (string.startsWith("/")) {
            Environment environment = this.fetchRootEnvironment(flowExpression);
            environment.put(string.substring(1), object);
            if (log.isDebugEnabled()) {
                log.debug((Object)("setVariable() put into " + environment.getId()));
            }
            return;
        }
        Environment environment = null;
        environment = flowExpression instanceof Environment ? (Environment)flowExpression : this.lookupEnvironment(flowExpression);
        if (log.isDebugEnabled()) {
            log.debug((Object)("setVariable() in local env  " + environment.getId()));
        }
        environment.put(string, object);
    }

    public Object lookupVariable(FlowExpression flowExpression, String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookupVariable() requester is  " + flowExpression.getId()));
            log.debug((Object)("lookupVariable() varname is   >" + string + "<"));
        }
        if (string.startsWith("///")) {
            return this.fetchEngineEnvironment().get(string.substring(3));
        }
        if (string.startsWith("//")) {
            return this.fetchEngineEnvironment().get(string.substring(2));
        }
        if (string.startsWith("/")) {
            return this.fetchRootEnvironment(flowExpression).get(string.substring(1));
        }
        Environment environment = this.lookupEnvironment(flowExpression);
        if (environment == null) {
            log.error((Object)("lookupVariable() didn't find environment for  " + flowExpression.getId()));
            return null;
        }
        return environment.lookup(string);
    }

    public Environment lookupContainingEnvironment(FlowExpression flowExpression, String string) {
        if (string.startsWith("//")) {
            return this.fetchEngineEnvironment();
        }
        if (string.startsWith("/")) {
            return this.fetchRootEnvironment(flowExpression);
        }
        Environment environment = this.lookupEnvironment(flowExpression);
        return environment.lookupContainingEnvironment(string);
    }

    public Object lookupLocalVariable(FlowExpression flowExpression, String string) {
        Environment environment = this.lookupEnvironment(flowExpression);
        return environment.get(string);
    }

    protected void reschedule() {
        FlowExpression flowExpression;
        log.info((Object)"reschedule() ...");
        log.debug((Object)"reschedule() from pool...");
        Iterator iterator = this.contentIterator(class$openwfe$org$time$Schedulable == null ? (class$openwfe$org$time$Schedulable = SimpleExpressionPool.class$("openwfe.org.time.Schedulable")) : class$openwfe$org$time$Schedulable);
        while (iterator.hasNext()) {
            flowExpression = (FlowExpression)iterator.next();
            if (!(flowExpression instanceof Schedulable)) continue;
            this.reschedule(flowExpression);
        }
        log.debug((Object)"reschedule() from engine-env...");
        iterator = this.fetchEngineEnvironment().getVariables().values().iterator();
        while (iterator.hasNext()) {
            flowExpression = iterator.next();
            if (!(flowExpression instanceof Schedulable)) continue;
            FlowExpression flowExpression2 = flowExpression;
            this.reschedule(flowExpression2);
        }
        log.info((Object)"reschedule() done.");
    }

    protected void reschedule(FlowExpression flowExpression) {
        flowExpression.setApplicationContext(this.getContext());
        ((Schedulable)flowExpression).reschedule(this.getScheduler());
        if (log.isInfoEnabled()) {
            log.info((Object)("reschedule() rescheduled  " + flowExpression.getId()));
        }
    }

    public Long reschedule(Scheduler scheduler) {
        return new Long(-1L);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void trigger(Object[] objectArray) {
        if (objectArray == null) {
            log.debug((Object)"trigger() rescheduling...");
            this.reschedule();
            return;
        }
        Object object = objectArray[0];
        Schedulable schedulable = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("trigger() triggering  " + object));
        }
        if (object instanceof Schedulable) {
            schedulable = (Schedulable)object;
        } else if (object instanceof FlowExpressionId) {
            schedulable = (Schedulable)this.fetch((FlowExpressionId)object);
        } else {
            log.warn((Object)("trigger() cannot reschedule instance of " + object.getClass().getName()));
            return;
        }
        if (schedulable == null) {
            log.warn((Object)"trigger() did not find schedulable expression. Forgetting it");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trigger() for  " + ((FlowExpression)schedulable).getId()));
        }
        schedulable.trigger(null);
    }

    public Long schedule(FlowExpressionId flowExpressionId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("schedule()  " + flowExpressionId));
        }
        return this.scheduler.scheduleIn(this.getSchedFrequency(), (Schedulable)this, new Object[]{flowExpressionId.copy()});
    }

    public Long scheduleAt(long l, FlowExpressionId flowExpressionId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("scheduleAt() at " + new Date(l) + "  " + flowExpressionId));
        }
        return this.scheduler.scheduleAt(l, (Schedulable)this, new Object[]{flowExpressionId.copy()});
    }

    public long getSchedFrequency() {
        return this.schedFrequency;
    }

    public String dumpExpool() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.listExpressions().iterator();
        while (iterator.hasNext()) {
            FlowExpression flowExpression = (FlowExpression)iterator.next();
            stringBuffer.append("- ").append(flowExpression.getId().toString()).append("\n");
            String string = "";
            if (flowExpression.getParent() != null) {
                string = flowExpression.getParent().toString();
            }
            stringBuffer.append("     p-> ").append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    public static ExpressionState getState(FlowExpression flowExpression) {
        ExpressionState expressionState = flowExpression.getState();
        if (expressionState == null) {
            expressionState = new NormalState();
        }
        expressionState.setExpression(flowExpression);
        return expressionState;
    }

    protected History getHistory() {
        return Definitions.getHistory(this.getContext());
    }

    public Element getStatus() {
        Element element = new Element(this.getName());
        element.addContent((Content)XmlUtils.getClassElt((Service)this));
        element.addContent((Content)XmlUtils.getRevisionElt((String)"$Id: SimpleExpressionPool.java 2905 2006-07-02 15:17:05Z jmettraux $"));
        Element element2 = new Element("pooledExpressionCount");
        element2.addContent("" + this.getStore().size());
        element.addContent((Content)element2);
        return element;
    }

    protected ExpressionStore getStore() {
        if (this.store != null) {
            return this.store;
        }
        this.store = Definitions.getExpressionStore(this.getContext());
        return this.store;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

