/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.functions;

import java.util.Random;
import openwfe.org.Utils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.impl.functions.NumericFunctions;
import openwfe.org.engine.impl.functions.StringList;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public abstract class BasicFunctions {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$functions$BasicFunctions == null ? (class$openwfe$org$engine$impl$functions$BasicFunctions = BasicFunctions.class$("openwfe.org.engine.impl.functions.BasicFunctions")) : class$openwfe$org$engine$impl$functions$BasicFunctions).getName());
    static /* synthetic */ Class class$openwfe$org$engine$impl$functions$BasicFunctions;

    public static String attributeCount(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return "" + inFlowWorkItem.getAttributes().size();
    }

    public static String fieldCount(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return "" + inFlowWorkItem.getAttributes().size();
    }

    public static String sum(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return NumericFunctions.add(flowExpression, inFlowWorkItem, stringArray);
    }

    public static String car(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        StringList stringList = new StringList(flowExpression, inFlowWorkItem, stringArray);
        return stringList.car();
    }

    public static String cdr(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        StringList stringList = new StringList(flowExpression, inFlowWorkItem, stringArray);
        return stringList.cdr();
    }

    public static String cons(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            return "";
        }
        String string = stringArray[0];
        StringList stringList = new StringList(flowExpression, inFlowWorkItem, stringArray, 1, 2);
        String string2 = stringList.cons(string);
        return string2;
    }

    public static String llen(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return "" + new StringList(flowExpression, inFlowWorkItem, stringArray).size();
    }

    public static String list(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return new StringList(flowExpression, inFlowWorkItem, stringArray).toString();
    }

    public static String elt(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            return "";
        }
        int n = Integer.parseInt(stringArray[0]);
        StringList stringList = new StringList(flowExpression, inFlowWorkItem, stringArray, 1, 2);
        return stringList.elt(n);
    }

    public static String shuffle(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        StringList stringList = new StringList(flowExpression, inFlowWorkItem, stringArray);
        return stringList.toString();
    }

    public static String reverse(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        StringList stringList = new StringList(flowExpression, inFlowWorkItem, stringArray);
        stringList.reverse();
        return stringList.toString();
    }

    public static String sort(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        StringList stringList = new StringList(flowExpression, inFlowWorkItem, stringArray);
        stringList.sort();
        log.debug((Object)("sort() result is >" + stringList.toString() + "<"));
        return stringList.toString();
    }

    public static String len(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length < 1) {
            return "0";
        }
        return "" + stringArray[0].length();
    }

    public static String substring(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length < 1) {
            return "";
        }
        String string = stringArray[0];
        if (string.length() == 0) {
            return "";
        }
        int n = 0;
        int n2 = string.length();
        if (stringArray.length > 1) {
            n = Integer.parseInt(stringArray[1]);
        }
        if (stringArray.length > 2) {
            n2 = Integer.parseInt(stringArray[2]);
        }
        if (n < 0) {
            n = string.length() + n;
        }
        if (n2 < 0) {
            n2 = string.length() + n2;
        }
        return string.substring(n, n2);
    }

    public static String rlong(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        Random random = new Random(System.currentTimeMillis());
        return "" + random.nextLong();
    }

    public static String rint(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        Random random = new Random(System.currentTimeMillis());
        return "" + random.nextInt();
    }

    public static String rdouble(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        Random random = new Random(System.currentTimeMillis());
        return "" + random.nextDouble();
    }

    public static String range(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        try {
            if (stringArray.length < 1) {
                return "";
            }
            if (stringArray.length == 1) {
                n2 = Integer.parseInt(stringArray[0]);
            } else if (stringArray.length == 2) {
                n = Integer.parseInt(stringArray[0]);
                n2 = Integer.parseInt(stringArray[1]);
            } else {
                n = Integer.parseInt(stringArray[0]);
                n2 = Integer.parseInt(stringArray[1]);
                n3 = Integer.parseInt(stringArray[2]);
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("" + n);
                n += n3;
            }
            return stringBuffer.toString();
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
    }

    public static String wfid(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return flowExpression.getId().getWorkflowInstanceId();
    }

    public static String fei(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return flowExpression.getId().toString();
    }

    public static String wfdname(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return flowExpression.getId().getWorkflowDefinitionName();
    }

    public static String wfdrevision(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return flowExpression.getId().getWorkflowDefinitionRevision();
    }

    public static String eval(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length < 1) {
            return "false";
        }
        String string = stringArray[0].trim().toLowerCase();
        log.debug((Object)("eval(fe, wi, args) s is >" + string + "<"));
        if (string.equals("true")) {
            return "true";
        }
        if (string.equals("false")) {
            return "false";
        }
        return "" + BasicFunctions.eval(stringArray[0]);
    }

    public static boolean eval(String string) {
        log.debug((Object)("eval(t) test >" + string + "<"));
        boolean bl = true;
        int n = string.indexOf("==");
        int n2 = string.indexOf("!=");
        int n3 = string.indexOf(">");
        int n4 = string.indexOf("<");
        if (n4 > -1) {
            n3 = n4;
        }
        log.debug((Object)("eval(t) k is " + n3));
        if (n3 > -1) {
            return BasicFunctions.evalInequality(n3, string);
        }
        if (n2 > -1) {
            n = n2;
            bl = false;
        }
        if (n < 0) {
            return string.trim().toLowerCase().equals("true");
        }
        if (n + 2 >= string.length()) {
            return false;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 2).trim();
        boolean bl2 = string2.equals(string3);
        if (bl) {
            return bl2;
        }
        return !bl2;
    }

    private static boolean evalInequality(int n, String string) {
        if (n >= string.length() - 1) {
            return false;
        }
        boolean bl = string.charAt(n) == '>';
        boolean bl2 = string.charAt(n + 1) == '=';
        log.debug((Object)("evalInequality() greaterThan  : " + bl));
        log.debug((Object)("evalInequality() orEquals     : " + bl2));
        if (bl2 && n == string.length() - 2) {
            return false;
        }
        int n2 = 2;
        if (bl2) {
            n2 = 3;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + n2).trim();
        log.debug((Object)("evalInequality() left   >" + string2 + "<"));
        log.debug((Object)("evalInequality() right  >" + string3 + "<"));
        int n3 = Utils.compareValues((Object)string2, (Object)string3);
        log.debug((Object)("evalInequality() c is " + n3));
        if (!bl) {
            n3 = -1 * n3;
        }
        log.debug((Object)("evalInequality() c is " + n3));
        if (bl2) {
            return n3 >= 0;
        }
        return n3 > 0;
    }

    public static String hashcode(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length < 1) {
            return "";
        }
        return "" + stringArray[0].hashCode();
    }

    public static String tsm(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return BasicFunctions.testandsetmutex(flowExpression, inFlowWorkItem, stringArray);
    }

    public static synchronized String testandsetmutex(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        String string = "/__mutex__";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        log.debug((Object)("tsm() mutex name >" + string + "< for " + flowExpression.getId()));
        Boolean bl = (Boolean)BasicFunctions.getExpressionPool(flowExpression).lookupVariable(flowExpression, string);
        if (bl == null) {
            BasicFunctions.getExpressionPool(flowExpression).setVariable(flowExpression, string, Boolean.TRUE);
            log.debug((Object)"tsm() returning 'true'");
            return "true";
        }
        return "false";
    }

    public static ExpressionPool getExpressionPool(FlowExpression flowExpression) {
        return Definitions.getExpressionPool(flowExpression.context());
    }

    public static String d_debugargs(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("|").append(stringArray[i]).append("| ");
        }
        String string = stringBuffer.toString().trim();
        log.debug((Object)("debugargs() result >" + string + "<"));
        return string;
    }

    public static String d_expoolsize(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return "" + BasicFunctions.getExpressionPool(flowExpression).size();
    }

    public static String lowercase(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length > 0) {
            return stringArray[0].toLowerCase();
        }
        return "";
    }

    public static String lc(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return BasicFunctions.lowercase(flowExpression, inFlowWorkItem, stringArray);
    }

    public static String uppercase(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length > 0) {
            return stringArray[0].toUpperCase();
        }
        return "";
    }

    public static String uc(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return BasicFunctions.uppercase(flowExpression, inFlowWorkItem, stringArray);
    }

    public static String matches(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length < 2) {
            return "false";
        }
        return "" + stringArray[0].matches(stringArray[1]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

