/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.functions;

import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public abstract class BooleanFunctions {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$functions$BooleanFunctions == null ? (class$openwfe$org$engine$impl$functions$BooleanFunctions = BooleanFunctions.class$("openwfe.org.engine.impl.functions.BooleanFunctions")) : class$openwfe$org$engine$impl$functions$BooleanFunctions).getName());
    public static final String S_TRUE = "true";
    public static final String S_FALSE = "false";
    static /* synthetic */ Class class$openwfe$org$engine$impl$functions$BooleanFunctions;

    public static String not(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length < 1) {
            log.debug((Object)"not() no args : returning false.");
            return S_FALSE;
        }
        log.debug((Object)("not() args[0] is '" + stringArray[0] + "'"));
        return BooleanFunctions.toString(!BooleanFunctions.toBoolean(stringArray[0]));
    }

    public static String and(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length < 1) {
            return S_FALSE;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (BooleanFunctions.toBoolean(stringArray[i])) continue;
            return S_FALSE;
        }
        return S_TRUE;
    }

    public static String or(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length < 1) {
            return S_FALSE;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!BooleanFunctions.toBoolean(stringArray[i])) continue;
            return S_TRUE;
        }
        return S_FALSE;
    }

    public static String xor(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length < 2) {
            return S_FALSE;
        }
        if (BooleanFunctions.toBoolean(stringArray[0]) ^ BooleanFunctions.toBoolean(stringArray[1])) {
            return S_TRUE;
        }
        return S_FALSE;
    }

    public static boolean toBoolean(String string) {
        if (string == null) {
            return false;
        }
        log.debug((Object)("toBoolean() interpreting >" + string.trim().toLowerCase() + "<"));
        return string.trim().toLowerCase().equals(S_TRUE);
    }

    public static String toString(boolean bl) {
        if (bl) {
            return S_TRUE;
        }
        return S_FALSE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

