/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.functions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public abstract class DateTimeFunctions {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$functions$DateTimeFunctions == null ? (class$openwfe$org$engine$impl$functions$DateTimeFunctions = DateTimeFunctions.class$("openwfe.org.engine.impl.functions.DateTimeFunctions")) : class$openwfe$org$engine$impl$functions$DateTimeFunctions).getName());
    private static SimpleDateFormat ts_shortSdf = new SimpleDateFormat("yyyyMMdd");
    private static SimpleDateFormat ts_longSdf = new SimpleDateFormat("yyyyMMddhhmmss");
    private static SimpleDateFormat ts_veryLongSdf = new SimpleDateFormat("yyyyMMddhhmmssSSS");
    static /* synthetic */ Class class$openwfe$org$engine$impl$functions$DateTimeFunctions;

    public static String now(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return Time.toIsoDate();
    }

    public static String today(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        String string = Time.toIsoDate();
        int n = string.indexOf(" ");
        return string.substring(0, n);
    }

    public static String toIsoDate(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length < 1) {
            return Time.toIsoDate();
        }
        if (stringArray.length > 1) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[1]);
                Date date = simpleDateFormat.parse(stringArray[0]);
                return Time.toIsoDate((long)date.getTime());
            }
            catch (Throwable throwable) {
                return "cannot parse date '" + stringArray[0] + "' with format '" + stringArray[1] + "'";
            }
        }
        log.debug((Object)("toIsoDate() attempting to parse \"" + stringArray[0] + "\""));
        Date date = Time.parseDate((String)stringArray[0]);
        if (date == null) {
            return "";
        }
        return Time.toIsoDate((long)date.getTime());
    }

    public static String date(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return DateTimeFunctions.toIsoDate(flowExpression, inFlowWorkItem, stringArray);
    }

    public static String tadd(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return DateTimeFunctions.timeAdd(flowExpression, inFlowWorkItem, stringArray);
    }

    public static String timeAdd(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("timeAdd() awaits 2 args.");
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = 1;
        if (string2.startsWith("-")) {
            string2 = string2.substring(1);
            n = -1;
        }
        long l = 0L;
        try {
            l = Time.fromIsoDate((String)string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Failed to parse date '" + string + "'");
        }
        long l2 = (long)n * Time.parseTimeString((String)string2);
        return Time.toIsoDate((long)(l + l2));
    }

    public static String ststamp(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return ts_shortSdf.format(new Date());
    }

    public static String ltstamp(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return ts_longSdf.format(new Date());
    }

    public static String timestamp(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return DateTimeFunctions.vltstamp(flowExpression, inFlowWorkItem, stringArray);
    }

    public static String vltstamp(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem, String[] stringArray) {
        return ts_veryLongSdf.format(new Date());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

