/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.history;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.history.HistoryException;
import openwfe.org.engine.history.HistoryIterator;
import openwfe.org.engine.impl.history.AbstractHistory;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.sql.SqlUtils;
import openwfe.org.sql.ds.OwfeDataSource;
import org.apache.log4j.Logger;

public class SqlHistory
extends AbstractHistory {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$history$SqlHistory == null ? (class$openwfe$org$engine$impl$history$SqlHistory = SqlHistory.class$("openwfe.org.engine.impl.history.SqlHistory")) : class$openwfe$org$engine$impl$history$SqlHistory).getName());
    public static final String P_TABLE_NAME = "tableName";
    protected static final String COLUMNS = "date_, engineid, wfdname, wfdrevision, wfdid, expression, eventcode, participantname, message";
    private OwfeDataSource dataSource = null;
    private String tableName = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$history$SqlHistory;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.dataSource = SqlUtils.lookupDataSource((ApplicationContext)applicationContext, (Map)map);
        log.info((Object)"dataSource set");
        this.tableName = MapUtils.getAsString((Map)map, (String)P_TABLE_NAME, (String)"owfehistory");
        log.info((Object)("using tableName '" + this.tableName + "'"));
    }

    protected String getInsertString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.tableName);
        stringBuffer.append(" (");
        stringBuffer.append(COLUMNS);
        stringBuffer.append(" )");
        stringBuffer.append(" VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        return stringBuffer.toString();
    }

    public void log(final FlowExpressionId flowExpressionId, final WorkItem workItem, final String string, final String string2, final String string3) {
        new Thread(){

            public void run() {
                SqlHistory.this.doLog(flowExpressionId, workItem, string, string2, string3);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLog(FlowExpressionId flowExpressionId, WorkItem workItem, String string, String string2, String string3) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDataSource().getConnection().prepareStatement(this.getInsertString());
            int n = 1;
            preparedStatement.setString(n++, new Timestamp(System.currentTimeMillis()).toString());
            preparedStatement.setString(n++, flowExpressionId.getEngineId());
            preparedStatement.setString(n++, flowExpressionId.getWorkflowDefinitionName());
            preparedStatement.setString(n++, flowExpressionId.getWorkflowDefinitionRevision());
            preparedStatement.setString(n++, flowExpressionId.getWorkflowInstanceId());
            preparedStatement.setString(n++, flowExpressionId.getExpressionName() + " " + flowExpressionId.getExpressionId());
            preparedStatement.setString(n++, string);
            if (string2 == null) {
                preparedStatement.setString(n++, "");
            } else {
                preparedStatement.setString(n++, string2);
            }
            preparedStatement.setString(n++, string3);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                log.warn((Object)"Failed to log to history", (Throwable)sQLException);
                this.getDataSource().logSQLException("log", log, sQLException);
            }
            catch (Throwable throwable) {
                SqlUtils.closeStatement(preparedStatement);
                this.getDataSource().releaseConnection();
                throw throwable;
            }
            SqlUtils.closeStatement((Statement)preparedStatement);
            this.getDataSource().releaseConnection();
        }
        SqlUtils.closeStatement((Statement)preparedStatement);
        this.getDataSource().releaseConnection();
    }

    public HistoryIterator browse(String string, String string2, long l, long l2, long l3) throws HistoryException {
        throw new HistoryException("Not yet implemented.");
    }

    public String getTableName() {
        return this.tableName;
    }

    protected OwfeDataSource getDataSource() {
        return this.dataSource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

