/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.launch;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.Utils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expressions.AbstractFlowExpression;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.DefineExpression;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ProcessDefinition;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.WithChildren;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.launch.ProcessLibrary;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class SimpleXmlLauncher
extends AbstractService
implements Launcher {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$launch$SimpleXmlLauncher == null ? (class$openwfe$org$engine$impl$launch$SimpleXmlLauncher = SimpleXmlLauncher.class$("openwfe.org.engine.impl.launch.SimpleXmlLauncher")) : class$openwfe$org$engine$impl$launch$SimpleXmlLauncher).getName());
    public static final String VALIDATE = "openwfe.org.engine.launcher.validate";
    static /* synthetic */ Class class$openwfe$org$engine$impl$launch$SimpleXmlLauncher;

    public FlowExpressionId launch(LaunchItem launchItem, boolean bl) throws LaunchException {
        InFlowWorkItem inFlowWorkItem = new InFlowWorkItem(launchItem);
        return this.launch(inFlowWorkItem, launchItem.getReplyTo(), launchItem.getWorkflowDefinitionUrl(), bl);
    }

    private Element parseXmlDefinition(String string, InFlowWorkItem inFlowWorkItem, boolean bl) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseXmlDefinition() from " + string));
        }
        if (string.startsWith("field:")) {
            String string2 = string.substring("field:".length());
            Attribute attribute = inFlowWorkItem.getAttributes().getField(string2);
            inFlowWorkItem.getAttributes().unsetField(string2);
            if (attribute == null) {
                throw new IllegalArgumentException("Field '" + string2 + "' is not present, cannot launch flow defined in it");
            }
            if (attribute instanceof XmlAttribute) {
                Content content = ((XmlAttribute)attribute).getContent();
                return (Element)content;
            }
            String string3 = attribute.toString();
            Element element = XmlUtils.extractXmlElement((String)string3);
            return element;
        }
        return XmlUtils.extractXml((String)string, (boolean)bl);
    }

    public FlowExpressionId launch(InFlowWorkItem inFlowWorkItem, FlowExpressionId flowExpressionId, String string, boolean bl) throws LaunchException {
        if (string.indexOf("::") > -1) {
            String string2 = this.launchExternalProcess(inFlowWorkItem, string, flowExpressionId);
            FlowExpressionId flowExpressionId2 = new FlowExpressionId();
            flowExpressionId2.setOwfeVersion("1.7.1pre10");
            flowExpressionId2.setWorkflowInstanceId(string2);
            return flowExpressionId2;
        }
        String string3 = Utils.expandUrl((String)string);
        if (log.isDebugEnabled()) {
            log.debug((Object)("launch() request for " + string3));
        }
        try {
            Cloneable cloneable;
            Element element = this.parseXmlDefinition(string3, inFlowWorkItem, SimpleXmlLauncher.shouldValidate());
            RawExpression rawExpression = RawExpression.getEmptyRawExpression(this.getContext());
            String string4 = element.getAttributeValue("name");
            String string5 = element.getAttributeValue("revision");
            if (string4 == null || string5 == null) {
                throw new LaunchException("Process definition is missing a 'name' and/or a 'revision' attribute.");
            }
            if (flowExpressionId == null) {
                cloneable = new FlowExpressionId();
                ((FlowExpressionId)cloneable).setOwfeVersion("1.7.1pre10");
                ((FlowExpressionId)cloneable).setEngineId(this.getContext().getApplicationName());
                ((FlowExpressionId)cloneable).setInitialEngineId(this.getContext().getApplicationName());
                ((FlowExpressionId)cloneable).setWorkflowDefinitionUrl(string3);
                ((FlowExpressionId)cloneable).setWorkflowDefinitionName(string4);
                ((FlowExpressionId)cloneable).setWorkflowDefinitionRevision(string5);
                ((FlowExpressionId)cloneable).setWorkflowInstanceId(RawExpression.determineNewWorkflowInstanceId());
                rawExpression.init(this.getContext(), null, (FlowExpressionId)cloneable, 0, (Object)element);
            } else {
                cloneable = new FlowExpressionId();
                ((FlowExpressionId)cloneable).setOwfeVersion("1.7.1pre10");
                ((FlowExpressionId)cloneable).setEngineId(this.getContext().getApplicationName());
                ((FlowExpressionId)cloneable).setInitialEngineId(this.getContext().getApplicationName());
                ((FlowExpressionId)cloneable).setWorkflowDefinitionUrl(string3);
                ((FlowExpressionId)cloneable).setWorkflowDefinitionName(string4);
                ((FlowExpressionId)cloneable).setWorkflowDefinitionRevision(string5);
                ((FlowExpressionId)cloneable).setExpressionName(element.getName());
                ((FlowExpressionId)cloneable).setExpressionId("0");
                ((FlowExpressionId)cloneable).setWorkflowInstanceId(RawExpression.determineNewWorkflowInstanceId());
                rawExpression.init(this.getContext(), null, flowExpressionId, (FlowExpressionId)cloneable, (Object)element);
            }
            this.getExpressionPool().add(rawExpression);
            cloneable = new HashMap(1);
            cloneable.put(string4, rawExpression.clone());
            if (log.isDebugEnabled()) {
                log.debug((Object)("launch() '" + string4 + "' -> " + rawExpression.getId()));
            }
            FlowExpressionId flowExpressionId3 = this.launchSub(inFlowWorkItem, flowExpressionId, rawExpression.getId(), (Map)((Object)cloneable), bl);
            if (log.isDebugEnabled()) {
                log.debug((Object)("launch() launched as sub : " + flowExpressionId3));
                log.debug((Object)("launch() returning :       " + flowExpressionId3.getWorkflowInstanceId()));
            }
            return flowExpressionId3;
        }
        catch (Throwable throwable) {
            throw new LaunchException("launch failed", throwable);
        }
    }

    public FlowExpressionId launchSub(InFlowWorkItem inFlowWorkItem, FlowExpressionId flowExpressionId, FlowExpressionId flowExpressionId2, Map map, boolean bl) throws LaunchException {
        this.loadLibrary();
        if (log.isDebugEnabled()) {
            log.debug((Object)("launchSub() for template " + flowExpressionId2));
            log.debug((Object)("launchSub() parentId is " + flowExpressionId));
        }
        RawExpression rawExpression = (RawExpression)this.getExpressionPool().fetch(flowExpressionId2);
        try {
            Cloneable cloneable;
            rawExpression = rawExpression.newInstance(flowExpressionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("launchSub() rawExp.parent was " + rawExpression.getParent()));
            }
            rawExpression.setParent(flowExpressionId);
            if (map != null || flowExpressionId == null) {
                log.debug((Object)"launchSub() generating a new env for self");
                cloneable = Environment.generateEnvironment(rawExpression);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("launchSub() generated env : " + ((AbstractFlowExpression)cloneable).getId()));
                }
                if (map != null) {
                    ((Environment)cloneable).putAll(map);
                }
            } else {
                log.debug((Object)"launchSub() using parent's env");
                cloneable = this.getExpressionPool().fetch(flowExpressionId);
                rawExpression.setEnvironmentId(cloneable.getEnvironmentId());
            }
            rawExpression.storeItself();
            cloneable = rawExpression.getId();
            InFlowWorkItem inFlowWorkItem2 = (InFlowWorkItem)inFlowWorkItem.clone();
            if (log.isDebugEnabled()) {
                log.debug((Object)("launchSub() rawExp.id is     " + cloneable));
                log.debug((Object)("launchSub() rawExp.parent is " + rawExpression.getParent()));
                log.debug((Object)("launchSub() applying " + cloneable));
                log.debug((Object)("launchSub() async ?  " + bl));
            }
            if (bl) {
                new Thread((FlowExpressionId)cloneable, inFlowWorkItem2){
                    private final /* synthetic */ FlowExpressionId val$id;
                    private final /* synthetic */ InFlowWorkItem val$subwi;
                    {
                        this.val$id = flowExpressionId;
                        this.val$subwi = inFlowWorkItem;
                    }

                    public void run() {
                        try {
                            log.debug((Object)"launchSub()  (now in async thread)");
                            SimpleXmlLauncher.this.getExpressionPool().launch(this.val$id, this.val$subwi);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("launchSub() applied " + this.val$id));
                            }
                        }
                        catch (Throwable throwable) {
                            log.warn((Object)"launchSub() failure", throwable);
                        }
                    }
                }.start();
            } else {
                this.getExpressionPool().apply((FlowExpressionId)cloneable, inFlowWorkItem2);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("launchSub() applied " + ((FlowExpressionId)cloneable).getWorkflowInstanceId()));
            }
            return cloneable;
        }
        catch (Exception exception) {
            log.debug((Object)"Failed to 'launch' RawExpression", (Throwable)exception);
            throw new LaunchException("Failed to 'launch' RawExpression", exception);
        }
    }

    public Map fetchAttributes(FlowExpression flowExpression, Object object) throws BuildException {
        if (object instanceof Map) {
            return (Map)object;
        }
        Element element = (Element)object;
        Map map = XmlUtils.fetchAttributes((Element)element);
        if (flowExpression instanceof WithChildren) {
            String string = element.getTextTrim();
            if (string != null && string.length() > 0 && element.getChildren().size() < 1) {
                map.put("__value__", element.getTextTrim());
                map.put("__content__", XmlUtils.xmlToString((Content)element));
            } else if (element.getContent().size() > 0) {
                map.put("__content__", XmlUtils.xmlToString((Content)element));
            }
        }
        return map;
    }

    public ProcessDefinition loadProcessDefinition(String string) throws BuildException {
        String string2 = Utils.expandUrl((String)string);
        Element element = null;
        try {
            element = XmlUtils.extractXml((String)string2, (boolean)SimpleXmlLauncher.shouldValidate());
        }
        catch (Throwable throwable) {
            throw new BuildException("Failed to load " + string2, throwable);
        }
        return this.loadProcessDefinition(string2, null, element);
    }

    public ProcessDefinition loadProcessDefinition(FlowExpressionId flowExpressionId, Object object) throws BuildException {
        Element element = null;
        if (object instanceof Element) {
            element = (Element)object;
        } else if (object instanceof RawExpression) {
            element = (Element)((RawExpression)object).getRaw();
        }
        if (element == null) {
            throw new BuildException("Cannot turn an instance of class " + object.getClass().getName() + " into a process definition");
        }
        return this.loadProcessDefinition(null, flowExpressionId, element);
    }

    private ProcessDefinition loadProcessDefinition(String string, FlowExpressionId flowExpressionId, Element element) throws BuildException {
        String string2 = null;
        String string3 = null;
        FlowExpressionId flowExpressionId2 = flowExpressionId;
        if (flowExpressionId2 == null) {
            flowExpressionId2 = new FlowExpressionId();
            string2 = element.getAttributeValue("name");
            string3 = element.getAttributeValue("revision");
            flowExpressionId2.setOwfeVersion("1.7.1pre10");
            flowExpressionId2.setWorkflowDefinitionUrl(string);
            flowExpressionId2.setWorkflowDefinitionName(string2);
            flowExpressionId2.setWorkflowDefinitionRevision(string3);
        } else {
            string2 = flowExpressionId2.getWorkflowDefinitionName();
            string3 = flowExpressionId2.getWorkflowDefinitionRevision();
        }
        try {
            RawExpression rawExpression = RawExpression.getEmptyRawExpression(this.getContext());
            rawExpression.init(this.getContext(), null, flowExpressionId2, 0, (Object)element);
            ProcessDefinition processDefinition = new ProcessDefinition(this.getContext(), string, string2, string3);
            FlowExpression flowExpression = rawExpression.resolveExpression(processDefinition);
            if (log.isDebugEnabled()) {
                log.debug((Object)("loadProcessDefinition() found something of class >" + flowExpression.getClass().getName() + "<"));
            }
            processDefinition.setSelf((DefineExpression)flowExpression);
            return processDefinition;
        }
        catch (Throwable throwable) {
            throw new BuildException("Failed to load " + string, throwable);
        }
    }

    public ProcessDefinition loadProcessDefinitionFromString(String string) throws BuildException {
        try {
            return this.loadProcessDefinition(null, XmlUtils.extractXmlDocument((String)string, (boolean)SimpleXmlLauncher.shouldValidate()).getRootElement());
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            throw new BuildException("Failed to extract xml from string xml definition", exception);
        }
    }

    public RawExpression eval(FlowExpression flowExpression, Object object, InFlowWorkItem inFlowWorkItem) throws Exception {
        if (object == null) {
            log.debug((Object)"eval() nothing to eval.");
            return null;
        }
        if (object instanceof Text) {
            String string = ((Text)object).getTextTrim();
            Object object2 = flowExpression.lookupVariable(string);
            if (object2 != null) {
                ValueUtils.setResult(inFlowWorkItem, AttributeUtils.java2owfe(object2));
            }
            log.debug((Object)"eval() just some text.");
            return null;
        }
        if (!(object instanceof Element)) {
            throw new ApplyException("cannot handle XML fragment of class " + object.getClass().getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("eval() xml is \n" + XmlUtils.xmlToString((Content)((Content)object))));
        }
        RawExpression rawExpression = RawExpression.getEmptyRawExpression(flowExpression.context());
        rawExpression.init(flowExpression.context(), flowExpression.getEnvironmentId(), flowExpression.getId(), 0, object);
        this.getExpressionPool().add(rawExpression);
        return rawExpression;
    }

    protected ExpressionPool getExpressionPool() {
        return Definitions.getExpressionPool(this.getContext());
    }

    protected ParticipantMap getParticipantMap() {
        return Definitions.getParticipantMap(this.getContext());
    }

    protected String launchExternalProcess(InFlowWorkItem inFlowWorkItem, String string, FlowExpressionId flowExpressionId) throws LaunchException {
        String[] stringArray = string.split("::");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (log.isDebugEnabled()) {
            log.debug((Object)("launchExternalProcess() engineId     >" + string2 + "<"));
            log.debug((Object)("launchExternalProcess() processUrl   >" + string3 + "<"));
        }
        Participant participant = this.getParticipantMap().get(string2);
        LaunchItem launchItem = new LaunchItem(string3, flowExpressionId, inFlowWorkItem);
        try {
            Object object = participant.dispatch(this.getContext(), launchItem);
            return object.toString();
        }
        catch (DispatchingException dispatchingException) {
            throw new LaunchException("Dispatching (launch) to engine '" + string2 + "' failed", (Throwable)((Object)dispatchingException));
        }
        catch (Throwable throwable) {
            log.warn((Object)"launchExternalProcess() unexpected exception", throwable);
            log.warn((Object)"launchExternalProcess() returning flowInstanceId = null");
            return null;
        }
    }

    private void loadLibrary() throws LaunchException {
        ProcessLibrary processLibrary = (ProcessLibrary)this.getContext().get("processLibrary");
        if (processLibrary == null) {
            return;
        }
        processLibrary.load();
    }

    public static boolean shouldValidate() {
        String string = System.getProperty(VALIDATE);
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).equals("true") || string.equals("yes") || string.equals("ok") || string.equals("validate");
    }

    public static Map extractXmlDescription(String string) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Element element = XmlUtils.extractXml((URL)new URL(string), (boolean)false);
            hashMap.put("root.element.name", element.getName());
            Iterator iterator = element.getChildren("description").iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                String string2 = element2.getAttributeValue("language");
                String string3 = element2.getTextNormalize();
                if (string2 == null) {
                    hashMap.put("default", string3);
                    continue;
                }
                hashMap.put(string2, string3);
            }
            return hashMap;
        }
        catch (Exception exception) {
            log.info((Object)("Failed to load description from " + string), (Throwable)exception);
            return new HashMap(0);
        }
    }

    public static String extractXmlDescription(String string, String string2) {
        Map map = SimpleXmlLauncher.extractXmlDescription(string);
        if (string2 == null) {
            return (String)map.get("default");
        }
        String string3 = (String)map.get(string2);
        if (string3 != null) {
            return string3;
        }
        return (String)map.get("default");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

