/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.launch;

import java.util.HashMap;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.map.XmlExpressionMap;
import openwfe.org.engine.impl.launch.SimpleXmlLauncher;
import openwfe.org.engine.launch.Launcher;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class XmlWorkflowDefinitionValidator {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator == null ? (class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator = XmlWorkflowDefinitionValidator.class$("openwfe.org.engine.impl.launch.XmlWorkflowDefinitionValidator")) : class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator).getName());
    static /* synthetic */ Class class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator;

    private static ApplicationContext prepareContext(String string) throws ServiceException {
        ApplicationContext applicationContext = new ApplicationContext();
        XmlExpressionMap xmlExpressionMap = new XmlExpressionMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("expressionMapFile", string);
        xmlExpressionMap.init("expressionMap", applicationContext, hashMap);
        SimpleXmlLauncher simpleXmlLauncher = new SimpleXmlLauncher();
        hashMap = new HashMap();
        simpleXmlLauncher.init("launcher", applicationContext, hashMap);
        applicationContext.put("expressionMap", (Object)xmlExpressionMap);
        applicationContext.put("launcher", (Object)simpleXmlLauncher);
        return applicationContext;
    }

    private static void printRealUsage() {
        System.out.println("\nUSAGE :\n");
        System.out.println("  java -cp XXX " + (class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator == null ? (class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator = XmlWorkflowDefinitionValidator.class$("openwfe.org.engine.impl.launch.XmlWorkflowDefinitionValidator")) : class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator).getName() + " {command_alias} {debug-level} {show-details} {path_to_expression-map} {flowDefinitionURL}\n");
    }

    private static void printUsage(String string) {
        System.out.println("\nUSAGE :\n");
        System.out.println("  " + string + " {flowDefinitionURL} [schema-validation]\n");
        System.out.println("  This command will complain if the given URL points to an invalid");
        System.out.println("  flow definition.");
        System.out.println("  If [schema-validation] is present and set to 'true', XSD schema validation");
        System.out.println("  will occur.\n");
    }

    private static void printCauses(boolean bl, Throwable throwable) {
        System.out.println("  ! " + throwable.getClass().getName() + " :");
        System.out.println("    " + throwable.getMessage());
        if (bl) {
            System.out.println();
            throwable.printStackTrace();
            System.out.println();
        }
        if (throwable.getCause() != null) {
            XmlWorkflowDefinitionValidator.printCauses(bl, throwable.getCause());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        if (stringArray.length < 4) {
            XmlWorkflowDefinitionValidator.printRealUsage();
            return;
        }
        if (stringArray.length < 5) {
            XmlWorkflowDefinitionValidator.printUsage(stringArray[0]);
            return;
        }
        BasicConfigurator.configure();
        log.getRootLogger().setLevel(Level.toLevel((String)stringArray[1], (Level)Level.INFO));
        boolean bl = stringArray[2].equals("true");
        System.out.println("\n       --  OpenWFE 1.7.1pre10  --");
        System.out.println("\n       --- preparing services for validation ---");
        ApplicationContext applicationContext = XmlWorkflowDefinitionValidator.prepareContext(stringArray[3]);
        Launcher launcher = Definitions.getLauncher(applicationContext);
        if (stringArray.length >= 6 && (string = stringArray[5].toLowerCase()) != null) {
            System.setProperty("openwfe.org.engine.launcher.validate", string);
        }
        System.out.println("\n       - XSD validation set to " + SimpleXmlLauncher.shouldValidate() + " -");
        System.out.println("\n       --- initiating validation ---");
        try {
            launcher.loadProcessDefinition(stringArray[4]);
        }
        catch (Throwable throwable) {
            System.out.println("\n       !! " + stringArray[4] + " is NOT valid !!\n");
            XmlWorkflowDefinitionValidator.printCauses(bl, throwable);
            System.out.println();
            System.exit(1);
            return;
        }
        System.out.println("\n       == " + stringArray[4] + " is valid ==\n");
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

