/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.listen;

import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.TimerTask;
import openwfe.org.Application;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.listen.WorkItemListener;
import openwfe.org.engine.workitem.WorkItemCoder;
import org.apache.log4j.Logger;

public class FileListener
extends WorkItemListener {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$listen$FileListener == null ? (class$openwfe$org$engine$impl$listen$FileListener = FileListener.class$("openwfe.org.engine.impl.listen.FileListener")) : class$openwfe$org$engine$impl$listen$FileListener).getName());
    public static final String P_DIRECTORY = "directory";
    public static final String P_FREQUENCY = "frequency";
    private static final String DEFAULT_FREQUENCY = "10s";
    private String directory = null;
    private TimerTask listenTask = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$listen$FileListener;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.directory = MapUtils.getAsString((Map)map, (String)P_DIRECTORY, (String)"in/");
        if (!this.directory.startsWith(File.separator)) {
            this.directory = this.getContext().getApplicationDirectory() + this.directory;
        }
        log.info((Object)("Input directory set to " + this.directory));
        long l = MapUtils.getAsTime((Map)map, (String)P_FREQUENCY, (String)DEFAULT_FREQUENCY);
        this.listenTask = new TimerTask(){

            public void run() {
                FileListener.this.load();
            }
        };
        Application.getTimer().schedule(this.listenTask, 10L, l);
    }

    public void stop() throws ServiceException {
        super.stop();
        this.listenTask.cancel();
        log.info((Object)("'" + this.getName() + "' Stopped."));
    }

    protected void load() {
        try {
            File file = new File(this.directory);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.loadFile(fileArray[i]);
            }
        }
        catch (Throwable throwable) {
            log.warn((Object)"load() failure", throwable);
        }
    }

    protected void loadFile(File file) {
        if (file.isDirectory()) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            WorkItemCoder workItemCoder = (WorkItemCoder)this.determineCoderAndLength(fileInputStream)[0];
            this.getConsumer().use(workItemCoder.decode(fileInputStream, this.getContext(), this.getParams()));
            file.delete();
        }
        catch (Exception exception) {
            log.info((Object)("Rejecting item " + file.getPath()), (Throwable)exception);
            Utils.move((File)file, (String)(this.directory + "rejected/" + file.getName()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

