/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.listen;

import java.util.Map;
import java.util.TimerTask;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import openwfe.org.Application;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.listen.WorkItemListener;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.mail.MailUtils;
import org.apache.log4j.Logger;

public class MailListener
extends WorkItemListener {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$listen$MailListener == null ? (class$openwfe$org$engine$impl$listen$MailListener = MailListener.class$("openwfe.org.engine.impl.listen.MailListener")) : class$openwfe$org$engine$impl$listen$MailListener).getName());
    public static final String P_ACCOUNT_URL = "accountUrl";
    public static final String P_FOLDER = "folder";
    public static final String P_FREQUENCY = "frequency";
    private static final String DEFAULT_FREQUENCY = "30s";
    private URLName account = null;
    private String folder = null;
    private TimerTask pollTask = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$listen$MailListener;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        String string2 = MapUtils.getMandatoryString((Map)map, (String)P_ACCOUNT_URL);
        this.account = new URLName(string2);
        this.folder = MapUtils.getAsString((Map)map, (String)P_FOLDER, (String)"INBOX");
        if (string2.startsWith("pop")) {
            this.folder = "INBOX";
        }
        long l = MapUtils.getAsTime((Map)map, (String)P_FREQUENCY, (String)DEFAULT_FREQUENCY);
        this.pollTask = new TimerTask(){

            public void run() {
                MailListener.this.poll();
            }
        };
        Application.getTimer().schedule(this.pollTask, 10L, l);
    }

    public void stop() throws ServiceException {
        super.stop();
        this.pollTask.cancel();
        log.info((Object)("'" + this.getName() + "' Stopped."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected synchronized void poll() {
        block17: {
            Session session = null;
            Folder folder = null;
            Store store = null;
            session = MailUtils.getMailSession((Map)this.getParams());
            store = session.getStore(this.account);
            store.connect();
            folder = store.getFolder(this.folder);
            folder.open(2);
            Message[] messageArray = folder.getMessages();
            log.debug((Object)("poll() examining " + messageArray.length + " messages"));
            for (int i = 0; i < messageArray.length; ++i) {
                Message message = messageArray[i];
                log.debug((Object)("poll() message subject is >" + message.getSubject() + "<"));
                try {
                    this.handleMessage(message);
                    message.setFlag(Flags.Flag.DELETED, true);
                    continue;
                }
                catch (Exception exception) {
                    log.warn((Object)("Failed to handle message >" + message.getSubject() + "<. Skipped."));
                }
            }
            Object var9_9 = null;
            try {
                folder.close(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                store.close();
            }
            catch (Throwable throwable) {}
            break block17;
            {
                catch (Throwable throwable) {
                    log.warn((Object)"poll() failure", throwable);
                    Object var9_10 = null;
                    try {
                        folder.close(true);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        store.close();
                    }
                    catch (Throwable throwable2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    folder.close(true);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                try {
                    store.close();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void handleMessage(Message message) throws Exception {
        String string = message.getContent().toString();
        int n = string.indexOf("\n");
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        WorkItem workItem = this.getCoder(string2).decode(string3, this.getContext(), this.getParams());
        this.getConsumer().use(workItem);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

