/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.listen;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ExceptionUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.listen.WorkItemListener;
import openwfe.org.engine.listen.reply.FatalReply;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.listen.reply.OkReply;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.net.ChannelInputStream;
import openwfe.org.net.SocketService;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class SocketListener
extends WorkItemListener {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$listen$SocketListener == null ? (class$openwfe$org$engine$impl$listen$SocketListener = SocketListener.class$("openwfe.org.engine.impl.listen.SocketListener")) : class$openwfe$org$engine$impl$listen$SocketListener).getName());
    public static final String EMBEDDED_SOCKET_SERVICE = ".embedded_socket_service";
    private SocketService socketService = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$listen$SocketListener;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.socketService = new SocketService(){

            public void handle(SelectionKey selectionKey) throws ServiceException {
                SocketListener.this.handle(selectionKey);
            }

            public Element getStatus() {
                return new Element(this.getName());
            }
        };
        this.socketService.setDefaultPort(7007);
        this.socketService.init(string + EMBEDDED_SOCKET_SERVICE, applicationContext, map);
    }

    public void stop() throws ServiceException {
        try {
            this.socketService.stop();
        }
        catch (ServiceException serviceException) {
            throw new ServiceException("Embedded SocketService failed to stop correctly", (Throwable)serviceException);
        }
        log.info((Object)("Service '" + this.getName() + "' got stopped."));
    }

    public Element getStatus() {
        Element element = new Element(this.getName());
        element.addContent((Content)this.socketService.getStatus());
        return element;
    }

    private void reply(WorkItemCoder workItemCoder, SocketChannel socketChannel, ListenerReply listenerReply) throws IOException, CodingException {
        byte[] byArray = workItemCoder.getReplyCoder().encode(listenerReply);
        socketChannel.write(ByteBuffer.wrap(byArray));
    }

    private void handle(SelectionKey selectionKey) {
        long l = System.currentTimeMillis();
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        if (log.isDebugEnabled()) {
            log.debug((Object)("handle() Incoming connection from " + socketChannel.socket().getInetAddress()));
        }
        WorkItem workItem = null;
        WorkItemCoder workItemCoder = null;
        ListenerReply listenerReply = null;
        try {
            ChannelInputStream channelInputStream = new ChannelInputStream((ReadableByteChannel)socketChannel);
            Object[] objectArray = this.determineCoderAndLength(channelInputStream);
            workItemCoder = (WorkItemCoder)objectArray[0];
            Integer n = (Integer)objectArray[1];
            if (n > -1) {
                channelInputStream.setBytesToRead(n.intValue());
            }
            workItem = workItemCoder.decode(channelInputStream, this.getContext(), this.getParams());
            if (log.isDebugEnabled()) {
                log.debug((Object)("handle() received wi of class " + workItem.getClass().getName()));
            }
            Object object = this.getConsumer().use(workItem);
            listenerReply = new OkReply(object);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.getRootCause((Throwable)throwable);
            listenerReply = new FatalReply("Fatal reply : " + throwable2.toString() + " : " + throwable2.getMessage(), throwable);
            log.warn((Object)("handle() Fatal reply : " + throwable), throwable);
        }
        try {
            if (workItemCoder != null) {
                this.reply(workItemCoder, socketChannel, listenerReply);
            } else {
                log.warn((Object)"handle() cannot reply : no coder found !");
            }
        }
        catch (Throwable throwable) {
            log.warn((Object)"handle() failed to reply to dispatcher", throwable);
        }
        try {
            socketChannel.close();
        }
        catch (Throwable throwable) {
            log.warn((Object)"handle() Channel to dispatcher closed with an exception ?!?", throwable);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handle() took " + (System.currentTimeMillis() - l)));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

