/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.participants;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.FactoryException;
import openwfe.org.ServiceException;
import openwfe.org.engine.participants.AbstractParticipantMap;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMapFactory;
import org.apache.log4j.Logger;

public class CompositeParticipantMap
extends AbstractParticipantMap {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$participants$CompositeParticipantMap == null ? (class$openwfe$org$engine$impl$participants$CompositeParticipantMap = CompositeParticipantMap.class$("openwfe.org.engine.impl.participants.CompositeParticipantMap")) : class$openwfe$org$engine$impl$participants$CompositeParticipantMap).getName());
    public static final String P_FACTORY = "factory";
    private List factoryNames = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$participants$CompositeParticipantMap;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.factoryNames = new ArrayList(3);
        Object v = map.get(P_FACTORY);
        if (v instanceof List) {
            this.factoryNames.addAll((List)v);
        } else {
            this.factoryNames.add(v);
        }
        this.reload();
    }

    protected void refreshMap() throws ServiceException {
        boolean bl = false;
        Iterator iterator = this.lookupFactories().iterator();
        while (iterator.hasNext()) {
            ParticipantMapFactory participantMapFactory = (ParticipantMapFactory)iterator.next();
            try {
                if (!participantMapFactory.hasSourceChanged()) continue;
                bl = true;
                break;
            }
            catch (FactoryException factoryException) {
                log.warn((Object)"refreshMap() problem with a ParticipantMapFactory", (Throwable)factoryException);
                throw new ServiceException("problem with a ParticipantMapFactory", (Throwable)factoryException);
            }
        }
        if (bl) {
            log.debug((Object)"refreshMap() yes, reloading participants is necessary...");
            this.reload();
        }
    }

    public List getFactoryNames() {
        return this.factoryNames;
    }

    protected ParticipantMapFactory lookupFactory(String string) {
        return (ParticipantMapFactory)this.getContext().lookup(string);
    }

    protected List lookupFactories() {
        ArrayList<ParticipantMapFactory> arrayList = new ArrayList<ParticipantMapFactory>(this.factoryNames.size());
        Iterator iterator = this.factoryNames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ParticipantMapFactory participantMapFactory = this.lookupFactory(string);
            if (participantMapFactory == null) {
                log.warn((Object)("lookupFactories() no ParticipantMapFactory named '" + string + "' found."));
                continue;
            }
            arrayList.add(participantMapFactory);
        }
        return arrayList;
    }

    protected void reload() throws ServiceException {
        log.info((Object)"reload()");
        this.getParticipants().clear();
        Iterator iterator = this.lookupFactories().iterator();
        while (iterator.hasNext()) {
            ParticipantMapFactory participantMapFactory = (ParticipantMapFactory)iterator.next();
            List list = null;
            try {
                list = participantMapFactory.createParticipants(this);
            }
            catch (FactoryException factoryException) {
                log.warn((Object)"reload() problem creating participants", (Throwable)factoryException);
                throw new ServiceException("problem creating participants", (Throwable)factoryException);
            }
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Participant participant = (Participant)iterator2.next();
                this.add(participant);
                log.info((Object)("reload() added participant '" + participant.getRegex() + "'"));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

