/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.participants;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;
import openwfe.org.engine.participants.LeafParticipant;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import org.apache.log4j.Logger;

public class FileArchivingParticipant
extends LeafParticipant {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$participants$FileArchivingParticipant == null ? (class$openwfe$org$engine$impl$participants$FileArchivingParticipant = FileArchivingParticipant.class$("openwfe.org.engine.impl.participants.FileArchivingParticipant")) : class$openwfe$org$engine$impl$participants$FileArchivingParticipant).getName());
    public static final String P_ARCHIVAL_DIR = "archivalDir";
    private String archivalDir = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$participants$FileArchivingParticipant;

    public void init(String string, Map map) {
        super.init(string, map);
        this.archivalDir = (String)map.get(P_ARCHIVAL_DIR);
        if (this.archivalDir == null) {
            this.archivalDir = "archive";
        }
        if (!this.archivalDir.endsWith(File.separator)) {
            this.archivalDir = this.archivalDir + File.separator;
        }
        log.info((Object)("init() archivalDir is '" + this.archivalDir + "'"));
    }

    public Object dispatch(ApplicationContext applicationContext, WorkItem workItem) throws DispatchingException {
        this.save(applicationContext, workItem);
        this.reply(applicationContext, workItem);
        return null;
    }

    public String getArchivalDir() {
        return this.archivalDir;
    }

    protected void save(ApplicationContext applicationContext, WorkItem workItem) throws DispatchingException {
        XmlWorkItemCoder xmlWorkItemCoder = Definitions.getXmlCoder(applicationContext);
        String string = this.determineFileName(((InFlowWorkItem)workItem).getId());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            byte[] byArray = xmlWorkItemCoder.doEncode(workItem);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            if (log.isDebugEnabled()) {
                log.debug((Object)("save() archived wi to '" + string + "'"));
            }
        }
        catch (Throwable throwable) {
            throw new DispatchingException("failed to archive (save) workitem to '" + string + "'", throwable);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected String determineFileName(FlowExpressionId flowExpressionId) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getArchivalDir());
        stringBuffer.append("arc_").append(flowExpressionId.getWorkflowDefinitionName()).append("_").append(flowExpressionId.getWorkflowDefinitionRevision()).append("__").append(flowExpressionId.getWorkflowInstanceId()).append("_e").append(flowExpressionId.getExpressionId()).append(".xml");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

