/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.participants;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.engine.participants.AbstractParticipantMap;
import openwfe.org.engine.participants.LeafParticipant;
import openwfe.org.ldap.LdapService;
import org.apache.log4j.Logger;

public class LdapParticipantMap
extends AbstractParticipantMap {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$participants$LdapParticipantMap == null ? (class$openwfe$org$engine$impl$participants$LdapParticipantMap = LdapParticipantMap.class$("openwfe.org.engine.impl.participants.LdapParticipantMap")) : class$openwfe$org$engine$impl$participants$LdapParticipantMap).getName());
    private LdapService m_ldapService;
    static /* synthetic */ Class class$openwfe$org$engine$impl$participants$LdapParticipantMap;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        try {
            this.m_ldapService = (LdapService)this.getContext().get("ldapService");
            if (this.m_ldapService == null) {
                throw new ServiceException("LDAP Service not found.");
            }
            this.buildMap();
        }
        catch (NamingException namingException) {
            throw new ServiceException("LDAP configure error", (Throwable)namingException);
        }
    }

    protected void refreshMap() throws ServiceException {
    }

    protected void buildMap() throws NamingException {
        LeafParticipant leafParticipant = new LeafParticipant();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("host", "127.0.0.1");
        hashMap.put("port", "7007");
        hashMap.put("dispatcherClass", "openwfe.org.engine.impl.dispatch.SocketDispatcher");
        hashMap.put("workItemCoder", "xmlCoder");
        leafParticipant.init("mainEngine", hashMap);
        this.add(leafParticipant);
        this.addGroups();
        this.addUsers();
    }

    private void addGroups() throws NamingException {
        String[] stringArray = this.m_ldapService.getGroups();
        for (int i = 0; i < stringArray.length; ++i) {
            LeafParticipant leafParticipant = new LeafParticipant();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("host", "127.0.0.1");
            hashMap.put("port", "7008");
            hashMap.put("dispatcherClass", "openwfe.org.engine.impl.dispatch.SocketDispatcher");
            leafParticipant.init(stringArray[i], hashMap);
            if (log.isDebugEnabled()) {
                log.debug((Object)("LDAP adding " + leafParticipant.getRegex()));
            }
            this.add(leafParticipant);
        }
    }

    private void addUsers() throws NamingException {
        String[] stringArray = this.m_ldapService.getUsers();
        for (int i = 0; i < stringArray.length; ++i) {
            LeafParticipant leafParticipant = new LeafParticipant();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("host", "127.0.0.1");
            hashMap.put("port", "7008");
            hashMap.put("dispatcherClass", "openwfe.org.engine.impl.dispatch.SocketDispatcher");
            leafParticipant.init(stringArray[i], hashMap);
            if (log.isDebugEnabled()) {
                log.debug((Object)("LDAP adding " + leafParticipant.getRegex()));
            }
            this.add(leafParticipant);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

