/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.participants;

import java.io.BufferedWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.Utils;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.participants.LeafParticipant;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.mail.MailUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class MailNotifiedParticipant
extends LeafParticipant {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$participants$MailNotifiedParticipant == null ? (class$openwfe$org$engine$impl$participants$MailNotifiedParticipant = MailNotifiedParticipant.class$("openwfe.org.engine.impl.participants.MailNotifiedParticipant")) : class$openwfe$org$engine$impl$participants$MailNotifiedParticipant).getName());
    public static final String P_TEMPLATE = "template";
    private static final String DEFAULT_TEMPLATE = "This is a notification :\n you received an OpenWFE workitem ('${__subject__}')";
    public static final String P_RECIPIENT_FIELD = "recipient-field";
    public static final String DEFAULT_RECIPIENT_FIELD = "__recipient__";
    public static final String P_MAIL_FROM = "mail-from";
    public static final String P_MAIL_ENCODING = "mail-encoding";
    private static final String DEFAULT_MAIL_ENCODING = "iso-8859-1";
    public static final String C_WORKITEM = "workitem";
    private String recipientField = null;
    private String mailFrom = null;
    private String mailEncoding = null;
    private String templateFileName = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$participants$MailNotifiedParticipant;

    public void init(String string, Map map) {
        super.init(string, map);
        this.recipientField = MapUtils.getAsString((Map)map, (String)P_RECIPIENT_FIELD, (String)DEFAULT_RECIPIENT_FIELD);
        this.mailFrom = MapUtils.getAsString((Map)map, (String)P_MAIL_FROM);
        this.mailEncoding = MapUtils.getAsString((Map)map, (String)P_MAIL_ENCODING);
        this.templateFileName = MapUtils.getAsString((Map)map, (String)P_TEMPLATE);
    }

    public Object dispatch(ApplicationContext applicationContext, WorkItem workItem) throws DispatchingException {
        Object object = super.dispatch(applicationContext, workItem);
        try {
            this.sendNotificationMail((InFlowWorkItem)workItem);
            log.debug((Object)"apply() notification email sucessfully sent.");
        }
        catch (Exception exception) {
            log.warn((Object)"apply() failed to send notification mail", (Throwable)exception);
        }
        return object;
    }

    private String[] splitSubjectAndBody(String string) {
        int n = (string = string.trim()).indexOf("\n");
        if (n < 0) {
            return new String[]{"", string};
        }
        return new String[]{string.substring(0, n), string.substring(n + 1)};
    }

    private void sendNotificationMail(InFlowWorkItem inFlowWorkItem) throws Exception {
        String string;
        Object object;
        Session session = MailUtils.getMailSession((Map)this.getParams());
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setSentDate(new Date());
        MailUtils.setMailFrom((Message)mimeMessage, (Map)this.getParams());
        VelocityContext velocityContext = new VelocityContext();
        Iterator iterator = inFlowWorkItem.getAttributes().stringKeySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            velocityContext.put((String)object, (Object)inFlowWorkItem.getAttributes().get((String)object).toString());
        }
        velocityContext.put(C_WORKITEM, (Object)inFlowWorkItem);
        object = AttributeUtils.owfe2list(inFlowWorkItem.getAttributes().get(new StringAttribute(this.recipientField)), ", *");
        iterator = object.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(string));
        }
        Velocity.init();
        string = Velocity.getTemplate((String)this.templateFileName);
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        string.merge((Context)velocityContext, (Writer)bufferedWriter);
        bufferedWriter.flush();
        bufferedWriter.close();
        String[] stringArray = this.splitSubjectAndBody(stringWriter.toString());
        String string2 = Utils.getEncoding();
        if (this.mailEncoding != null) {
            string2 = this.mailEncoding;
        }
        mimeMessage.setFrom((Address)new InternetAddress(this.mailFrom));
        mimeMessage.setSubject(stringArray[0]);
        mimeMessage.setText(stringArray[1], string2);
        session.getTransport("smtp");
        Transport.send((Message)mimeMessage);
        log.debug((Object)"sendNotificationMail() done.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

