/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.participants;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.Parameters;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.participants.AbstractParticipantMap;
import openwfe.org.engine.participants.CompositeParticipant;
import openwfe.org.engine.participants.LeafParticipant;
import openwfe.org.engine.participants.Participant;
import openwfe.org.xconf.XconfBuilder;
import openwfe.org.xconf.XconfElementBuilder;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class XmlParticipantMap
extends AbstractParticipantMap
implements XconfElementBuilder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$participants$XmlParticipantMap == null ? (class$openwfe$org$engine$impl$participants$XmlParticipantMap = XmlParticipantMap.class$("openwfe.org.engine.impl.participants.XmlParticipantMap")) : class$openwfe$org$engine$impl$participants$XmlParticipantMap).getName());
    private static final String E_PARTICIPANT = "participant";
    private static final String A_NAME = "name";
    private static final String A_REGEX = "regex";
    private static final String A_REF = "ref";
    private static final String A_CLASS = "class";
    public static final String P_PARTICIPANT_MAP_FILE = "participantMapFile";
    private XconfBuilder builder = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$participants$XmlParticipantMap;
    static /* synthetic */ Class class$openwfe$org$engine$participants$RefParticipant;
    static /* synthetic */ Class class$openwfe$org$engine$participants$LeafParticipant;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        String string2 = MapUtils.getAsString((Map)map, (String)P_PARTICIPANT_MAP_FILE, (String)"etc/engine/participant-map.xml");
        string2 = Utils.expandUrl((String)applicationContext.getApplicationDirectory(), (String)string2);
        log.info((Object)("init() url is " + string2));
        this.builder = new XconfBuilder(string2, (XconfElementBuilder)this);
        this.builder.buildConfig();
    }

    public void clearConfig() {
        this.setParticipants(new ArrayList());
    }

    public void parseElement(XconfBuilder xconfBuilder, Element element) throws ServiceException {
        this.buildParticipant(element);
    }

    public void refreshMap() throws ServiceException {
        this.builder.refreshConfig();
    }

    protected Participant buildParticipant(Element element) {
        String string;
        if (!element.getName().equals(E_PARTICIPANT)) {
            return null;
        }
        String string2 = element.getAttributeValue(A_REGEX);
        if (string2 == null) {
            string2 = element.getAttributeValue(A_NAME);
        }
        Map map = Parameters.extractParamsAndAttributes((Element)element);
        if (log.isDebugEnabled()) {
            log.debug((Object)("buildParticipant() building '" + string2 + "'"));
        }
        if (element.getChild(E_PARTICIPANT) != null) {
            return this.buildCompositeParticipant(element, string2, map);
        }
        String string3 = null;
        String string4 = element.getAttributeValue(A_REF);
        if (string4 != null) {
            string3 = (class$openwfe$org$engine$participants$RefParticipant == null ? (class$openwfe$org$engine$participants$RefParticipant = XmlParticipantMap.class$("openwfe.org.engine.participants.RefParticipant")) : class$openwfe$org$engine$participants$RefParticipant).getName();
        }
        if ((string = (String)map.get(A_CLASS)) != null) {
            string3 = string;
        }
        Participant participant = null;
        try {
            Class clazz;
            Class clazz2 = clazz = class$openwfe$org$engine$participants$LeafParticipant == null ? (class$openwfe$org$engine$participants$LeafParticipant = XmlParticipantMap.class$("openwfe.org.engine.participants.LeafParticipant")) : class$openwfe$org$engine$participants$LeafParticipant;
            if (string3 != null) {
                clazz = Class.forName(string3);
            }
            participant = (Participant)clazz.newInstance();
        }
        catch (Throwable throwable) {
            log.warn((Object)("buildParticipant() cannot build from class " + string3 + ". falling back to " + (class$openwfe$org$engine$participants$LeafParticipant == null ? (class$openwfe$org$engine$participants$LeafParticipant = XmlParticipantMap.class$("openwfe.org.engine.participants.LeafParticipant")) : class$openwfe$org$engine$participants$LeafParticipant).getName()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("buildParticipant() cannot build from class " + string3 + ". falling back to " + (class$openwfe$org$engine$participants$LeafParticipant == null ? (class$openwfe$org$engine$participants$LeafParticipant = XmlParticipantMap.class$("openwfe.org.engine.participants.LeafParticipant")) : class$openwfe$org$engine$participants$LeafParticipant).getName()), throwable);
            }
            participant = new LeafParticipant();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("buildParticipant() of class '" + participant.getClass().getName() + "'"));
        }
        participant.init(string2, map);
        this.add(participant);
        return participant;
    }

    protected CompositeParticipant buildCompositeParticipant(Element element, String string, Map map) {
        CompositeParticipant compositeParticipant = new CompositeParticipant();
        compositeParticipant.init(string, map);
        this.add(compositeParticipant);
        Iterator iterator = element.getChildren(E_PARTICIPANT).iterator();
        while (iterator.hasNext()) {
            compositeParticipant.add(this.buildParticipant((Element)iterator.next()));
        }
        return compositeParticipant;
    }

    public Element getStatus() {
        Element element = new Element(this.getName());
        element.setAttribute("source-url", this.builder.getSourceUrl().toString());
        return element;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

