/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.workitem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.Utils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ParticipantExpression;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.misc.Text;

public class MailFormCoder
implements WorkItemCoder {
    private static final String ID_PREFIX = " -- id : ";
    private static final String FIELD_END = " -- X --";
    private String name = null;
    private ListenerReplyCoder replyCoder = null;

    public void init(String string, List list, ListenerReplyCoder listenerReplyCoder) {
        this.name = string;
        this.replyCoder = listenerReplyCoder;
    }

    public String getName() {
        return this.name;
    }

    public ListenerReplyCoder getReplyCoder() {
        return this.replyCoder;
    }

    public WorkItem decode(Object object, ApplicationContext applicationContext, Map map) throws CodingException {
        Reader reader = null;
        if (object instanceof Reader) {
            reader = (Reader)object;
        } else if (object instanceof String) {
            reader = new StringReader((String)object);
        } else {
            throw new CodingException("Cannot decode workitem out of object of class " + object.getClass().getName());
        }
        InFlowWorkItem inFlowWorkItem = null;
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                Object object2;
                String string2;
                int n;
                string = this.removeBracket(string);
                if (inFlowWorkItem == null) {
                    n = string.indexOf(ID_PREFIX);
                    if (n < 0) continue;
                    string = string.substring(n);
                    string2 = string.substring(ID_PREFIX.length());
                    object2 = FlowExpressionId.fromParseableString(string2);
                    inFlowWorkItem = this.fetchWorkitem(applicationContext, (FlowExpressionId)object2);
                    continue;
                }
                if (string.indexOf(FIELD_END) >= 0) {
                    break;
                }
                n = string.indexOf(":");
                if (n < 2) continue;
                string2 = string.substring(0, n).trim();
                n = string.indexOf("[");
                object2 = string.substring(n + 1);
                if ((n = ((String)object2).lastIndexOf("]")) > 0) {
                    object2 = ((String)object2).substring(0, n);
                }
                inFlowWorkItem.getAttributes().puts(string2, (String)object2);
            }
        }
        catch (IOException iOException) {
            throw new CodingException("Failed to decode mail form workitem", iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Throwable throwable) {}
        }
        return inFlowWorkItem;
    }

    private String removeBracket(String string) {
        if (string.startsWith(">")) {
            return string.substring(1);
        }
        return string;
    }

    public Object encode(WorkItem workItem, ApplicationContext applicationContext, Map map) throws CodingException {
        Object object;
        boolean bl = true;
        if (map != null) {
            MapUtils.getAsBoolean((Map)map, (String)"monospace", (boolean)true);
        }
        InFlowWorkItem inFlowWorkItem = (InFlowWorkItem)workItem;
        StringBuffer stringBuffer = new StringBuffer();
        String string = workItem.getAttributes().sget("mf_header");
        if (string != null) {
            stringBuffer.append(string).append("\n");
        }
        this.printSep(stringBuffer, inFlowWorkItem);
        String string2 = workItem.getAttributes().sget("mf_fields");
        if (string2 != null) {
            object = string2.split(", *");
            for (int i = 0; i < ((String[])object).length; ++i) {
                String string3 = object[i].trim();
                String string4 = string3 + " : ";
                String string5 = workItem.getAttributes().sget(string3);
                if (string5 == null) {
                    string5 = "";
                }
                if (bl) {
                    string4 = Text.adjust((String)string4, (int)25, (boolean)false);
                }
                stringBuffer.append(string4).append("[ ").append(string5).append(" ]").append("\n");
            }
        }
        stringBuffer.append("\n").append(FIELD_END).append("\n\n");
        object = workItem.getAttributes().sget("mf_footer");
        if (object != null) {
            stringBuffer.append((String)object).append("\n");
        }
        try {
            return stringBuffer.toString().getBytes(Utils.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodingException("Failed to encode workitem", unsupportedEncodingException);
        }
    }

    public AttributeCoder getAttributeCoder(Attribute attribute) {
        return null;
    }

    public AttributeCoder getAttributeCoder(Class clazz) {
        return null;
    }

    public AttributeCoder getAttributeCoder(String string) {
        return null;
    }

    private void printSep(StringBuffer stringBuffer, InFlowWorkItem inFlowWorkItem) {
        stringBuffer.append("\n").append(ID_PREFIX).append(inFlowWorkItem.getLastExpressionId().toParseableString()).append("\n\n");
    }

    protected InFlowWorkItem fetchWorkitem(ApplicationContext applicationContext, FlowExpressionId flowExpressionId) {
        ParticipantExpression participantExpression = (ParticipantExpression)Definitions.getExpressionPool(applicationContext).fetch(flowExpressionId);
        return (InFlowWorkItem)participantExpression.getAppliedWorkitem().clone();
    }

    public static void main(String[] stringArray) throws Exception {
        InFlowWorkItem inFlowWorkItem = new InFlowWorkItem();
        inFlowWorkItem.setId(new FlowExpressionId());
        inFlowWorkItem.getAttributes().puts("mf_fields", "color, size, quantity");
        inFlowWorkItem.getAttributes().puts("mf_header", "This is our offer");
        inFlowWorkItem.getAttributes().puts("mf_footer", "Best regards,\n\nJohn");
        inFlowWorkItem.getAttributes().puts("color", "blue");
        inFlowWorkItem.getAttributes().puts("size", "XL");
        MailFormCoder mailFormCoder = new MailFormCoder();
        String string = new String((byte[])mailFormCoder.encode(inFlowWorkItem, null, null), Utils.getEncoding());
        System.out.println(string);
        inFlowWorkItem = (InFlowWorkItem)mailFormCoder.decode(new StringReader(string), null, null);
        System.out.println();
        System.out.println("color    : " + inFlowWorkItem.getAttributes().sget("color"));
        System.out.println("size     : " + inFlowWorkItem.getAttributes().sget("size"));
        System.out.println("quantity : " + inFlowWorkItem.getAttributes().sget("quantity"));
    }
}

