/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.workitem.xml;

import java.io.InputStream;
import openwfe.org.OpenWfeException;
import openwfe.org.engine.impl.workitem.xml.WicUtils;
import openwfe.org.engine.listen.reply.FatalReply;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.listen.reply.OkReply;
import openwfe.org.engine.listen.reply.WarningReply;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ReplyCoder
implements ListenerReplyCoder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$workitem$xml$ReplyCoder == null ? (class$openwfe$org$engine$impl$workitem$xml$ReplyCoder = ReplyCoder.class$("openwfe.org.engine.impl.workitem.xml.ReplyCoder")) : class$openwfe$org$engine$impl$workitem$xml$ReplyCoder).getName());
    public static final String OK_REPLY = "ok-reply";
    public static final String WARNING_REPLY = "warning-reply";
    public static final String FATAL_REPLY = "fatal-reply";
    public static final String CANCELLED_REPLY = "cancelled-reply";
    static /* synthetic */ Class class$openwfe$org$engine$impl$workitem$xml$ReplyCoder;

    public ListenerReply decode(Object object) throws CodingException {
        Element element = null;
        if (object instanceof Element) {
            element = (Element)object;
        } else if (object instanceof InputStream) {
            log.debug((Object)("decode() InputStream of class " + object.getClass().getName()));
            element = WicUtils.fetchElementFromStream((InputStream)object);
        } else {
            throw new CodingException("Cannot decode instances of class '" + object.getClass().getName() + "'");
        }
        if (element.getName().equals(OK_REPLY)) {
            String string = element.getAttributeValue("consumer-result");
            return new OkReply(string);
        }
        String string = element.getAttributeValue("message");
        String string2 = element.getAttributeValue("exceptionMessage");
        String string3 = element.getAttributeValue("exceptionStackTrace");
        WarningReply warningReply = null;
        if (element.getName().equals(WARNING_REPLY)) {
            warningReply = new WarningReply();
        } else if (element.getName().equals(FATAL_REPLY)) {
            warningReply = new FatalReply();
        } else {
            throw new CodingException("cannot decode replies named '" + element.getName() + "'");
        }
        warningReply.setMessage(string);
        warningReply.setExceptionMessage(string2);
        warningReply.setExceptionStackTrace(string3);
        return warningReply;
    }

    public byte[] encode(ListenerReply listenerReply) throws CodingException {
        Object var2_2 = null;
        try {
            if (listenerReply instanceof OkReply) {
                return XmlUtils.toByteArray((Element)this.encode((OkReply)listenerReply));
            }
            if (listenerReply instanceof FatalReply) {
                return XmlUtils.toByteArray((Element)this.encode((FatalReply)listenerReply));
            }
            if (listenerReply instanceof WarningReply) {
                return XmlUtils.toByteArray((Element)this.encode((WarningReply)listenerReply));
            }
        }
        catch (OpenWfeException openWfeException) {
            throw new CodingException("reply encoding failed", openWfeException);
        }
        throw new CodingException("Not able to encode replies of class '" + listenerReply.getClass().getName() + "'");
    }

    protected Element encode(OkReply okReply) {
        Element element = new Element(OK_REPLY);
        if (okReply.getConsumerResult() != null) {
            element.setAttribute("consumer-result", okReply.getConsumerResult().toString());
        }
        return element;
    }

    protected Element encode(WarningReply warningReply) {
        Element element = new Element(WARNING_REPLY);
        if (warningReply.getMessage() != null) {
            element.setAttribute("message", warningReply.getMessage());
        }
        if (warningReply.getExceptionMessage() != null) {
            element.setAttribute("exceptionMessage", warningReply.getExceptionMessage());
        }
        if (warningReply.getExceptionStackTrace() != null) {
            element.addContent(warningReply.getExceptionStackTrace());
        }
        return element;
    }

    protected Element encode(FatalReply fatalReply) {
        Element element = this.encode((WarningReply)fatalReply);
        element.setName(FATAL_REPLY);
        return element;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

