/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.workitem.xml;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.OpenWfeException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.workitem.AbstractWorkItemCoder;
import openwfe.org.engine.impl.workitem.xml.AbstractXmlAttributeCoder;
import openwfe.org.engine.impl.workitem.xml.WicUtils;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.participants.Filter;
import openwfe.org.engine.participants.FilterEntry;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.CancelItem;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.HistoryItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class XmlWorkItemCoder
extends AbstractWorkItemCoder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$workitem$xml$XmlWorkItemCoder == null ? (class$openwfe$org$engine$impl$workitem$xml$XmlWorkItemCoder = XmlWorkItemCoder.class$("openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder")) : class$openwfe$org$engine$impl$workitem$xml$XmlWorkItemCoder).getName());
    public static final String WORKFLOW_DEFINITION_URL = "workflow-definition-url";
    public static final String PROCESS_DEFINITION_URL = "process-definition-url";
    public static final String WORKFLOW_DEFINITION_NAME = "workflow-definition-name";
    public static final String WORKFLOW_DEFINITION_REVISION = "workflow-definition-revision";
    public static final String WORKFLOW_INSTANCE_ID = "workflow-instance-id";
    public static final String LAST_MODIFIED = "last-modified";
    public static final String SIGNER = "signer";
    public static final String SIGNATURE = "signature";
    public static final String ATTRIBUTES = "attributes";
    public static final String PARTICIPANT_NAME = "participant-name";
    public static final String DISPATCH_TIME = "dispatch-time";
    public static final String LAST_EXPRESSION_ID = "last-expression-id";
    public static final String LAUNCHITEM = "launchitem";
    public static final String CANCELITEM = "cancelitem";
    public static final String WORKITEM = "workitem";
    public static final String DESCRIPTION_MAP = "description-map";
    public static final String FLOW_EXPRESSION_ID = "flow-expression-id";
    public static final String OWFE_VERSION = "owfe-version";
    public static final String ENGINE_ID = "engine-id";
    public static final String INITIAL_ENGINE_ID = "initial-engine-id";
    public static final String EXPRESSION_NAME = "expression-name";
    public static final String EXPRESSION_ID = "expression-id";
    public static final String OPEN_FILTER = "open-filter";
    public static final String CLOSED_FILTER = "closed-filter";
    public static final String REGEX = "regex";
    public static final String PERMISSIONS = "permissions";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String ADD_ALLOWED = "add-allowed";
    public static final String REMOVE_ALLOWED = "remove-allowed";
    public static final String READ_WRITE = "read-write";
    public static final String READ_ONLY = "read-only";
    public static final String HIDE = "hide";
    public static final String FIELD = "field";
    public static final String HISTORY = "history";
    public static final String HISTORY_ITEM = "history-item";
    public static final String DATE = "date";
    public static final String AUTHOR = "author";
    public static final String HOST = "host";
    public static final int BUFFER_SIZE = 131072;
    public static final String SMAP = "smap";
    private ApplicationContext applicationContext = null;
    private Map perRepresentationMap = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$workitem$xml$XmlWorkItemCoder;

    public void init(String string, List list, ListenerReplyCoder listenerReplyCoder) {
        super.init(string, list, listenerReplyCoder);
        this.perRepresentationMap = new HashMap(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractXmlAttributeCoder abstractXmlAttributeCoder = (AbstractXmlAttributeCoder)iterator.next();
            this.perRepresentationMap.put(abstractXmlAttributeCoder.getRepresentationName(), abstractXmlAttributeCoder);
            log.debug((Object)("init() put '" + abstractXmlAttributeCoder.getClass().getName() + "' for '" + abstractXmlAttributeCoder.getRepresentationName() + "'"));
        }
    }

    public AbstractXmlAttributeCoder getAttributeCoder(String string) {
        return (AbstractXmlAttributeCoder)this.perRepresentationMap.get(string);
    }

    public byte[] doEncode(WorkItem workItem) throws CodingException {
        return (byte[])this.encode(workItem, null, null);
    }

    public Object encode(WorkItem workItem, ApplicationContext applicationContext, Map map) throws CodingException {
        log.debug((Object)("encode() wi of class " + workItem.getClass().getName()));
        this.applicationContext = applicationContext;
        Element element = this.encodeAsXml(workItem);
        try {
            byte[] byArray = XmlUtils.toByteArray((Element)element);
            return byArray;
        }
        catch (OpenWfeException openWfeException) {
            throw new CodingException("Failed to turn encoded workitem into a byte array", openWfeException);
        }
    }

    protected Element encodeSuper(WorkItem workItem) throws CodingException {
        Element element = new Element(WORKITEM);
        if (workItem.getLastModified() != null) {
            WicUtils.setAttribute(element, LAST_MODIFIED, workItem.getLastModified());
        }
        Element element2 = new Element(ATTRIBUTES);
        Element element3 = this.encodeAttribute(workItem.getAttributes());
        if (element3 != null) {
            element2.addContent((Content)element3);
        }
        element.addContent((Content)element2);
        return element;
    }

    public Element encodeAsXml(WorkItem workItem) throws CodingException {
        if (workItem instanceof InFlowWorkItem) {
            return this.encodeAsXml((InFlowWorkItem)workItem);
        }
        if (workItem instanceof LaunchItem) {
            return this.encodeAsXml((LaunchItem)workItem);
        }
        return this.encodeCancelItemAsXml((CancelItem)workItem);
    }

    protected Element encodeCancelItemAsXml(CancelItem cancelItem) throws CodingException {
        log.debug((Object)("encodeCancelItemAsXml() " + cancelItem.getId()));
        Element element = this.encodeSuper(cancelItem);
        element.setName(CANCELITEM);
        Element element2 = new Element(LAST_EXPRESSION_ID);
        element2.addContent((Content)this.encode(cancelItem.getId()));
        element.addContent((Content)element2);
        WicUtils.setAttribute(element, PARTICIPANT_NAME, cancelItem.getParticipantName());
        return element;
    }

    protected Element encodeAsXml(InFlowWorkItem inFlowWorkItem) throws CodingException {
        Element element;
        Element element2 = this.encodeSuper(inFlowWorkItem);
        WicUtils.setAttribute(element2, PARTICIPANT_NAME, inFlowWorkItem.getParticipantName());
        WicUtils.setAttribute(element2, DISPATCH_TIME, inFlowWorkItem.getDispatchTime());
        if (inFlowWorkItem.getLastExpressionId() != null) {
            element = new Element(LAST_EXPRESSION_ID);
            element.addContent((Content)this.encode(inFlowWorkItem.getLastExpressionId()));
            element2.addContent((Content)element);
        }
        if (inFlowWorkItem.getFilter() != null) {
            element2.addContent((Content)this.encode(inFlowWorkItem.getFilter()));
        }
        element = new Element(HISTORY);
        if (inFlowWorkItem.getHistory() != null) {
            Iterator iterator = inFlowWorkItem.getHistory().iterator();
            while (iterator.hasNext()) {
                element.addContent((Content)this.encodeAsXml((HistoryItem)iterator.next()));
            }
        }
        element2.addContent((Content)element);
        return element2;
    }

    public Element encodeAsXml(HistoryItem historyItem) {
        Element element = new Element(HISTORY_ITEM);
        element.setAttribute(DATE, "" + historyItem.getDate());
        element.setAttribute(AUTHOR, "" + historyItem.getAuthor());
        element.setAttribute(HOST, "" + historyItem.getHost());
        element.setAttribute(WORKFLOW_DEFINITION_NAME, "" + historyItem.getWorkflowDefinitionName());
        element.setAttribute(WORKFLOW_DEFINITION_REVISION, "" + historyItem.getWorkflowDefinitionRevision());
        element.setAttribute(WORKFLOW_INSTANCE_ID, "" + historyItem.getWorkflowInstanceId());
        element.setAttribute(EXPRESSION_ID, "" + historyItem.getExpressionId());
        element.setText(historyItem.getText());
        return element;
    }

    protected Element encodeAsXml(LaunchItem launchItem) throws CodingException {
        Element element = this.encodeSuper(launchItem);
        element.setName(LAUNCHITEM);
        element.setAttribute(PROCESS_DEFINITION_URL, launchItem.getWorkflowDefinitionUrl());
        Element element2 = new Element(DESCRIPTION_MAP);
        if (launchItem.getDescriptionMap() != null) {
            element2.addContent((Content)this.encodeAttribute(launchItem.getDescriptionMap()));
        }
        element.addContent((Content)element2);
        return element;
    }

    public Element encodeAttribute(Attribute attribute) throws CodingException {
        if (attribute == null) {
            return null;
        }
        AttributeCoder attributeCoder = (AttributeCoder)this.getPerClassMap().get(attribute.getClass().getName());
        if (attributeCoder == null) {
            Element element = new Element("error");
            Comment comment = new Comment("No coder for Attribute of class '" + attribute.getClass().getName() + "'");
            element.addContent((Content)comment);
            return element;
        }
        return (Element)attributeCoder.encode(attribute, null);
    }

    public Element encode(FlowExpressionId flowExpressionId) {
        Element element = new Element(FLOW_EXPRESSION_ID);
        WicUtils.setAttribute(element, OWFE_VERSION, flowExpressionId.getOwfeVersion());
        WicUtils.setAttribute(element, ENGINE_ID, flowExpressionId.getEngineId());
        WicUtils.setAttribute(element, INITIAL_ENGINE_ID, flowExpressionId.getInitialEngineId());
        WicUtils.setAttribute(element, WORKFLOW_DEFINITION_URL, flowExpressionId.getWorkflowDefinitionUrl());
        WicUtils.setAttribute(element, WORKFLOW_DEFINITION_NAME, flowExpressionId.getWorkflowDefinitionName());
        WicUtils.setAttribute(element, WORKFLOW_DEFINITION_REVISION, flowExpressionId.getWorkflowDefinitionRevision());
        WicUtils.setAttribute(element, WORKFLOW_INSTANCE_ID, "" + flowExpressionId.getWorkflowInstanceId());
        WicUtils.setAttribute(element, EXPRESSION_NAME, flowExpressionId.getExpressionName());
        WicUtils.setAttribute(element, EXPRESSION_ID, "" + flowExpressionId.getExpressionId());
        return element;
    }

    public Element encode(Filter filter) {
        Element element = null;
        element = filter.getType() == 0 ? new Element(OPEN_FILTER) : new Element(CLOSED_FILTER);
        WicUtils.setAttribute(element, NAME, filter.getName());
        WicUtils.setAttribute(element, ADD_ALLOWED, "" + filter.isAddAllowed());
        WicUtils.setAttribute(element, REMOVE_ALLOWED, "" + filter.isRemoveAllowed());
        this.encodeEntryList(element, filter);
        return element;
    }

    protected void encodeEntryList(Element element, Filter filter) {
        if (filter.getEntries() == null || filter.getEntries().size() < 1) {
            return;
        }
        Iterator iterator = filter.getEntries().iterator();
        while (iterator.hasNext()) {
            FilterEntry filterEntry = (FilterEntry)iterator.next();
            if (filterEntry.getPermissions().trim().equals("")) continue;
            Element element2 = new Element(FIELD);
            element2.setAttribute(REGEX, filterEntry.getFieldRegex());
            element2.setAttribute(PERMISSIONS, filterEntry.getPermissions());
            element.addContent((Content)element2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document fetchDocument(Object object) throws CodingException {
        Reader reader;
        InputStream inputStream;
        block20: {
            log.debug((Object)("fetchDocument() instance of " + object.getClass().getName()));
            inputStream = null;
            reader = null;
            try {
                if (object instanceof Reader) {
                    reader = (Reader)object;
                    break block20;
                }
                if (object instanceof File) {
                    reader = new FileReader((File)object);
                    break block20;
                }
                if (object instanceof String) {
                    reader = new StringReader((String)object);
                    break block20;
                }
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                    break block20;
                }
                if (object instanceof URL) {
                    inputStream = ((URL)object).openStream();
                    break block20;
                }
                if (object instanceof Document) {
                    return (Document)object;
                }
                if (!(object instanceof Element)) throw new CodingException("Cannot decode " + object.getClass().getName());
                return (Document)((Element)object).getParent();
            }
            catch (Throwable throwable) {
                throw new CodingException("Failed to decode workitem", throwable);
            }
        }
        if (inputStream != null) {
            log.debug((Object)"fetchDocument() using stream.");
        } else {
            log.debug((Object)"fetchDocument() using reader.");
        }
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = null;
        try {
            try {
                document = inputStream != null ? sAXBuilder.build(inputStream) : sAXBuilder.build(reader);
            }
            catch (Throwable throwable) {
                throw new CodingException("Failed to decode incoming workitem with SAX", throwable);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {}
        if (inputStream != null) {
            inputStream.close();
        }
        if (reader == null) return document;
        reader.close();
        return document;
    }

    public WorkItem decode(Object object, ApplicationContext applicationContext, Map map) throws CodingException {
        log.debug((Object)"decode()");
        Document document = this.fetchDocument(object);
        Element element = document.getRootElement();
        WorkItem workItem = null;
        log.debug((Object)("decode() rootElt is >" + element.getName() + "<"));
        if (element.getName().equals(WORKITEM)) {
            workItem = this.decodeInFlowWorkItem(element);
        } else if (element.getName().equals(LAUNCHITEM)) {
            workItem = this.decodeLaunchItem(element);
        } else if (element.getName().equals(CANCELITEM)) {
            workItem = this.decodeCancelItem(element);
        } else {
            throw new CodingException("Cannot handle elements named '" + element.getName() + "' as workitems");
        }
        this.decodeWorkItem(workItem, element);
        return workItem;
    }

    public FlowExpressionId decodeFlowExpressionId(Element element) {
        FlowExpressionId flowExpressionId = new FlowExpressionId();
        flowExpressionId.setOwfeVersion(element.getAttributeValue(OWFE_VERSION));
        flowExpressionId.setEngineId(element.getAttributeValue(ENGINE_ID));
        flowExpressionId.setInitialEngineId(element.getAttributeValue(INITIAL_ENGINE_ID));
        flowExpressionId.setWorkflowDefinitionUrl(element.getAttributeValue(WORKFLOW_DEFINITION_URL));
        flowExpressionId.setWorkflowDefinitionName(element.getAttributeValue(WORKFLOW_DEFINITION_NAME));
        flowExpressionId.setWorkflowDefinitionRevision(element.getAttributeValue(WORKFLOW_DEFINITION_REVISION));
        flowExpressionId.setExpressionName(element.getAttributeValue(EXPRESSION_NAME));
        flowExpressionId.setWorkflowInstanceId(element.getAttributeValue(WORKFLOW_INSTANCE_ID));
        flowExpressionId.setExpressionId(element.getAttributeValue(EXPRESSION_ID));
        return flowExpressionId;
    }

    protected void decodeWorkItem(WorkItem workItem, Element element) throws CodingException {
        workItem.setLastModified(element.getAttributeValue(LAST_MODIFIED));
        Element element2 = element.getChild(ATTRIBUTES);
        if (element2 != null && (element2 = element2.getChild(SMAP)) != null) {
            AbstractXmlAttributeCoder abstractXmlAttributeCoder = this.getAttributeCoder(SMAP);
            workItem.setAttributes((StringMapAttribute)abstractXmlAttributeCoder.decode(element2, null));
        }
    }

    public Attribute decodeAttribute(Element element) throws CodingException {
        AbstractXmlAttributeCoder abstractXmlAttributeCoder = this.getAttributeCoder(element.getName());
        if (abstractXmlAttributeCoder == null) {
            throw new CodingException("No coder for '" + element.getName() + "'");
        }
        return abstractXmlAttributeCoder.decode(element, null);
    }

    protected InFlowWorkItem decodeInFlowWorkItem(Element element) throws CodingException {
        InFlowWorkItem inFlowWorkItem = new InFlowWorkItem();
        Element element2 = element.getChild(LAST_EXPRESSION_ID);
        if (element2 != null) {
            element2 = element2.getChild(FLOW_EXPRESSION_ID);
            inFlowWorkItem.setId(this.decodeFlowExpressionId(element2));
        }
        inFlowWorkItem.setParticipantName(element.getAttributeValue(PARTICIPANT_NAME));
        inFlowWorkItem.setDispatchTime(element.getAttributeValue(DISPATCH_TIME));
        inFlowWorkItem.setFilter(this.decodeFilter(element));
        inFlowWorkItem.setHistory(this.decodeHistory(element));
        return inFlowWorkItem;
    }

    protected CancelItem decodeCancelItem(Element element) throws CodingException {
        CancelItem cancelItem = new CancelItem();
        Element element2 = element.getChild(LAST_EXPRESSION_ID);
        if (element2 != null) {
            element2 = element2.getChild(FLOW_EXPRESSION_ID);
            cancelItem.setId(this.decodeFlowExpressionId(element2));
        }
        cancelItem.setParticipantName(element.getAttributeValue(PARTICIPANT_NAME));
        return cancelItem;
    }

    protected List decodeHistory(Element element) {
        ArrayList<HistoryItem> arrayList = new ArrayList<HistoryItem>(7);
        Element element2 = element.getChild(HISTORY);
        if (element2 == null) {
            return arrayList;
        }
        Iterator iterator = element2.getChildren(HISTORY_ITEM).iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.decodeHistoryItem((Element)iterator.next()));
        }
        return arrayList;
    }

    protected HistoryItem decodeHistoryItem(Element element) {
        HistoryItem historyItem = new HistoryItem();
        historyItem.setDate(element.getAttributeValue(DATE));
        historyItem.setAuthor(element.getAttributeValue(AUTHOR));
        historyItem.setHost(element.getAttributeValue(HOST));
        historyItem.setText(element.getTextTrim());
        historyItem.setWorkflowDefinitionName(element.getAttributeValue(WORKFLOW_DEFINITION_NAME));
        historyItem.setWorkflowDefinitionRevision(element.getAttributeValue(WORKFLOW_DEFINITION_REVISION));
        try {
            historyItem.setWorkflowInstanceId(element.getAttributeValue(WORKFLOW_INSTANCE_ID));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        historyItem.setExpressionId(element.getAttributeValue(EXPRESSION_ID));
        return historyItem;
    }

    protected Filter decodeFilter(Element element) {
        Element element2 = element.getChild(CLOSED_FILTER);
        if (element2 == null) {
            element2 = element.getChild(OPEN_FILTER);
        }
        if (element2 == null) {
            return null;
        }
        Filter filter = new Filter();
        if (element2.getName().equals(OPEN_FILTER)) {
            filter.setType(0);
        } else {
            filter.setType(1);
        }
        filter.setName(element2.getAttributeValue(NAME));
        String string = element2.getAttributeValue(ADD_ALLOWED);
        filter.setAddAllowed(string != null && string.trim().toLowerCase().equals("true"));
        string = element2.getAttributeValue(REMOVE_ALLOWED);
        filter.setRemoveAllowed(string != null && string.trim().toLowerCase().equals("true"));
        filter.setEntries(this.decodeEntryList(element2));
        return filter;
    }

    protected List decodeEntryList(Element element) {
        ArrayList<FilterEntry> arrayList = new ArrayList<FilterEntry>();
        Iterator iterator = element.getChildren(FIELD).iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.getAttributeValue(REGEX).trim();
            String string2 = element2.getAttributeValue(PERMISSIONS).trim();
            FilterEntry filterEntry = new FilterEntry(string, string2);
            arrayList.add(filterEntry);
        }
        return arrayList;
    }

    protected LaunchItem decodeLaunchItem(Element element) throws CodingException {
        Element element2;
        LaunchItem launchItem = new LaunchItem();
        launchItem.setWorkflowDefinitionUrl(element.getAttributeValue(WORKFLOW_DEFINITION_URL));
        if (launchItem.getWorkflowDefinitionUrl() == null) {
            launchItem.setWorkflowDefinitionUrl(element.getAttributeValue(PROCESS_DEFINITION_URL));
        }
        if ((element2 = element.getChild(DESCRIPTION_MAP)) != null && element2.getChild(SMAP) != null) {
            element2 = element2.getChild(SMAP);
            AbstractXmlAttributeCoder abstractXmlAttributeCoder = this.getAttributeCoder(SMAP);
            StringMapAttribute stringMapAttribute = (StringMapAttribute)abstractXmlAttributeCoder.decode(element2, null);
            launchItem.setDescriptionMap(stringMapAttribute);
        }
        return launchItem;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

