/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.listen;

import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.OpenWfeException;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.history.History;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.listen.AbstractWorkItemConsumer;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class EngineWorkItemConsumer
extends AbstractWorkItemConsumer {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$listen$EngineWorkItemConsumer == null ? (class$openwfe$org$engine$listen$EngineWorkItemConsumer = EngineWorkItemConsumer.class$("openwfe.org.engine.listen.EngineWorkItemConsumer")) : class$openwfe$org$engine$listen$EngineWorkItemConsumer).getName());
    public static final String P_PROCESS_DEFINITION_IN_FIELD = "processDefinitionInField";
    public static final String P_ARCHIVE_PROCESS_DEFINITION_IN_FIELD = "archiveProcessDefinitionInField";
    private String processDefinitionField = null;
    private String archiveProcessDefinitionField = null;
    static /* synthetic */ Class class$openwfe$org$engine$listen$EngineWorkItemConsumer;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.processDefinitionField = MapUtils.getAsString((Map)map, (String)P_PROCESS_DEFINITION_IN_FIELD);
        if (this.processDefinitionField != null) {
            log.info((Object)("init() processDefinitionField set to '" + this.processDefinitionField + "'"));
        }
        this.archiveProcessDefinitionField = MapUtils.getAsString((Map)map, (String)P_ARCHIVE_PROCESS_DEFINITION_IN_FIELD);
        if (this.archiveProcessDefinitionField != null) {
            log.info((Object)("init() archiveProcessDefinitionField set to '" + this.archiveProcessDefinitionField + "'"));
        }
    }

    public Object use(final WorkItem workItem) throws OpenWfeException {
        Attribute attribute;
        if (workItem instanceof LaunchItem) {
            return this.getLauncher().launch((LaunchItem)workItem, true);
        }
        if (!(workItem instanceof InFlowWorkItem)) {
            throw new OpenWfeException("The engine cannot use a WorkItem of class " + workItem.getClass().getName());
        }
        InFlowWorkItem inFlowWorkItem = (InFlowWorkItem)workItem;
        if (log.isDebugEnabled()) {
            log.debug((Object)("use() received workitem with id  " + inFlowWorkItem.getLastExpressionId()));
            log.debug((Object)("use() received workitem for participant '" + inFlowWorkItem.getParticipantName() + "'"));
        }
        if (this.processDefinitionField != null && (attribute = inFlowWorkItem.getAttributes().getField(this.processDefinitionField)) != null && (attribute instanceof StringAttribute || attribute instanceof XmlAttribute)) {
            this.archiveProcessDefinition(attribute, inFlowWorkItem);
            this.getLauncher().launch(inFlowWorkItem, inFlowWorkItem.getId(), "field:" + this.processDefinitionField, true);
            return null;
        }
        new Thread(){

            public void run() {
                try {
                    EngineWorkItemConsumer.this.reply((InFlowWorkItem)workItem);
                }
                catch (Throwable throwable) {
                    log.error((Object)"use() problem while replying", throwable);
                }
            }
        }.start();
        return null;
    }

    protected void archiveProcessDefinition(Attribute attribute, InFlowWorkItem inFlowWorkItem) {
        if (this.archiveProcessDefinitionField == null) {
            return;
        }
        Attribute attribute2 = inFlowWorkItem.getAttributes().getField(this.archiveProcessDefinitionField);
        if (attribute2 != null && !(attribute2 instanceof ListAttribute)) {
            log.error((Object)("archiveProcessDefinition() field '" + this.archiveProcessDefinitionField + "' is of class " + attribute2.getClass().getName()));
            return;
        }
        ListAttribute listAttribute = (ListAttribute)attribute2;
        if (listAttribute == null) {
            listAttribute = new ListAttribute();
            inFlowWorkItem.getAttributes().setField(this.archiveProcessDefinitionField, listAttribute);
        }
        listAttribute.add(attribute);
    }

    protected void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        History history = Definitions.getHistory(this.getContext());
        if (history != null) {
            history.log(inFlowWorkItem.getLastExpressionId(), inFlowWorkItem, "+INC", inFlowWorkItem.getParticipantName(), "");
        }
        Definitions.getExpressionPool(this.getContext()).reply(inFlowWorkItem.getLastExpressionId(), inFlowWorkItem);
    }

    public String getProcessDefinitionField() {
        return this.processDefinitionField;
    }

    public String getArchiveProcessDefinitionField() {
        return this.archiveProcessDefinitionField;
    }

    protected Launcher getLauncher() {
        return Definitions.getLauncher(this.getContext());
    }

    public Element getStatus() {
        Element element = new Element(this.getName());
        element.addContent((Content)XmlUtils.getClassElt((Service)this));
        element.addContent((Content)XmlUtils.getRevisionElt((String)"$Id: EngineWorkItemConsumer.java 2855 2006-06-23 09:32:40Z jmettraux $"));
        return element;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

