/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.listen;

import java.io.IOException;
import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.listen.WorkItemConsumer;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.WorkItemCoderLoader;
import openwfe.org.misc.IoUtils;
import org.apache.log4j.Logger;

public abstract class WorkItemListener
extends AbstractService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$listen$WorkItemListener == null ? (class$openwfe$org$engine$listen$WorkItemListener = WorkItemListener.class$("openwfe.org.engine.listen.WorkItemListener")) : class$openwfe$org$engine$listen$WorkItemListener).getName());
    public static final String P_CONSUMER = "workItemConsumer";
    public static final String DEFAULT_CONSUMER = "consumer";
    private String consumerName = null;
    static /* synthetic */ Class class$openwfe$org$engine$listen$WorkItemListener;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.consumerName = MapUtils.getAsString((Map)map, (String)P_CONSUMER, (String)DEFAULT_CONSUMER);
        log.info((Object)("Listener '" + this.getName() + "' uses Consumer '" + this.consumerName + "'"));
    }

    protected WorkItemConsumer getConsumer() {
        return (WorkItemConsumer)this.getContext().lookup(this.consumerName);
    }

    protected WorkItemCoder getCoder(String string) {
        WorkItemCoderLoader workItemCoderLoader = Definitions.getWorkItemCoderLoader(this.getContext());
        WorkItemCoder workItemCoder = workItemCoderLoader.getCoder(string);
        if (workItemCoder == null) {
            log.debug((Object)("getCoder() did not find coder named '" + string + "' returning default coder"));
            return workItemCoderLoader.getDefaultCoder();
        }
        return workItemCoder;
    }

    protected String[] extractCoderNameAndLength(Object object) throws IOException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        while ((c = (char)IoUtils.read((Object)object)) != '\n') {
            if (c == ' ') {
                if (stringBuffer2 != null) break;
                stringBuffer2 = new StringBuffer();
            }
            if (stringBuffer2 == null) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer2.append(c);
        }
        if (stringBuffer2 != null) {
            IoUtils.read((Object)object);
        }
        String string = "-1";
        if (stringBuffer2 != null) {
            string = stringBuffer2.toString().trim();
        }
        log.debug((Object)("extractCoderName(is) coderName is >" + stringBuffer.toString() + "<"));
        log.debug((Object)("extractCoderName(is) length is >" + string + "<"));
        return new String[]{stringBuffer.toString(), string};
    }

    protected Object[] determineCoderAndLength(Object object) throws IOException {
        String[] stringArray = this.extractCoderNameAndLength(object);
        return new Object[]{this.getCoder(stringArray[0]), new Integer(stringArray[1])};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

