/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.misc;

import java.util.HashSet;
import java.util.Set;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.InFlowObject;
import org.apache.log4j.Logger;

public abstract class ThreadedStorer {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$misc$ThreadedStorer == null ? (class$openwfe$org$engine$misc$ThreadedStorer = ThreadedStorer.class$("openwfe.org.engine.misc.ThreadedStorer")) : class$openwfe$org$engine$misc$ThreadedStorer).getName());
    private Set inStorage = new HashSet();
    private Set inDeletion = new HashSet();
    static /* synthetic */ Class class$openwfe$org$engine$misc$ThreadedStorer;

    public InFlowObject get(FlowExpressionId flowExpressionId) {
        if (this.inDeletion.contains(flowExpressionId)) {
            log.debug((Object)("get() prevented dirty-read for " + flowExpressionId));
            return null;
        }
        return this.doGet(flowExpressionId);
    }

    public void store(final InFlowObject inFlowObject) {
        final FlowExpressionId flowExpressionId = inFlowObject.getId();
        if (this.inStorage.contains(flowExpressionId)) {
            log.debug((Object)"store() discarding supplemental store() request");
            return;
        }
        new Thread(){

            public void run() {
                try {
                    ThreadedStorer.this.doStore(inFlowObject);
                }
                catch (Throwable throwable) {
                    log.warn((Object)("store() failure for " + inFlowObject.getId()), throwable);
                }
                ThreadedStorer.this.inStorage.remove(flowExpressionId);
                log.debug((Object)"store() thread done.");
            }
        }.start();
        log.debug((Object)"store() done.");
    }

    public void remove(final InFlowObject inFlowObject) {
        new Thread(){

            public void run() {
                FlowExpressionId flowExpressionId = inFlowObject.getId();
                try {
                    ThreadedStorer.this.inDeletion.add(flowExpressionId);
                    ThreadedStorer.this.doRemove(inFlowObject);
                    ThreadedStorer.this.inDeletion.remove(flowExpressionId);
                    log.debug((Object)"remove() thread done.");
                }
                catch (Throwable throwable) {
                    log.warn((Object)("remove() failure for " + flowExpressionId), throwable);
                }
            }
        }.start();
        log.debug((Object)"remove() done.");
    }

    public abstract InFlowObject doGet(FlowExpressionId var1);

    public abstract void doStore(InFlowObject var1) throws Exception;

    public abstract void doRemove(InFlowObject var1) throws Exception;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

