/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.participants;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openwfe.org.engine.participants.FilterEntry;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.StringMapAttribute;
import org.apache.log4j.Logger;

public class Filter
implements Serializable {
    static final long serialVersionUID = -1652507046784415271L;
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$participants$Filter == null ? (class$openwfe$org$engine$participants$Filter = Filter.class$("openwfe.org.engine.participants.Filter")) : class$openwfe$org$engine$participants$Filter).getName());
    private static final Filter noFilter = new NoFilter();
    public static final int TYPE_OPEN = 0;
    public static final int TYPE_CLOSED = 1;
    private String name = null;
    private int type = -1;
    private boolean addAllowed = true;
    private boolean removeAllowed = false;
    private List entries = null;
    static /* synthetic */ Class class$openwfe$org$engine$participants$Filter;

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isAddAllowed() {
        return this.addAllowed;
    }

    public boolean isRemoveAllowed() {
        return this.removeAllowed;
    }

    public List getEntries() {
        return this.entries;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setAddAllowed(boolean bl) {
        this.addAllowed = bl;
    }

    public void setRemoveAllowed(boolean bl) {
        this.removeAllowed = bl;
    }

    public void setEntries(List list) {
        this.entries = list;
    }

    private boolean hasPermission(String string, char c) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("hasPermission() fieldName >" + string + "<"));
        }
        return this.getPermissions(string).indexOf(c) > -1;
    }

    private String getPermissions(String string) {
        String string2 = this.getPermissionString(string);
        if (string2 != null) {
            return string2;
        }
        if (this.type == 0) {
            return "rw";
        }
        return "";
    }

    private String getPermissionString(String string) {
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            FilterEntry filterEntry = (FilterEntry)iterator.next();
            if (filterEntry.getFieldRegex() == null || !string.matches(filterEntry.getFieldRegex())) continue;
            return filterEntry.getPermissions().toLowerCase().trim();
        }
        return null;
    }

    private boolean knowsAbout(String string) {
        return this.getPermissions(string) != null;
    }

    public boolean allowWrite(String string) {
        return this.hasPermission(string, 'w');
    }

    public boolean allowRead(String string) {
        return this.hasPermission(string, 'r');
    }

    public boolean allowRemove(String string) {
        if (!this.removeAllowed) {
            return false;
        }
        return this.allowWrite(string);
    }

    public InFlowWorkItem constrain(InFlowWorkItem inFlowWorkItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("constrain() filter '" + this.name + "'"));
        }
        InFlowWorkItem inFlowWorkItem2 = new InFlowWorkItem();
        inFlowWorkItem2.setId(inFlowWorkItem.getId());
        inFlowWorkItem2.setParticipantName(inFlowWorkItem.getParticipantName());
        inFlowWorkItem2.setLastModified(inFlowWorkItem.getLastModified());
        inFlowWorkItem2.setAttributes(new StringMapAttribute(inFlowWorkItem.getAttributes().size()));
        inFlowWorkItem2.setHistory(inFlowWorkItem.getHistory());
        Iterator iterator = inFlowWorkItem.getAttributes().keySet().iterator();
        while (iterator.hasNext()) {
            String string = ((StringAttribute)iterator.next()).toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("constrain() considering attribute named >" + string + "<"));
            }
            if (this.type == 0) {
                if (this.hasPermission(string, 'r') || !"".equals(this.getPermissions(string))) {
                    inFlowWorkItem2.getAttributes().put(string, (Attribute)inFlowWorkItem.getAttribute(string).clone());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("constrain() (open) added attribute >" + string + "<"));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("constrain() (open) discarding attribute >" + string + "<"));
                continue;
            }
            if (this.hasPermission(string, 'r')) {
                inFlowWorkItem2.getAttributes().put(string, (Attribute)inFlowWorkItem.getAttribute(string).clone());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("constrain() (closed) added attribute >" + string + "<"));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("constrain() (closed) discarding attribute >" + string + "<"));
        }
        inFlowWorkItem2.setFilter(this);
        return inFlowWorkItem2;
    }

    public InFlowWorkItem enforce(InFlowWorkItem inFlowWorkItem, InFlowWorkItem inFlowWorkItem2) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)("enforce() filter '" + this.name + "' isAddAllowed ? " + this.addAllowed));
            log.debug((Object)("enforce() filter '" + this.name + "' isRemoveAllowed ? " + this.removeAllowed));
        }
        Iterator iterator = inFlowWorkItem2.getAttributes().keySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            object = ((StringAttribute)iterator.next()).toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("enforce() filter '" + this.name + "' considering att '" + (String)object + "'"));
            }
            boolean bl2 = bl = !inFlowWorkItem.containsAttribute((String)object);
            if (log.isDebugEnabled()) {
                log.debug((Object)("enforce() filter '" + this.name + "' isNewAttribute '" + bl + "'"));
            }
            if (bl && this.isAddAllowed()) {
                inFlowWorkItem.getAttributes().put((String)object, inFlowWorkItem2.getAttribute((String)object));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("enforce() Added new attribute '" + (String)object + "'"));
                continue;
            }
            if (bl) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("enforce() Dropped new attribute '" + (String)object + "'"));
                continue;
            }
            if (((Object)inFlowWorkItem2.getAttribute((String)object)).equals(inFlowWorkItem.getAttribute((String)object))) {
                log.debug((Object)"enforce() Same value");
                continue;
            }
            if (!this.allowRead((String)object)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("enforce() Discarding modification on hidden attribute '" + (String)object + "'"));
                continue;
            }
            if (!this.allowWrite((String)object)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("enforce() Discarding modification on attribute '" + (String)object + "'"));
                continue;
            }
            inFlowWorkItem.getAttributes().put((String)object, inFlowWorkItem2.getAttribute((String)object));
        }
        log.debug((Object)"enforce() checking removal of attributes (is it allowed ?)");
        if (this.removeAllowed) {
            log.debug((Object)"enforce() checking removal of attributes (it is allowed)");
            object = new ArrayList(inFlowWorkItem.getAttributes().size());
            iterator = inFlowWorkItem.getAttributes().keySet().iterator();
            while (iterator.hasNext()) {
                String string = ((StringAttribute)iterator.next()).toString();
                if (inFlowWorkItem2.containsAttribute(string) || !this.allowWrite(string)) continue;
                object.add(string);
                log.debug((Object)("enforce() removing field '" + string + "'"));
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                inFlowWorkItem.removeAttribute((String)iterator.next());
            }
        }
        return inFlowWorkItem;
    }

    public static Filter getNoFilter() {
        return noFilter;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class NoFilter
    extends Filter {
        public NoFilter() {
            this.setName(this.getClass().getName());
            this.setType(0);
            this.setAddAllowed(true);
            this.setRemoveAllowed(true);
            this.setEntries(new ArrayList(0));
        }
    }
}

