/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.Service;
import openwfe.org.engine.expool.ExpressionStore;
import openwfe.org.engine.expressions.CompositeFlowExpression;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.OneChildExpression;
import openwfe.org.engine.expressions.ParticipantExpression;
import openwfe.org.engine.expressions.state.ExpressionState;
import openwfe.org.engine.impl.expool.SimpleExpressionPool;
import openwfe.org.engine.impl.expool.XmlExpressionStore;
import openwfe.org.time.Time;

public class PoolGrapher {
    private static ApplicationContext applicationContext = new ApplicationContext();
    private static Map pool = new HashMap();
    private static boolean printOwfeVersion = false;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$XmlExpressionStore;
    static /* synthetic */ Class class$openwfe$org$engine$tools$PoolGrapher;

    private static ExpressionStore getExpressionStore(String string, Map map) throws Exception {
        Class<?> clazz = Class.forName(string);
        ExpressionStore expressionStore = (ExpressionStore)clazz.newInstance();
        if (clazz.equals(class$openwfe$org$engine$impl$expool$XmlExpressionStore == null ? (class$openwfe$org$engine$impl$expool$XmlExpressionStore = PoolGrapher.class$("openwfe.org.engine.impl.expool.XmlExpressionStore")) : class$openwfe$org$engine$impl$expool$XmlExpressionStore) && map.size() < 1) {
            map.put(XmlExpressionStore.P_WORK_DIRECTORY, "./work/engine/pool");
        }
        ((Service)expressionStore).init("expressionStore", applicationContext, map);
        return expressionStore;
    }

    private static void printUsage(String string) {
        System.out.println();
        System.out.println("Usage :");
        System.out.println();
        System.out.println("   " + string + " [-s storeClassName] {-paramName paramValue}* {wfid}*");
        System.out.println();
        System.out.println("   will print out a list of the expression in the pool an how they are linked");
        System.out.println();
        System.out.println("      -s storeClassName");
        System.out.println("           sets the store class to use (by default, it's XmlExpressionStore");
        System.out.println("      -V");
        System.out.println("           prints the OpenWFE version for each expression");
        System.out.println("      -paramName paramValue");
        System.out.println("           passes parameters to the store");
        System.out.println();
        System.out.println("      -h");
        System.out.println("           prints this usage and exits");
        System.out.println();
        System.out.println("   (1.7.1pre10)");
        System.out.println();
        System.exit(-1);
    }

    private static void putExpression(String string, FlowExpression flowExpression) {
        Long l = new Long(flowExpression.getId().getParentWorkflowInstanceId());
        String string2 = "" + l;
        if (string != null && string.indexOf(string2) < 0) {
            return;
        }
        HashMap<FlowExpressionId, FlowExpression> hashMap = (HashMap<FlowExpressionId, FlowExpression>)pool.get(l);
        if (hashMap == null) {
            hashMap = new HashMap<FlowExpressionId, FlowExpression>();
            pool.put(l, hashMap);
        }
        hashMap.put(flowExpression.getId(), flowExpression);
    }

    private static void renderPool() {
        System.out.println("digraph OpenWFE_expression_pool {");
        System.out.println("    rankdir=LR;");
        System.out.println("    node [shape = ellipse, color = gray85 ];");
        Iterator iterator = pool.keySet().iterator();
        while (iterator.hasNext()) {
            Map map = (Map)pool.get(iterator.next());
            PoolGrapher.renderFlowInstance(map);
        }
        System.out.println("}");
    }

    private static void renderFlowInstance(Map map) {
        String string;
        Cloneable cloneable;
        HashMap<String, Cloneable> hashMap = new HashMap<String, Cloneable>();
        Iterator<Object> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            cloneable = (FlowExpressionId)iterator.next();
            string = ((FlowExpressionId)cloneable).getWorkflowInstanceId() + "_" + ((FlowExpressionId)cloneable).getExpressionId();
            hashMap.put(string, cloneable);
        }
        cloneable = new ArrayList(hashMap.keySet());
        Collections.sort(cloneable);
        iterator = cloneable.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            FlowExpressionId flowExpressionId = (FlowExpressionId)hashMap.get(string);
            PoolGrapher.renderExpression((FlowExpression)map.get(flowExpressionId));
        }
    }

    private static String id(FlowExpressionId flowExpressionId) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(flowExpressionId.getWorkflowInstanceId()).append("_").append(flowExpressionId.getExpressionName()).append("_").append(flowExpressionId.getExpressionId());
        stringBuffer.append("\\n");
        stringBuffer.append(flowExpressionId.getWorkflowDefinitionName()).append(" ").append(flowExpressionId.getWorkflowDefinitionRevision());
        if (printOwfeVersion) {
            stringBuffer.append(" (").append(flowExpressionId.getOwfeVersion()).append(")");
        }
        return stringBuffer.toString();
    }

    private static void printLink(FlowExpressionId flowExpressionId, FlowExpressionId flowExpressionId2, String string) {
        if (flowExpressionId == null || flowExpressionId2 == null) {
            return;
        }
        System.out.print("    ");
        System.out.print("\"");
        System.out.print(PoolGrapher.id(flowExpressionId));
        System.out.print("\"");
        System.out.print(" -> ");
        System.out.print("\"");
        System.out.print(PoolGrapher.id(flowExpressionId2));
        System.out.print("\"");
        if (string.equals("env")) {
            System.out.print(" [ constraint = false ];");
        } else {
            System.out.print(" [ label = \"" + string + "\" ];");
        }
        System.out.println();
    }

    private static void printLabel(FlowExpression flowExpression) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PoolGrapher.id(flowExpression.getId()));
        stringBuffer.append("\\n").append(flowExpression.getClass().getName());
        ArrayList arrayList = new ArrayList(flowExpression.getAttributes().keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = (String)flowExpression.getAttributes().get(string);
            stringBuffer.append("\\n").append(string).append(" = ").append("'").append((String)object).append("'");
        }
        boolean bl = false;
        if (flowExpression instanceof ParticipantExpression && ((ParticipantExpression)(object = (ParticipantExpression)flowExpression)).getAppliedWorkitem() != null) {
            bl = true;
            stringBuffer.append("\\n").append("*applied*");
        }
        if (flowExpression.getState() != null) {
            object = Time.toIsoDate((long)flowExpression.getState().getSince());
            stringBuffer.append("\\n").append(flowExpression.getState().getName()).append(" since ").append((String)object);
        }
        System.out.print("    ");
        System.out.print("\"");
        System.out.print(PoolGrapher.id(flowExpression.getId()));
        System.out.print("\"");
        System.out.print(" [ label = \"" + stringBuffer.toString() + "\"");
        if (flowExpression instanceof Environment) {
            System.out.print(" shape = rect ");
        }
        if (bl) {
            System.out.print(" color = red ");
        } else {
            System.out.print(" color = black ");
        }
        System.out.print("];");
        System.out.println();
    }

    private static void renderExpression(FlowExpression flowExpression) {
        ExpressionState expressionState = SimpleExpressionPool.getState(flowExpression);
        String string = Time.toIsoDate((long)expressionState.getSince());
        FlowExpressionId flowExpressionId = flowExpression.getId();
        PoolGrapher.printLabel(flowExpression);
        PoolGrapher.printLink(flowExpressionId, flowExpression.getParent(), "parent");
        if (Environment.ownsEnvironment(flowExpression)) {
            PoolGrapher.printLink(flowExpressionId, flowExpression.getEnvironmentId(), "env");
        }
        if (flowExpression instanceof CompositeFlowExpression) {
            Iterator iterator = ((CompositeFlowExpression)((Object)flowExpression)).getChildren().iterator();
            while (iterator.hasNext()) {
                FlowExpressionId flowExpressionId2 = (FlowExpressionId)iterator.next();
                PoolGrapher.printLink(flowExpressionId, flowExpressionId2, "child");
            }
        } else if (flowExpression instanceof OneChildExpression) {
            FlowExpressionId flowExpressionId3 = ((OneChildExpression)flowExpression).getChildExpressionId();
            PoolGrapher.printLink(flowExpressionId, flowExpressionId3, "child");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2 = "java " + (class$openwfe$org$engine$tools$PoolGrapher == null ? (class$openwfe$org$engine$tools$PoolGrapher = PoolGrapher.class$("openwfe.org.engine.tools.PoolGrapher")) : class$openwfe$org$engine$tools$PoolGrapher).getName();
        int n = 0;
        if (stringArray.length < 1) {
            PoolGrapher.printUsage(string2);
        }
        if (!stringArray[0].startsWith("-")) {
            string2 = stringArray[0];
            n = 1;
        }
        String string3 = (class$openwfe$org$engine$impl$expool$XmlExpressionStore == null ? (class$openwfe$org$engine$impl$expool$XmlExpressionStore = PoolGrapher.class$("openwfe.org.engine.impl.expool.XmlExpressionStore")) : class$openwfe$org$engine$impl$expool$XmlExpressionStore).getName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            string = stringArray[n];
            if (string.equals("-h")) {
                PoolGrapher.printUsage(string2);
            }
            if (string.equals("-s")) {
                string3 = stringArray[n + 1];
            } else if (string.equals("-V")) {
                printOwfeVersion = true;
            } else {
                hashMap.put(stringArray[n].substring(1), stringArray[n + 1]);
            }
            n += 2;
        }
        string = null;
        while (n < stringArray.length) {
            if (string == null) {
                string = "";
            }
            string = string + stringArray[n];
            string = string + " ";
            ++n;
        }
        applicationContext.setApplicationName("tool:" + (class$openwfe$org$engine$tools$PoolGrapher == null ? (class$openwfe$org$engine$tools$PoolGrapher = PoolGrapher.class$("openwfe.org.engine.tools.PoolGrapher")) : class$openwfe$org$engine$tools$PoolGrapher).getName());
        ExpressionStore expressionStore = PoolGrapher.getExpressionStore(string3, hashMap);
        Iterator iterator = expressionStore.contentIterator(null);
        while (iterator.hasNext()) {
            FlowExpression flowExpression = (FlowExpression)iterator.next();
            PoolGrapher.putExpression(string, flowExpression);
        }
        PoolGrapher.renderPool();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

