/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openwfe.org.Utils;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.time.Time;

public class HistoryItem
implements Serializable,
Cloneable {
    static final long serialVersionUID = -6342388322728713196L;
    public String date = null;
    public String author = null;
    public String host = null;
    public String text = null;
    public String wfdName = "";
    public String wfdRevision = "";
    public String wfInstanceId = null;
    public String expressionId = null;

    public HistoryItem() {
    }

    public HistoryItem(FlowExpressionId flowExpressionId) {
        this.date = Time.toIsoDate();
        this.wfdName = flowExpressionId.getWorkflowDefinitionName();
        this.wfdRevision = flowExpressionId.getWorkflowDefinitionRevision();
        this.wfInstanceId = flowExpressionId.getWorkflowInstanceId();
        this.expressionId = flowExpressionId.getExpressionId();
    }

    public String getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getHost() {
        return this.host;
    }

    public String getText() {
        return this.text;
    }

    public String getWorkflowDefinitionName() {
        return this.wfdName;
    }

    public String getWorkflowDefinitionRevision() {
        return this.wfdRevision;
    }

    public String getWorkflowInstanceId() {
        return this.wfInstanceId;
    }

    public String getExpressionId() {
        return this.expressionId;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setWorkflowDefinitionName(String string) {
        this.wfdName = string;
    }

    public void setWorkflowDefinitionRevision(String string) {
        this.wfdRevision = string;
    }

    public void setWorkflowInstanceId(String string) {
        this.wfInstanceId = string;
    }

    public void setExpressionId(String string) {
        this.expressionId = string;
    }

    public Object clone() {
        HistoryItem historyItem = new HistoryItem();
        historyItem.date = Utils.copyString((String)this.date);
        historyItem.author = Utils.copyString((String)this.author);
        historyItem.host = Utils.copyString((String)this.host);
        historyItem.text = Utils.copyString((String)this.text);
        historyItem.wfdName = Utils.copyString((String)this.wfdName);
        historyItem.wfdRevision = Utils.copyString((String)this.wfdRevision);
        historyItem.wfInstanceId = Utils.copyString((String)this.wfInstanceId);
        historyItem.expressionId = Utils.copyString((String)this.expressionId);
        return historyItem;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(").append(this.getClass().getName()).append(" ").append(" date=\"").append(this.date).append("\"").append(" author=\"").append(this.author).append("\"").append(" host=\"").append(this.host).append("\"").append(" text=\"").append(this.text).append("\"").append(" wfdName=\"").append(this.wfdName).append("\"").append(" wfdRevision=\"").append(this.wfdRevision).append("\"").append(" wfInstanceId=\"").append(this.wfInstanceId).append("\"").append(" expressionId=\"").append(this.expressionId).append("\"").append(")");
        return stringBuffer.toString();
    }

    public static List copyHistoryList(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HistoryItem historyItem = (HistoryItem)iterator.next();
            arrayList.add(historyItem.clone());
        }
        return arrayList;
    }
}

