/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import openwfe.org.Utils;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.participants.Filter;
import openwfe.org.engine.workitem.HistoryItem;
import openwfe.org.engine.workitem.InFlowItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.time.Time;

public class InFlowWorkItem
extends InFlowItem {
    static final long serialVersionUID = 4549009226611843819L;
    private String dispatchTime = null;
    private Filter filter = null;
    private List history = null;

    public InFlowWorkItem() {
    }

    public InFlowWorkItem(LaunchItem launchItem) {
        this.setAttributes(launchItem.getAttributes());
        this.setHistory(new ArrayList(0));
    }

    public InFlowWorkItem(StringMapAttribute stringMapAttribute) {
        this.setAttributes(stringMapAttribute);
        this.setHistory(new ArrayList(0));
    }

    public String getDispatchTime() {
        return this.dispatchTime;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public List getHistory() {
        return this.history;
    }

    public void setDispatchTime(String string) {
        this.dispatchTime = string;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setHistory(List list) {
        this.history = list;
    }

    public FlowExpressionId getLastExpressionId() {
        return this.getId();
    }

    public void addHistoryItem(String string, String string2) {
        this.addHistoryItem(null, string, string2);
    }

    public void addHistoryItem(FlowExpressionId flowExpressionId, String string, String string2) {
        HistoryItem historyItem = new HistoryItem();
        historyItem.setAuthor(string);
        historyItem.setDate(Time.toIsoDate());
        historyItem.setText(string2);
        if (flowExpressionId == null) {
            flowExpressionId = this.getLastExpressionId();
        }
        if (flowExpressionId != null) {
            historyItem.setWorkflowDefinitionName(flowExpressionId.getWorkflowDefinitionName());
            historyItem.setWorkflowDefinitionRevision(flowExpressionId.getWorkflowDefinitionRevision());
            historyItem.setWorkflowInstanceId(flowExpressionId.getWorkflowInstanceId());
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            historyItem.setHost(inetAddress.getHostName() + " / " + inetAddress.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            historyItem.setHost("" + unknownHostException);
        }
        if (this.history == null) {
            this.history = new ArrayList(1);
        }
        this.history.add(historyItem);
    }

    public Object clone() {
        InFlowWorkItem inFlowWorkItem = new InFlowWorkItem();
        inFlowWorkItem.setAttributes((StringMapAttribute)this.getAttributes().clone());
        if (this.getId() != null) {
            inFlowWorkItem.setId(this.getId().copy());
        }
        inFlowWorkItem.setParticipantName(Utils.copyString((String)this.getParticipantName()));
        inFlowWorkItem.setDispatchTime(Utils.copyString((String)this.getDispatchTime()));
        inFlowWorkItem.setLastModified(Time.toIsoDate());
        inFlowWorkItem.setFilter(this.getFilter());
        inFlowWorkItem.setHistory(HistoryItem.copyHistoryList(this.history));
        return inFlowWorkItem;
    }
}

