/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import java.io.Serializable;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeException;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.time.Time;

public abstract class WorkItem
implements Cloneable,
Serializable {
    static final long serialVersionUID = -7773035923790384871L;
    private String lastModified = null;
    private StringMapAttribute attributes = new StringMapAttribute();

    public String getLastModified() {
        return this.lastModified;
    }

    public StringMapAttribute getAttributes() {
        return this.attributes;
    }

    public void setLastModified(String string) {
        this.lastModified = string;
    }

    public void setAttributes(StringMapAttribute stringMapAttribute) {
        this.attributes = stringMapAttribute;
    }

    public Attribute getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public void setAttribute(String string, Attribute attribute) throws AttributeException {
        if (this.attributes == null) {
            this.attributes = new StringMapAttribute(1);
        }
        if (!this.attributes.stringKeySet().contains(string)) {
            throw new AttributeException("WorkItem doesn't contain any attribute named '" + string + "'");
        }
        this.attributes.put(string, attribute);
        this.touch();
    }

    public void addAttribute(String string, Attribute attribute) throws AttributeException {
        if (this.attributes == null) {
            this.attributes = new StringMapAttribute(1);
        }
        if (this.attributes.stringKeySet().contains(string)) {
            throw new AttributeException("WorkItem already contains an attribute named '" + string + "'");
        }
        this.attributes.put(string, attribute);
        this.touch();
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
        this.touch();
    }

    public boolean containsAttribute(String string) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.stringKeySet().contains(string);
    }

    public void touch() {
        this.lastModified = Time.toIsoDate();
    }
}

