/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.Parameters;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.WorkItemCoderLoader;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class XmlCoderLoader
extends AbstractService
implements WorkItemCoderLoader {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$workitem$XmlCoderLoader == null ? (class$openwfe$org$engine$workitem$XmlCoderLoader = XmlCoderLoader.class$("openwfe.org.engine.workitem.XmlCoderLoader")) : class$openwfe$org$engine$workitem$XmlCoderLoader).getName());
    protected static final String DEFAULT = "__default__";
    protected static final String XML = "__xml__";
    private Map map = null;
    static /* synthetic */ Class class$openwfe$org$engine$workitem$XmlCoderLoader;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        Object v = map.get("configurationFile");
        if (v == null) {
            throw new ServiceException("parameter configurationFile' is mandatory for service " + this.getName() + " (" + this.getClass().getName() + ")");
        }
        log.debug((Object)("init() oConf is instance of " + v.getClass().getName()));
        Object var5_5 = null;
        if (v instanceof List) {
            Iterator iterator = ((List)v).iterator();
            while (iterator.hasNext()) {
                this.loadConfigurationFile((String)iterator.next());
            }
        } else {
            this.loadConfigurationFile((String)v);
        }
    }

    public WorkItemCoder getDefaultCoder() {
        return (WorkItemCoder)this.map.get(DEFAULT);
    }

    public WorkItemCoder getXmlCoder() {
        return (WorkItemCoder)this.map.get(XML);
    }

    public WorkItemCoder getCoder(String string) {
        return (WorkItemCoder)this.map.get(string);
    }

    protected void loadConfigurationFile(String string) throws ServiceException {
        if (this.map == null) {
            this.map = new HashMap();
        }
        try {
            log.info((Object)("loadConfigurationFile() raw  " + string));
            String string2 = Utils.expandUrl((String)string);
            log.info((Object)("loadConfigurationFile()      " + string2));
            Element element = XmlUtils.extractXml((String)string2, (boolean)false);
            Iterator iterator = element.getChildren("workitem-coder").iterator();
            while (iterator.hasNext()) {
                this.buildCoderConfiguration((Element)iterator.next());
            }
        }
        catch (ServiceException serviceException) {
            throw serviceException;
        }
        catch (Exception exception) {
            throw new ServiceException("Failed to build AttributeCoder list from file '" + string + "'", (Throwable)exception);
        }
    }

    protected void buildCoderConfiguration(Element element) throws ServiceException {
        AttributeCoder attributeCoder;
        Serializable serializable;
        String string = element.getAttributeValue("name");
        String string2 = element.getAttributeValue("class");
        String string3 = element.getAttributeValue("default");
        if (string == null || string2 == null) {
            throw new ServiceException("Attribute 'name' or 'class' is missing from WorkItemCoder configuration file");
        }
        log.info((Object)("building coder '" + string + "'"));
        WorkItemCoder workItemCoder = null;
        try {
            serializable = Class.forName(string2);
            workItemCoder = (WorkItemCoder)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            throw new ServiceException("Failed to instantiate coder '" + string + "' with class '" + string2 + "'", (Throwable)exception);
        }
        log.debug((Object)"buildCoderConfiguration() workItemCoder instantiated");
        serializable = new ArrayList();
        Iterator iterator = element.getChildren("attribute-coder").iterator();
        while (iterator.hasNext()) {
            attributeCoder = this.buildAttributeCoder(workItemCoder, (Element)iterator.next());
            serializable.add((AttributeCoder)attributeCoder);
        }
        log.debug((Object)"buildCoderConfiguration() attributeList filled");
        attributeCoder = element.getChild("reply-coder");
        if (attributeCoder == null) {
            throw new ServiceException("Element 'replyCoder' is mandatory in coder configuration. It is missing for coder '" + string + "'");
        }
        String string4 = attributeCoder.getAttributeValue("class");
        ListenerReplyCoder listenerReplyCoder = null;
        try {
            Class<?> clazz = Class.forName(string4);
            listenerReplyCoder = (ListenerReplyCoder)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ServiceException("Failed to instantiate coder '" + string + "' listenerReplyCoder with class '" + string4 + "'", (Throwable)exception);
        }
        log.debug((Object)"buildCoderConfiguration() replyCoder instantiated");
        workItemCoder.init(string, (List)((Object)serializable), listenerReplyCoder);
        log.debug((Object)"buildCoderConfiguration() workItemCoder initialized");
        this.map.put(string, workItemCoder);
        log.info((Object)("Built workItemCoder '" + string + "'"));
        if (string3 != null && string3.trim().toLowerCase().equals("true")) {
            log.info((Object)("Setting workItemCoder '" + string + "' as default"));
            this.map.put(DEFAULT, workItemCoder);
        }
        if (workItemCoder instanceof XmlWorkItemCoder) {
            log.info((Object)("Setting workItemCoder '" + string + "' as xmlCoder"));
            this.map.put(XML, workItemCoder);
        }
    }

    protected AttributeCoder buildAttributeCoder(WorkItemCoder workItemCoder, Element element) throws ServiceException {
        String string = element.getAttributeValue("class");
        if (string == null) {
            throw new ServiceException("Attribute 'coderClass' is missing from AttributeCoder configuration");
        }
        log.debug((Object)("buildAttributeCoder() coderClassName is " + string));
        AttributeCoder attributeCoder = null;
        try {
            Class<?> clazz = Class.forName(string);
            attributeCoder = (AttributeCoder)clazz.newInstance();
            Map map = Parameters.extractAttributes((Element)element);
            attributeCoder.init(workItemCoder, map);
        }
        catch (Exception exception) {
            throw new ServiceException("Failed to instantiate AttributeCoder for class '" + string + "'", (Throwable)exception);
        }
        return attributeCoder;
    }

    public static XmlCoderLoader buildCoderLoader(String string) throws ServiceException {
        XmlCoderLoader xmlCoderLoader = new XmlCoderLoader();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("configurationFile", string);
        xmlCoderLoader.init("coderLoader", new ApplicationContext(), hashMap);
        return xmlCoderLoader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

