/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Definitions.java 2852 2006-06-22 07:04:12Z jmettraux $
 */

//
// Definitions.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expool.ExpressionStore;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.history.History;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.WorkItemCoderLoader;
import openwfe.org.engine.functions.FunctionMap;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.expressions.map.ExpressionMap;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;


/**
 * Constants for the whole workflow engine
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-22 09:04:12 +0200 (Thu, 22 Jun 2006) $
 * <br>$Id: Definitions.java 2852 2006-06-22 07:04:12Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class Definitions
{

    public final static String OPENWFE_VERSION = "1.7.1pre7";


    /*
    public static final String DEFAULT_EXPRESSION_TIMEOUT
        = "defaultExpressionTimeout";
    */

    //
    // general engine parameters

    public static final String ENGINE_ID
        = "engineId";

    //
    // parameters

    public static final String WORKFLOW_DEFINITION_URL
        = "wfdUrl";

    /*
    public static final String WAIT_FOR_RESULT
        = "waitForResult";
    */

    //
    // some variables

    public static final String V_TIMED_OUT
        = "__timed_out__";

    //
    // service names

    /**
     * An OpenWFE component expects an ExpressionMap to be found under
     * 'expressionMap' in its ApplicationContext.
     */
    public final static String S_EXPRESSION_MAP 
        = "expressionMap";

    /**
     * The expression pool service should be located under 
     * the name 'expressionPool'.
     */
    public final static String S_EXPRESSION_POOL
        = "expressionPool";

    /**
     * The engine's expression store service should be located under
     * 'expressionStore'.
     */
    public final static String S_EXPRESSION_STORE
        = "expressionStore";

    /**
     * An OpenWFE component expects a ParticipantMap to be found under
     * 'participantMap' in its ApplicationContext.
     */
    public final static String S_PARTICIPANT_MAP 
        = "participantMap";

    /**
     * An OpenWFE component expects a WorkflowInstanceBuilder to be found under
     * 'workflowInstanceBuilder' in its ApplicationContext.
     */
    public final static String S_WORKFLOW_INSTANCE_BUILDER
        = "workflowInstanceBuilder";

    /**
     * A 'launcher' is a service that turns a workflow definition into a 
     * workflow instance.
     */
    public final static String S_LAUNCHER
        = "launcher";

    /**
     * The set of services that constitute an OpenWFE engine awaits the
     * function map service to be named 'functionMap'.
     */
    public final static String S_FUNCTION_MAP
        = "functionMap";

    /**
     * The workitem coder loader service can be located with the name
     * 'workItemCoderLoader'.
     */
    public final static String S_WORKITEM_CODER_LOADER
        = "workItemCoderLoader";

    /**
     * The service named 'history'.
     */
    public final static String S_HISTORY
        = "history";

    /**
     * 'processLibrary' is a service for loading predefined subprocesses
     * at engine-level.
     */
    public final static String S_PROCESS_LIBRARY
        = "processLibrary";

    /* *
     * 'cron' is the cron service for the engine.
     * /
    public final static String S_CRON
        = "cron";
     */

    //
    // engine services' get methods

    public static WorkItemCoderLoader getWorkItemCoderLoader 
        (final ApplicationContext context)
    {
        return (WorkItemCoderLoader)context.lookup(S_WORKITEM_CODER_LOADER);
    }

    /**
     * A shortcut method for directly returning the XML workitem coder
     * (no need to ask it to the workitem coder loader).
     */
    public static XmlWorkItemCoder getXmlCoder
        (final ApplicationContext context)
    {
        return (XmlWorkItemCoder)getWorkItemCoderLoader(context).getXmlCoder();
    }

    /**
     * Returns a ref to the expression pool as found in the application
     * context.
     */
    public static ExpressionPool getExpressionPool 
        (final ApplicationContext context)
    {
        return (ExpressionPool)context.lookup(S_EXPRESSION_POOL);
    }

    public static History getHistory 
        (final ApplicationContext context)
    {
        return (History)context.lookup(S_HISTORY);
    }

    public static ExpressionStore getExpressionStore 
        (final ApplicationContext context)
    {
        return (ExpressionStore)context.lookup(S_EXPRESSION_STORE);
    }

    public static Launcher getLauncher
        (final ApplicationContext context)
    {
        return (Launcher)context.lookup(S_LAUNCHER);
    }

    public static ParticipantMap getParticipantMap 
        (final ApplicationContext context)
    {
        return (ParticipantMap)context.lookup(S_PARTICIPANT_MAP);
    }

    public static ExpressionMap getExpressionMap 
        (final ApplicationContext context)
    {
        return (ExpressionMap)context.lookup(S_EXPRESSION_MAP);
    }

    public static FunctionMap getFunctionMap
        (final ApplicationContext context)
    {
        return (FunctionMap)context.lookup(S_FUNCTION_MAP);
    }

    /**
     * A small trick calling this main method will output the OpenWFE
     * version on the stdout.
     */
    public static void main (final String[] args)
    {
        System.out.print(OPENWFE_VERSION);
    }

}
