//
// TestCase.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine._test;

import junit.framework.Assert;

import openwfe.org.ServiceException;
import openwfe.org.OpenWfeException;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.impl.listen.SocketListener;
import openwfe.org.engine.impl.dispatch.SocketDispatcher;
import openwfe.org.engine.listen.AbstractWorkItemConsumer;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.dispatch.FatalDispatchingException;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.XmlCoderLoader;


/**
 * The test cases for the package
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-05-17 18:41:07 +0200 (Tue, 17 May 2005) $
 * <br>$Id: DispatchCase.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class DispatchCase

    extends junit.framework.TestCase

{

    private final static org.apache.log4j.Logger log =
        org.apache.log4j.Logger.getLogger("test.dispatch");

    //
    // FIELDS

    private ApplicationContext context = null;

    //
    // CONSTRUCTORS

    public DispatchCase (String name)
    {
        super(name);
        this.setUpOnce();
    }

    //
    // METHODS

    //public void setUp ()
    public void setUpOnce ()
    {
        log.info("------------------- setting up ------------------- ");
        try
        {
            //
            // set up applicationContext
            
            this.context = new ApplicationContext();

            //
            // set up the coder loader

            java.util.Map loaderParams = new java.util.HashMap();
            loaderParams.put
                (XmlCoderLoader.CONFIGURATION_FILE, 
                 "../releases/openwfe/etc-engine/coder-configuration.xml");

            XmlCoderLoader loader = new XmlCoderLoader();
            loader.init
                ("workItemCoderLoader", 
                 this.context,
                 loaderParams);
            this.context.put("workItemCoderLoader", loader);

            //
            // set up consumer
            
            AbstractWorkItemConsumer consumer = new AbstractWorkItemConsumer ()
            {
                public void check (WorkItem wi)
                    throws OpenWfeException
                {
                    // wi is ok !
                    // don't throw any exception
                }

                public Object use (WorkItem wi)
                    throws OpenWfeException
                {
                    //verify(wi);

                    //
                    // dont' do anything with the wi, it's ok

                    return null;
                }
            };
            java.util.Map consumerParams = new java.util.HashMap();
            consumer.init("consumer", context, consumerParams);

            context.put("consumer", consumer);

            //
            // set up listener

            SocketListener listener = new SocketListener();
            java.util.Map listenerParams = new java.util.HashMap();
            listenerParams.put("workItemConsumer", "consumer");
            listener.init("listener", context, listenerParams);

            context.put("listener", listener);

            //
            // set up dispatcher

            SocketDispatcher dispatcher = new SocketDispatcher();
            java.util.Map dispatcherParams = new java.util.HashMap();
            dispatcherParams.put("retryCount", "2");
            dispatcherParams.put("retryFrequency", "10");
            dispatcher.init("dispatcher", context, dispatcherParams);

            context.put("dispatcher", dispatcher);
        }
        catch (ServiceException se)
        {
            se.printStackTrace();
        }
    }

    /*
    public void tearDown ()
    {
        //
        // just stop the listener

        try
        {
            SocketListener listener = 
                (SocketListener)this.context.lookup("listener");
            listener.stop();
        }
        catch (Exception e)
        {
            // ignore
        }
    }
    */

    //
    // TEST METHODS

    public void testSuccessfulDispatch ()
    {
        log.info("================ testSuccessfulDispatch() ================"); 
        try
        {
            SocketDispatcher dispatcher = 
                (SocketDispatcher)this.context.lookup("dispatcher");

            //
            // prepare workitem

            InFlowWorkItem wi = new InFlowWorkItem();

            //
            // dispatch workitem

            dispatcher.dispatch(wi);

            Assert.assertTrue(true);
        }
        catch (Exception e)
        {
            e.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    public void testNoListener ()
    {
        log.info("================ testNoListener () ================"); 
        try
        {
            //
            // remove listener

            SocketListener listener = 
                (SocketListener)this.context.lookup("listener");
            listener.stop();

            //
            // prepare to dispatch

            SocketDispatcher dispatcher = 
                (SocketDispatcher)this.context.lookup("dispatcher");

            //
            // prepare workitem

            InFlowWorkItem wi = new InFlowWorkItem();

            //
            // dispatch workitem

            dispatcher.dispatch(wi);
        }
        catch (FatalDispatchingException fde)
        {
            log.info("Fatal", fde);
            Assert.assertTrue(false);
        }
        catch (DispatchingException de)
        {
            log.info("Regular", de);
            Assert.assertTrue(true);
        }
        catch (Exception e)
        {
            e.printStackTrace();
            Assert.assertTrue(false);
        }
    }

    public void testNoConsumer ()
    {
        log.info("================ testNoConsumer () ================"); 
        try
        {
            //
            // remove consumer

            this.context.put("consumer", null);

            //
            // prepare to dispatch

            SocketDispatcher dispatcher = 
                (SocketDispatcher)this.context.lookup("dispatcher");

            //
            // prepare workitem

            InFlowWorkItem wi = new InFlowWorkItem();

            //
            // dispatch workitem

            dispatcher.dispatch(wi);
        }
        catch (FatalDispatchingException fde)
        {
            log.info("Fatal", fde);
            Assert.assertTrue(true);
        }
        catch (DispatchingException de)
        {
            log.info("Regular", de);
            Assert.assertTrue(false);
        }
        catch (Exception e)
        {
            e.printStackTrace();
            Assert.assertTrue(false);
        }
    }

}
