/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ControlSessionImpl.java 2429 2006-03-14 21:01:24Z jmettraux $
 */

//
// ControlSessionImpl.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.control.local;

import java.rmi.RemoteException;
import javax.security.auth.Subject;

import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.control.ControlException;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * A local control session
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ControlSessionImpl.java 2429 2006-03-14 21:01:24Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ControlSessionImpl

    extends AbstractService

    implements ControlSession

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ControlSessionImpl.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    public void init
        (final String serviceName,
         final ApplicationContext applicationContext,
         final java.util.Map serviceParams)
    throws
        ServiceException
    {
        super.init(serviceName, applicationContext, serviceParams);
    }

    //
    // METHODS from ControlSession

    public java.util.List listExpressions ()
        throws RemoteException
    {
        return getExpressionPool().listExpressions();
    }

    public void unfreezeExpression (final FlowExpressionId fei)
        throws ControlException, RemoteException
    {
        try
        {
            getExpressionPool().unfreezeExpression(fei);
        }
        catch (final PoolException pe)
        {
            throw new ControlException("pool problem", pe);
        }
    }

    public void cancelExpression (final FlowExpressionId fei)
        throws ControlException, RemoteException
    {
        getExpressionPool().cancel(fei);
    }

    public void freezeFlow (final String workflowInstanceId)
        throws ControlException, RemoteException
    {
        try
        {
            getExpressionPool().freezeFlow(workflowInstanceId);
        }
        catch (final PoolException pe)
        {
            throw new ControlException("pool problem", pe);
        }
    }

    public void freezeExpression (final FlowExpressionId fei)
        throws ControlException, RemoteException
    {
        try
        {
            getExpressionPool().freezeExpression(fei);
        }
        catch (final PoolException pe)
        {
            throw new ControlException("pool problem", pe);
        }
    }

    //
    // METHODS from WorkSession

    public void release ()
        throws RemoteException
    {
        // nothing to do for the moment
    }

    //
    // METHODS

    public ExpressionPool getExpressionPool ()
    {
        return Definitions.getExpressionPool(this.getContext());
    }

    //
    // STATIC METHODS

}
