/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: CaseExpression.java 2667 2006-05-24 22:33:06Z jmettraux $
 */

//
// CaseExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.map.ExpressionMap;


/**
 * The cond expression is almost exactly the translation of the Scheme 'cond'.
 * It's a kind of multi-if.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-05-25 00:33:06 +0200 (Thu, 25 May 2006) $
 * <br>$Id: CaseExpression.java 2667 2006-05-24 22:33:06Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class CaseExpression

    extends IfExpression

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(CaseExpression.class.getName());
    */

    //
    // FIELDS

    private int currentId = -1;

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    /**
     * The 'currentId' field is used to keep track of the point at which the
     * case expression is in the evaluation of its children.
     */
    public int getCurrentId () { return this.currentId; }

    public void setCurrentId (final int i) { this.currentId = i; }

    //
    // METHODS

    public void apply (final InFlowWorkItem wi) 
        throws ApplyException
    {
        //log.debug("apply()");

        if (getChildren() == null || getChildren().size() < 1)
        {
            applyToParent(wi);
            return;
        }

        setCurrentId(0);

        this.storeItself();

        getExpressionPool().apply
            ((FlowExpressionId)getChildren().get(getCurrentId()), wi);
    }

    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        //log.debug("reply()");

        if (isConditionTreated())
        {
            //log.debug("reply() case solved.");

            //ValueUtils.cleanBooleanResult(wi);

            replyToParent(wi);
            return;
        }

        //log.debug
        //    ("reply()"+
        //     " expressionId is "+getId().getExpressionId()+
        //     ", currentId is "+getCurrentId()+
        //     ", children.size() is "+getChildren().size());

        if (getCurrentId()+1 >= getChildren().size())
        {
            //log.debug("reply() no more children, replying to parent.");

            //ValueUtils.cleanBooleanResult(wi);

            replyToParent(wi);
            return;
        }

        final boolean booleanResult = ValueUtils.lookupBooleanResult(wi);

        if (booleanResult)
            //
            // eval next (if present)
        {
            this.setConditionTreated(true);

            setCurrentId(getCurrentId()+1);
        }
        else
            //
            // else : eval next+1
        {
            this.removeBranch(getCurrentId()+1);

            if (getCurrentId()+2 >= getChildren().size())
            {
                //log.debug
                //    ("reply() no 'over-next' child, replying to parent.");

                //ValueUtils.cleanBooleanResult(wi);

                replyToParent(wi);
                return;
            }

            setCurrentId(getCurrentId()+2);
        }

        this.storeItself();

        try
        {
            //log.debug("reply() eval child index "+getCurrentId());

            getExpressionPool().apply
                ((FlowExpressionId)getChildren().get(getCurrentId()), wi);
        }
        catch (final ApplyException ae)
        {
            throw new ReplyException
                ("Failed to apply child expression at index "+getCurrentId(), 
                 ae);
        }
    }

    /**
     * Removes branches that have not been executed (this method is called
     * upon termination of the case expression work).
     */
    protected void removeRemainingBranches ()
    {
        for (int i=this.getCurrentId()+1; i<this.getChildren().size(); i++)
        {
            //log.debug
            //    ("removeRemainingBranches() "+
            //     "["+i+"] --> "+this.getChildren().get(i));

            this.removeBranch(i);
        }
    }

    /**
     * Overrides parent implementation, just to make sure all the unused
     * children get removed from the expression pool.
     */
    public void replyToParent (final InFlowWorkItem wi)
        throws ReplyException
    {
        removeRemainingBranches();

        super.replyToParent(wi);
    }

}
