/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ComparisonExpression.java 2667 2006-05-24 22:33:06Z jmettraux $
 */

//
// ComparisonExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * The base abstract class for all comparison expressions.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-05-25 00:33:06 +0200 (Thu, 25 May 2006) $
 * <br>$Id: ComparisonExpression.java 2667 2006-05-24 22:33:06Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class ComparisonExpression

    extends ZeroChildExpression

    implements BooleanExpression

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ComparisonExpression.class.getName());
    */

    //
    // CONSTANTS

    public final static String EQUALS = "equals";
    public final static String OTHER_PREFIX = "other-";

    /**
     * When the attribute 'type' is set in the comparison expression,
     * then, both values must be of that type.
     */
    public final static String TYPE = "type";
    
    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // ABSTRACT METHODS

    /**
     * In order not to be abstract, extension of this class have to implement 
     * this method that tells how to determine the result of the comparison.
     */
    protected abstract Boolean computeResult 
        (Integer numericResult, InFlowWorkItem wi);

    //
    // METHODS

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        final Integer result = compareValues(wi);

        //getExpressionPool().setVariableInParent
        //    (this, ValueUtils.BOOLEAN_RESULT, computeResult(result, wi));
        ValueUtils.setBooleanResult(wi, computeResult(result, wi));

        //log.debug
        //    ("apply() applying to parent\nchild : "+this.getId()+
        //     "  --->  "+this.getParent());

        applyToParent(wi);
    }

    /**
     * Return true if the "equals" attribute of the expression in the process
     * definition is flagged to 'true' or 'ok'.
     */
    public boolean orEquals (final InFlowWorkItem wi)
    {
        final String sEquals = lookupAttribute(EQUALS, wi);

        return
            ("true".equalsIgnoreCase(sEquals) ||
             "ok".equalsIgnoreCase(sEquals));
    }

    /**
     * Does the job of comparing the values (and return an int result).
     */
    protected Integer compareValues (final InFlowWorkItem wi)
        throws ApplyException
    {
        Object value = null;
        Object otherValue = null;

        try
        {
            value = determineValue(wi);
            otherValue = determineOtherValue(wi);
        }
        catch (final ApplyException ae)
        {
            //log.debug("compareValues() a value couldn't get determined", ae);
            return null;
        }

        /* ** some debug **
        Object svalue = value;
        if (svalue == null) svalue = "__null__";
        Object sotherValue = otherValue;
        if (sotherValue == null) sotherValue = "__null__";

        log.debug("value       >"+svalue+"<   ("+svalue.getClass().getName()+")");
        log.debug("otherValue  >"+sotherValue+"<   ("+sotherValue.getClass().getName()+")");
        log.debug("equals ? "+svalue.toString().equals(sotherValue.toString()));
        log.debug("compare ? "+svalue.toString().compareTo(sotherValue.toString()));
        ** . ** */

        if (value == null && otherValue == null)
        {
            // NULL == NULL : true

            return new Integer(0);
        }
        else if (value == null || otherValue == null)
        {
            if (value == null) return new Integer(-1);
            return new Integer(1);
        }

        return 
            new Integer(openwfe.org.Utils.compareValues(value, otherValue));
    }

    protected Object determineValue (InFlowWorkItem wi)
        throws ApplyException
    {
        try
        {
            return ValueUtils.determineValue(this, wi);
        }
        catch (ValueException ve)
        {
            throw new ApplyException
                ("Failed to determine value for comparison", ve);
        }
    }

    protected Object determineOtherValue (InFlowWorkItem wi)
        throws ApplyException
    {
        try
        {
            return ValueUtils.determineValue(OTHER_PREFIX, this, wi);
        }
        catch (ValueException ve)
        {
            throw new ApplyException
                ("Failed to determine other value for comparison", ve);
        }
    }

}
