/*
 * Copyright (c) 2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id$
 */

//
// ListRotateExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * Turns a 'flat' field into a series of fiels or vice versa.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id$ </font>
 * <br>$Rev$ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ListRotateExpression

    extends ZeroChildExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ListRotateExpression.class.getName());

    //
    // CONSTANTS & co

    public final static String A_FIELD_NAME
        = "field";

    public final static String A_SEPARATOR
        = "separator";

    public final static String DEFAULT_SEPARATOR
        = ",";

    //private final static String UU = "__";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        //
        // gather params

        final String fieldName = this.lookupAttribute(A_FIELD_NAME, wi);

        String separator = this.lookupAttribute(A_SEPARATOR, wi);
        if (separator == null) separator = DEFAULT_SEPARATOR;

        //
        // do the job

        final Attribute a = wi.getAttributes().getField(fieldName);

        if (a == null)
        {
            if (log.isDebugEnabled())
            {
                log.debug
                    ("apply() "+
                     "cannot perform rotation, no field named '"+fieldName+"'");
            }
        }
        else
        {
            if (a instanceof ListAttribute)
                flatten(wi, fieldName, ((ListAttribute)a), separator);
            else
                expand(wi, fieldName, a, separator);
        }

        //
        // done

        applyToParent(wi);
    }

    //
    // METHODS

    private void flatten 
        (final InFlowWorkItem wi, 
         final String fieldName, 
         final ListAttribute la,
         final String separator)
    {
        StringBuffer sb = new StringBuffer();

        final java.util.Iterator it = la.iterator();
        while (it.hasNext())
        {
            final Attribute a = (Attribute)it.next();

            if (sb.length() > 0) sb.append(separator);

            sb.append(a.toString());
        }

        wi.getAttributes().puts(fieldName, sb.toString());

        if (log.isDebugEnabled())
            log.debug("flatten() '"+fieldName+"' -> '"+sb.toString()+"'");
    }

    private void expand
        (final InFlowWorkItem wi, 
         final String fieldName, 
         final Attribute a,
         String separator)
    {
        if (separator.equals("|")) separator = "\\|";
            //
            // there may be other special cases, but for now, it's sufficient

        //
        // do the job

        final String value = a.toString();

        final String[] ss = value.split(separator);

        final ListAttribute la = new ListAttribute(ss.length);

        for (int i=0; i<ss.length; i++)
        {
            la.add(new StringAttribute(ss[i]));

            if (log.isDebugEnabled())
                log.debug("expand() "+i+" -> '"+ss[i]+"'");
        }

        wi.getAttributes().put(fieldName, la);
    }

    //
    // STATIC METHODS

}
