/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SaveExpression.java 2668 2006-05-25 15:15:15Z jmettraux $
 */

//
// SaveExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * Saves the current workitem in a variable
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-05-25 17:15:15 +0200 (Thu, 25 May 2006) $
 * <br>$Id: SaveExpression.java 2668 2006-05-25 15:15:15Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class SaveExpression

    extends ZeroChildExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SaveExpression.class.getName());

    //
    // CONSTANTS

    /**
     * The 'save' expression only used a 'to-variable' attribute to 
     * determine where to put the saved workitem
     */
    public final static String A_TO_VARIABLE 
        = "to-variable";
    
    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        final String variableName = lookupAttribute(A_TO_VARIABLE, wi);

        if (variableName == null)
        {
            log.warn
                ("apply() no attribute '"+
                 A_TO_VARIABLE+"' for expression, cannot set anything.");
        }
        else
        {
            //
            // do the job

            //this.setVariable(variableName, wi.clone());
            getExpressionPool().setVariable(this, variableName, wi.clone());

            if (log.isDebugEnabled())
                log.debug("apply() saved the wi in '"+variableName+"'");
        }

        applyToParent(wi);
    }

}
