/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: TimeoutUtils.java 2575 2006-05-08 11:52:39Z jmettraux $
 */

//
// TimeoutUtils.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.time.Time;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * Methods for determining expressions' timeout (for 'participant' and 'when') 
 * mainly.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: TimeoutUtils.java 2575 2006-05-08 11:52:39Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class TimeoutUtils
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(TimeoutUtils.class.getName());

    //
    // CONSTANTS & co

    //
    // CONSTRUCTORS

    /*
     * making it private, so that the class cannot be extended
     * and instantiated.
     */
    private TimeoutUtils ()
    {
        super();
    }

    //
    // STATIC METHODS

    /**
     * Looks for timeout info in expression attribute, then in the variables.
     */
    public static Long determineTimeout 
        (final FlowExpression fe, final InFlowWorkItem wi)
    { 
        //long timeOut = -2;
        Long timeOut = null;

        //
        // determine time out at expression level (highest priority)

        //if (wi != null)
        //{
        String sTimeOut = 
            fe.lookupAttribute(ExpressionWithTimeOut.TIMEOUT, wi);

        //if (sTimeOut != null) 
        timeOut = determineTimeout(sTimeOut);
        //}

        //
        // determine time out at variable level (even at engine level)

        if (timeOut == null)
        {
            sTimeOut = (String)fe
                .lookupVariable(ExpressionWithTimeOut.V_TIMEOUT);

            if (sTimeOut != null) 
                timeOut = determineTimeout(sTimeOut);
        }

        return timeOut;
    }

    /**
     * Turns the String representation of a duration into its long value.
     */
    public static Long determineTimeout (String sTimeOut)
    {
        //if (sTimeOut == null) return -2;
        if (sTimeOut == null) return null;

        sTimeOut = sTimeOut.toLowerCase();

        if (sTimeOut.equals("no") || 
            sTimeOut.equals("none") || 
            sTimeOut.equals("never") || 
            sTimeOut.equals("-1"))
        {
            return new Long(-1);
        }

        return new Long(Time.parseTimeString(sTimeOut));
    }

}
