/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractExpressionStore.java 2717 2006-06-01 15:26:06Z jmettraux $
 */

//
// AbstractExpressionStore.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.expool;

import openwfe.org.Utils;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.misc.MonitorMap;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expool.ExpressionStore;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.EngineEnvironmentId;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.ParticipantExpression;
import openwfe.org.engine.expressions.map.ExpressionMap;


/**
 * An implementation of ExpressionStore that stores expressions as xml files.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 17:26:06 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: AbstractExpressionStore.java 2717 2006-06-01 15:26:06Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AbstractExpressionStore

    extends AbstractService

    implements ExpressionStore

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AbstractExpressionStore.class.getName());

    //
    // CONSTANTS (definitions)

    //
    // FIELDS

    //private MonitorMap monitorMap = new MonitorMap();

    //
    // CONSTRUCTORS

    //
    // ABSTRACT METHODS

    //
    // METHODS from ExpressionStore

    /**
     * This method is used by the InMemoryExpressionStore when it
     * is restarted to fill its memory storage (the given map) again.
     */
    public synchronized void loadAll (final java.util.Map expressionMap)
        throws PoolException
    {
        final java.util.Iterator it = contentIterator(null);

        while (it.hasNext())
        {
            final FlowExpression fe = (FlowExpression)it.next();
            expressionMap.put(fe.getId(), fe);
        }
    }

    public synchronized Environment loadEngineEnvironment ()
    {
        try
        {
            return (Environment)loadExpression(EngineEnvironmentId.ID);
        }
        catch (final Exception e)
        {
            log.info
                ("Failed to load Engine Environment. "+
                 "Returning empty new one ( "+e+" )");

            Environment ee = new Environment();
            ee.setId(EngineEnvironmentId.ID);
            ee.setApplicationContext(this.getContext());

            try
            {
                storeExpression(ee);
            }
            catch (final PoolException pe)
            {
                log.warn
                    ("Failed to store Engine Environment. "+
                     "Resuming anyway...", 
                     pe);
            }

            return ee;
        }
    }

    //
    // METHODS

    /**
     * Returns the short name of the expression.
     * Is used by the contentIterator method implementations.
     */
    protected String[] determineExpressionShortNames 
        (final Class expressionClass)
    {
        if (expressionClass == null) return null;

        final ExpressionMap expMap = Definitions
            .getExpressionMap(getContext());

        return expMap.getNames(expressionClass);
    }

    /**
     * A shortcut method for extending classes : returns the
     * expression pool.
     */
    protected ExpressionPool getExpressionPool ()
    {
        return Definitions.getExpressionPool(getContext());
    }

    //
    // METHODS from Service

}
